package com.clustercontrol.cloud.presenter;


import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.annotation.Export;
import com.clustercontrol.cloud.commons.util.annotation.Import;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;

public class CloudStorageBackup extends InternalComponent<CloudStorageBackupManager, com.clustercontrol.ws.cloud.CloudStorageBackup> implements ICloudStorageBackup {
	
	private String accountResourceId;
    private String cloudUserId;
    private String description;
    private String storageBackupId;
    private String snapshotName;
    private Long regDate;
    private String regUser;
    private String region;
    private String restoreStatus;
    
    private String storageId;

    private String cloudTypeId;
    private BackupedData backupedData;
    
	public CloudStorageBackup(CloudStorageBackupManager container) {
		super(container);
	}
	
	@Override
	@Export
	public String getStorageId() {
		return storageId;
	}
	
	@Import
	public void setStorageId(String storageId) {
		internalSet("storageId", p2.storageId, storageId);
	}

	@Override
	@Export
	public String getRegion() {
		return region;
	}
	
	@Import
	public void setRegion(String region) {
		internalSet("region", p2.region, region);
	}

	@Override
	@Export
	public Long getRegDate() {
		return regDate;
	}
	
	@Import
	public void setRegDate(Long regDate) {
		internalSet("regDate", p2.regDate, regDate);
	}
	
	@Override
	@Export
	public String getRegUser() {
		return regUser;
	}
	
	@Import
	public void setRegUser(String regUser) {
		internalSet("regUser", p2.regUser, regUser);
	}
	

	@Override
	@Export
	public String getCloudUserId() {
		return cloudUserId;
	}

	@Import
	public void setCloudUserId(String cloudUserId) {
		internalSet("cloudUserId", p2.cloudUserId, cloudUserId);
	}

	@Override
	@Export
	public String getRestoreStatus() {
		return restoreStatus;
	}

	@Import
	public void setRestoreStatus(String restoreStatus) {
		internalSet("restoreStatus", p2.restoreStatus, restoreStatus);
	}

	@Override
	@Export
	public String getSnapshotName() {
		return snapshotName;
	}

	@Import
	public void setSnapshotName(String snapshotName) {
		internalSet("snapshotName", p2.snapshotName, snapshotName);
	}

	@Override
	@Export
	public String getStorageBackupId() {
		return storageBackupId;
	}

	@Import
	public void setStorageBackupId(String storageBackupId) {
		internalSet("storageBackupId", p2.storageBackupId, storageBackupId);
	}

	@Override
	@Export
	public String getDescription() {
		return description;
	}

	@Import
	public void setDescription(String description) {
		internalSet("description", p2.description, description);
	}

	@Override
	@Export
	public String getAccountResourceId() {
		return accountResourceId;
	}

	@Import
	public void setAccountResourceId(String accountResourceId) {
		internalSet("accountResourceId", p2.accountResourceId, accountResourceId);
	}

	@Override
	@Export
	public String getCloudTypeId() {
		return cloudTypeId;
	}

	@Import
	public void setCloudTypeId(String cloudTypeId) {
		internalSet("cloudTypeId", p2.cloudTypeId, cloudTypeId);
	}

	@Override
	public BackupedData getBackupedData() {
		return backupedData;
	}
	public void setBackupedData(BackupedData backupedData) {
		internalSet("backupedData", p2.backupedData, backupedData);
	}

	@Override
	public CloudStorageBackupManager getCloudStorageBackupManager() {
		return getContainer();
	}
	
	@Override
	public boolean equalValues(com.clustercontrol.ws.cloud.CloudStorageBackup source) {
		return this.storageId.equals(source.getStorageBackupId());
	}
	
	public static CloudStorageBackup createCloudStorageBackup(CloudStorageBackupManager cloudStorageManager, com.clustercontrol.ws.cloud.CloudStorageBackup source) {
		CloudStorageBackup cloudStorage = new CloudStorageBackup(cloudStorageManager);
		cloudStorage.overwrite(source);
		return cloudStorage;
	}

	@Override
	public com.clustercontrol.ws.cloud.CloudStorageBackup getSource() throws CloudModelException {
		try {
			return getEndpoint().getStorageBackup(getCloudStorageBackupManager().getRegion().getAccountResource().getActiveUser().getRoleId(), region, storageBackupId);
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	protected void overwrite(com.clustercontrol.ws.cloud.CloudStorageBackup source) {
		ControlUtil.importObject(this, source);
		if(source.getBackupedData() != null){
			ControlUtil.importObject(this, source.getBackupedData());
		}
		if(source.getRestoreStatus() != null){
			setRestoreStatus(source.getRestoreStatus().value());
		}
		setCloudTypeId(internalGetCloudTypeId());
		setBackupedData(new BackupedData(source.getBackupedData().getFlavor(), source.getBackupedData().getZone(), source.getBackupedData().getSize(), source.getBackupedData().getStorageDetail()));
	}

	private CloudEndpoint getEndpoint(){
		return this.getCloudStorageBackupManager().getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
	}
	
	
//
//	private String getRoleId(){
//		return getCloudStorageBackupManager().getRegion().getAccountResource().getActiveUser().getRoleId();
//	}
	
	private String internalGetCloudTypeId(){
		String cloudServiceId = getCloudStorageBackupManager().getCloudComputeService().getRegion().getAccountResource().getCloudServiceId();
		String cloudTypeId = getCloudStorageBackupManager().getCloudComputeService().getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getCloudServiceManager().getCloudService(cloudServiceId).getCloudTypeId();
		return cloudTypeId;
	}
}
