package com.clustercontrol.cloud.presenter;

import java.util.List;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.AccountResource.Region;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;

public class CloudStorageManager extends InternalContainer<CloudStorage, com.clustercontrol.ws.cloud.CloudStorage> implements ICloudStorageManager {
	private CloudComputeService cloudComputeService;
	
	public CloudStorageManager(CloudComputeService cloudComputeService) {
		this.cloudComputeService = cloudComputeService;
	}	
	
	@Override
	public Region getRegion() {
		return cloudComputeService.getRegion();
	}

	private CloudStorage internalGetCloudStorage(String cloudStorageId){
		for(CloudStorage cloudStorage: getComponents()){
			if(cloudStorage.getStorageId().equals(cloudStorageId)){
				return cloudStorage;
			}
		}
		return null;
	}
	
	@Override
	public CloudStorage[] getCloudStorages() {
		return getComponents().toArray(new CloudStorage[0]);
	}

	@Override
	public CloudStorage createCloudStorage(CreateStorageRequest createStorageRequest) {
		com.clustercontrol.ws.cloud.CreateStorageRequest wsCreateStorageRequest = new com.clustercontrol.ws.cloud.CreateStorageRequest();
		CreateStorageRequest request = new CreateStorageRequest();
		ControlUtil.importObject(request, createStorageRequest);
		ControlUtil.exportObject(request, wsCreateStorageRequest);
		
		try {
			com.clustercontrol.ws.cloud.CloudStorage reWsCloudStorage = getEndpoint().addStorage(getRoleId(), getRegion().getRegion(), wsCreateStorageRequest);
//			CloudStorage cloudStorage = new CloudStorage(this);
//			ControlUtil.importObject(cloudStorage, reWsCloudStorage);
			CloudStorage cloudStorage = createComponent(reWsCloudStorage);
			getComponents().add(cloudStorage);
			fireElementAdded(p2.cloudStorages, cloudStorage);
			
			return cloudStorage;
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	public void removeCloudStorage(String StorageId) {
		try {
			getEndpoint().removeStorage(getRoleId(), getRegion().getRegion(), StorageId);
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
		CloudStorage cloudStorage = internalGetCloudStorage(StorageId);
		getComponents().remove(cloudStorage);
		fireElementRemoved(p2.cloudStorages, cloudStorage);
	}

	@Override
	public CloudStorage restoreCloudStorage(RestoreCloudStorageRequest restoreCloudStorageRequest) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected List<com.clustercontrol.ws.cloud.CloudStorage> getSources() throws CloudModelException {
		try {
			return getEndpoint().getStoragesByRegion(getRoleId(), getRegion().getRegion());
		}
		catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	protected CloudStorage createComponent(com.clustercontrol.ws.cloud.CloudStorage source) throws CloudModelException {
		return CloudStorage.createCloudStorage(this, source);
	}

	@Override
	protected void fireComponentAdded(CloudStorage addedValue) {
		fireElementAdded(p2.cloudStorages, addedValue);
	}

	@Override
	protected void fireComponentRemoved(CloudStorage removedValue) {
		fireElementRemoved(p2.cloudStorages, removedValue);
	}
	
	private String getRoleId(){
		return getRegion().getAccountResource().getActiveUser().getRoleId();
	}

	@Override
	public CloudComputeService getCloudComputeService() {
		return cloudComputeService;
	}
	
	public CloudEndpoint getEndpoint(){
		return getCloudComputeService().getEndpoint();
	}
}
