package com.clustercontrol.cloud.presenter;

import java.util.List;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;

public class CloudUserManager extends InternalContainer<CloudUser, com.clustercontrol.ws.cloud.CloudUser> implements ICloudUserManager {
	private AccountResource accountResource;

	public CloudUserManager(AccountResource accountResource){
		this.accountResource = accountResource;
	}

	@Override
	public CloudUser getCloudUser(String cloudUserId) {
		for(CloudUser cloudUser: getComponents()){
			if(cloudUser.getCloudUserId().equals(cloudUserId)){
				return cloudUser;
			}
		}
		return null;
	}
	
	private List<CloudUser> getUsersList() {
		if (!isInitialized()) {
			update();
		}
		return getComponents();
	}
	
	@Override
	public CloudUser[] getCloudUsers() {
		return getComponents().toArray(new CloudUser[getComponents().size()]);
	}

	@Override
	public CloudUser createCloudUser(CreateCloudUserRequest createCloudUserRequest) {
		com.clustercontrol.ws.cloud.CreateCloudUserRequest wsCreateCloudUserRequest = new com.clustercontrol.ws.cloud.CreateCloudUserRequest();
		ControlUtil.exportObject(createCloudUserRequest, wsCreateCloudUserRequest);
		try {
			com.clustercontrol.ws.cloud.CloudUser reWsCloudUser = getEndpoint().addCloudUser(wsCreateCloudUserRequest);
			CloudUser cloudUser = new CloudUser(this);
			ControlUtil.importObject(cloudUser, reWsCloudUser);
			cloudUser.setCloudUserType(reWsCloudUser.getCloudUserType().name());
			getUsersList().add(cloudUser);
			fireElementAdded(ICloudUserManager.p2.cloudUsers, cloudUser);
			return cloudUser;
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	public void removeCloudUser(String cloudUserId) {
		try {
			getEndpoint().removeCloudUser(cloudUserId);
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
		CloudUser cloudUser = getCloudUser(cloudUserId);
		getUsersList().remove(cloudUser);
		fireElementRemoved(ICloudUserManager.p2.cloudUsers, cloudUser);
	}

	@Override
	public AccountResource getAccountResource() {
		return accountResource;
	}

	@Override
	protected List<com.clustercontrol.ws.cloud.CloudUser> getSources() throws CloudModelException {
		try {
			return getEndpoint().getCloudUsersByAccountResource(getAccountResource().getAccountResourceId());
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	protected CloudUser createComponent(com.clustercontrol.ws.cloud.CloudUser source) throws CloudModelException {
		CloudUser cloudUser = new CloudUser(this);
		cloudUser.overwrite(source);
		return cloudUser;
	}

	@Override
	protected void fireComponentAdded(CloudUser addedValue) {
		fireElementAdded(p2.cloudUsers, addedValue);
	}

	@Override
	protected void fireComponentRemoved(CloudUser removedValue) {
		fireElementRemoved(p2.cloudUsers, removedValue);
	}
	
	private CloudEndpoint getEndpoint(){
		return getAccountResource().getContainer().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
	}
}
