package com.clustercontrol.cloud.presenter;

import java.util.List;

import com.clustercontrol.cloud.resources.Tag;

public interface ICloudInstance extends IElement {
	public interface p2 {
		static final PropertyId2<ValueObserver2<String>> facilityId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> facilityName = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> instanceId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> instanceName = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> platform = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> cloudTypeId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> region = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> zone = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> publicDnsName = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> state = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> registState = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> type = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<Long>> regDate = new PropertyId2<ValueObserver2<Long>>();
		static final PropertyId2<ValueObserver2<String>> regUser = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<Long>> updateDate = new PropertyId2<ValueObserver2<Long>>();
		static final PropertyId2<ValueObserver2<String>> updateUser = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> cloudUserId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> flavor = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> imageId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> templateId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<List<BlockDeviceMapping>>> blockDeviceMappings = new PropertyId2<ValueObserver2<List<BlockDeviceMapping>>>();
		static final PropertyId2<ValueObserver2<List<Tag>>> tags = new PropertyId2<ValueObserver2<List<Tag>>>();
		static final PropertyId2<ValueObserver2<String>> detail = new PropertyId2<ValueObserver2<String>>();
	}

	String getFacilityId();	
	String getFacilityName();	
	String getInstanceId();	
	String getInstanceName();	
	String getPlatform();	
	String getCloudTypeId();	
	String getRegion();	
	String getZone();	
	String getPublicDnsName();	
	String getState();	
	String getRegistState();	
	String getType();	
	Long getRegDate();	
	String getRegUser();	
	Long getUpdateDate();	
	String getUpdateUser();
	
	String getFlavor();
	String getImageId();
	String getTemplateId();
	String getCloudUserId();
	List<Tag> getTags();
	List<BlockDeviceMapping> getBlockDeviceMappings();
	
	ICloudInstanceManager getCloudInstanceManager();
	
	// インスタンスの状態
	public enum StateType {
		pending("pending"),
		running("running"),
		shutting_down("shutting-down"),
		terminated("terminated"),
		stopping("stopping"),
		stopped("stopped"),
		rebooting("rebooting"),
		;
		
		private final String label;
		
		private StateType(String label) {
			this.label = label;
		}

		public String label() {
			return label;
		}
		
		public static StateType byLabel(String label) {
			String name = label.replace('-', '_');
			return valueOf(name);
		}
	}

	// インスタンスの状態
	public enum RegistStateType {
		registered((short)0),
		unregistered((short)1),
		deleted((short)2);

		private short num;
		
		private RegistStateType(short num) {
			this.num = num;
		}
		
		public short number() {
			return num;
		}
		
		public static RegistStateType byNumber(short num) {
			for (RegistStateType type: RegistStateType.values()) {
				if (type.number() == num) {
					return type;
				}
			}
			return null;
		}
	}
	
	void start();
	void stop();
	
	void attachStorage(String storageId, String deviceName);
	void detachStorage(String storageId);
	
	void registNode(RegistNodeRequest registNodeRequest);
	void start(RunJobRequest runJobRequest);
	void stop(RunJobRequest runJobRequest);
	
	void establishAgentConnection();
}