package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.presenter.StorageAttachment;

public interface ICloudStorage extends IElement {
	// プロパティの Id
	interface p2 {
		static final PropertyId2<ValueObserver2<String>> storageId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> storageName = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> facilityId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> facilityName = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> snapshotId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> cloudTypeId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<Integer>> deviceIndex = new PropertyId2<ValueObserver2<Integer>>();
		static final PropertyId2<ValueObserver2<String>> deviceName = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> deviceType = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> state = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> zone = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<Integer>> size = new PropertyId2<ValueObserver2<Integer>>();
		static final PropertyId2<ValueObserver2<StorageAttachment>> storageAttachment = new PropertyId2<ValueObserver2<StorageAttachment>>();
		static final PropertyId2<ValueObserver2<String>> flavor = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> region = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> registState = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<Long>> regDate = new PropertyId2<ValueObserver2<Long>>();
		static final PropertyId2<ValueObserver2<String>> regUser = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<Long>> updateDate = new PropertyId2<ValueObserver2<Long>>();
		static final PropertyId2<ValueObserver2<String>> updateUser = new PropertyId2<ValueObserver2<String>>();
	}
	ICloudStorageManager getCloudStorageManager();

	String getStorageId();
	String getStorageName();
	String getCloudTypeId();
	String getState();
	String getSnapshotId();
	String getFlavor();
	String getFacilityId();
	String getFacilityName();
	Integer getDeviceIndex();
	String getDeviceType();
	String getDeviceName();
	String getRegion();
	String getZone();
	Integer getSize();
	String getRegistState();
	StorageAttachment getStorageAttachment();
	Long getRegDate();
	Long getUpdateDate();
	String getRegUser();
	String getUpdateUser();
	
	void attach(String instanceId, String deviceName);
	void detach();

	// インスタンスの状態
	public enum RegistStateType {
		exist,
		deleted,
		;
	}
	
	public enum State {
		available,
		attached,
		;
	}
}
