package com.clustercontrol.cloud.presenter;



public interface ICloudStorageBackup extends IElement {
	public static class BackupedData {
		private final String flavor;
		private final String zone;
		private final Integer size;
		private final String storageDetail;

		public BackupedData(String flavor, String zone, Integer size,
				String storageDetail) {
			super();
			this.flavor = flavor;
			this.zone = zone;
			this.size = size;
			this.storageDetail = storageDetail;
		}

		public String getFlavor() {
			return flavor;
		}
		public String getZone() {
			return zone;
		}
		public Integer getSize() {
			return size;
		}
		public String getStorageDetail() {
			return storageDetail;
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result
					+ ((flavor == null) ? 0 : flavor.hashCode());
			result = prime * result + ((size == null) ? 0 : size.hashCode());
			result = prime * result
					+ ((storageDetail == null) ? 0 : storageDetail.hashCode());
			result = prime * result + ((zone == null) ? 0 : zone.hashCode());
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			BackupedData other = (BackupedData) obj;
			if (flavor == null) {
				if (other.flavor != null)
					return false;
			} else if (!flavor.equals(other.flavor))
				return false;
			if (size == null) {
				if (other.size != null)
					return false;
			} else if (!size.equals(other.size))
				return false;
			if (storageDetail == null) {
				if (other.storageDetail != null)
					return false;
			} else if (!storageDetail.equals(other.storageDetail))
				return false;
			if (zone == null) {
				if (other.zone != null)
					return false;
			} else if (!zone.equals(other.zone))
				return false;
			return true;
		}
	}

	public interface p2 {
		static final PropertyId2<ValueObserver2<String>> accountResourceId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> cloudUserId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> description = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> storageBackupId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> snapshotName = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> region = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> restoreStatus = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<Long>> regDate = new PropertyId2<ValueObserver2<Long>>();
		static final PropertyId2<ValueObserver2<String>> regUser = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> storageId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> cloudTypeId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<BackupedData>> backupedData = new PropertyId2<ValueObserver2<BackupedData>>();
	}
    
    String getAccountResourceId();
    String getCloudUserId();
    String getDescription();
    String getStorageBackupId();
    String getSnapshotName();
    Long getRegDate();
    String getRegUser();
    String getRegion();
    String getRestoreStatus();
    BackupedData getBackupedData();
    
    String getStorageId();
	
    String getCloudTypeId();
    
	ICloudStorageBackupManager getCloudStorageBackupManager();
	
	public enum RestoreStatus{
	    available,
	    unavailable,
	    ;
	}
}