package com.clustercontrol.cloud.ui.views.actions;
/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateCloudServiceDialog;
import com.clustercontrol.util.Messages;


public class CreateCloudServiceAction extends AbstractViewAction {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.CreateCloudUserAction";

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String msgCreateCloudServiceConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.cloud_service", "word.create"});
	private String msgCreateCloudServiceResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.cloud_service", "word.create"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		
		CreateCloudServiceDialog dialog = new CreateCloudServiceDialog(this.viewPart.getSite().getShell());
		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgCreateCloudServiceConfirm)) {
				
//				DialogOutput output = dialog.getOutput();
//				
//				ICloudServiceManager manager = Activator.getDefault().getCloudServiceManager();

				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgCreateCloudServiceResult);
			}
			else {
				return;
			}
		}
	}
}