/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.cloud.plugin.monitor;

import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
//import org.eclipse.swt.events.ModifyEvent;
//import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
//import org.eclipse.swt.widgets.Text;
//
//import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.plugin.monitor.MonitorBasicScopeComposite.IChangeFacilityIdListener;
import com.clustercontrol.monitor.util.MonitorSettingEndpointWrapper;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.MonitorDuplicate_Exception;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.monitor.MonitorPluginStringInfo;
import com.clustercontrol.ws.monitor.PluginCheckInfo;

/**
 * ping監視作成・変更ダイアログクラス<BR>
 * 
 * @version 4.0.0
 * @since 2.0.0
 */
public class CreateBillingMonitorDialog extends CommonMonitorNumericDialog {
	MessageManager messages = MessageManager.getInstance("messages");
	
	String strFee = messages.getString("word.fee");
	String strTarget = messages.getString("word.target");
	String strSeparator = messages.getString("caption.title_separator");
	String msgSelectTarget = messages.getString("message.select_subject", new Object[]{"word.target"});
	String msgSelectScope = messages.getString("message.select_subject", new Object[]{"word.scope"});
	

	// ログ
//	private static Log m_log = LogFactory.getLog( CreateBillingMonitorDialog.class );
	Logger logger = Logger.getLogger(this.getClass());

//	// ----- instance フィールド ----- //
//	/** タイムアウト用テキストボックス */
//	private Text m_textTimeout = null;

	/** ターゲット */
	private Combo cmbTarget = null;

	// ----- コンストラクタ ----- //

	/**
	 * 作成用ダイアログのインスタンスを返します。
	 * 
	 * @param parent
	 *            親のシェルオブジェクト
	 */
	public CreateBillingMonitorDialog(Shell parent) {
		super(parent);
	}

	/**
	 * 変更用ダイアログのインスタンスを返します。
	 * 
	 * @param parent
	 *            親のシェルオブジェクト
	 * @param monitorId
	 *            監視ID
	 * @param updateFlg
	 *            更新するか否か（true:変更、false:新規登録）
	 * @wbp.parser.constructor
	 */
	public CreateBillingMonitorDialog(Shell parent, String monitorId, boolean updateFlg) {
		super(parent);

		this.monitorId = monitorId;
		this.updateFlg = updateFlg;
	}

	// ----- instance メソッド ----- //

	/**
	 * ダイアログエリアを生成します。
	 * 
	 * @param parent
	 *            親のインスタンス
	 */
	@Override
	protected void customizeDialog(Composite parent) {
		item1 = Messages.getString("select.value");
		item2 = Messages.getString("select.value");

		super.customizeDialog(parent);

		// タイトル
		shell.setText(BillingMonitor.monitorName);

		// 変数として利用されるラベル
		Label label = null;
		// 変数として利用されるグリッドデータ
		GridData gridData = null;

		/*
		 * チェック設定グループ（条件グループの子グループ）
		 */
		Group groupCheckRule = new Group(groupRule, SWT.NONE);
		GridLayout layout = new GridLayout(1, true);
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.numColumns = 15;
		groupCheckRule.setLayout(layout);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		groupCheckRule.setLayoutData(gridData);
		groupCheckRule.setText(Messages.getString("check.rule"));


		/*
		 * ターゲット
		 */
		// ラベル
		label = new Label(groupCheckRule, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_TITLE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(strTarget + strSeparator);
		// コンボボックス
		this.cmbTarget = new Combo(groupCheckRule, SWT.DROP_DOWN | SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_TEXT;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.cmbTarget.setLayoutData(gridData);

		// 空白
		label = new Label(groupCheckRule, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 8;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		
//		/*
//		 * タイムアウト
//		 */
//		// ラベル
//		label = new Label(groupCheckRule, SWT.NONE);
//		gridData = new GridData();
//		gridData.horizontalSpan = WIDTH_TITLE;
//		gridData.horizontalAlignment = GridData.FILL;
//		gridData.grabExcessHorizontalSpace = true;
//		label.setLayoutData(gridData);
//		label.setText(Messages.getString("time.out") + " : ");
//
//		// テキスト
//		this.m_textTimeout = new Text(groupCheckRule, SWT.BORDER);
//		gridData = new GridData();
//		gridData.horizontalSpan = WIDTH_VALUE;
//		gridData.horizontalAlignment = GridData.FILL;
//		gridData.grabExcessHorizontalSpace = true;
//		this.m_textTimeout.setLayoutData(gridData);
//		this.m_textTimeout.addModifyListener(new ModifyListener(){
//			@Override
//			public void modifyText(ModifyEvent arg0) {
//				update();
//			}
//		});
//
//		// ラベル（単位）
//		label = new Label(groupCheckRule, SWT.NONE);
//		gridData = new GridData();
//		gridData.horizontalSpan = WIDTH_VALUE;
//		gridData.horizontalAlignment = GridData.FILL;
//		gridData.grabExcessHorizontalSpace = true;
//		label.setLayoutData(gridData);
//		label.setText(Messages.getString("milli.sec"));

		// 空白
		label = new Label(groupCheckRule, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 7;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);

		// 収集値表示名のデフォルト値を設定
//		this.itemName.setText(Messages.getString("response.time"));
		this.itemName.setText(strFee);
		

		// 収集値単位のデフォルト値を設定
//		this.measure.setText(Messages.getString("time.msec"));

		// 閾値検証フラグを設定
		this.m_numericValueInfo.setRangeFlg(false);

		// ダイアログを調整
		this.adjustDialog();

		// 初期表示
		MonitorInfo info = null;
		if(this.monitorId == null){
			// 作成の場合
			info = new MonitorInfo();
			this.setInfoInitialValue(info);
		} else {
			// 変更の場合、情報取得
			try {
				info = MonitorSettingEndpointWrapper.getMonitor(this.monitorId, BillingMonitor.monitorPluginId);
			} catch (InvalidRole_Exception e) {
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(
						null,
						Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));

			} catch (Exception e) {
				// 上記以外の例外
				logger.warn("customizeDialog(), " + e.getMessage(), e);
				MessageDialog.openInformation(
						null,
						Messages.getString("message"),
						Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());

			}
		}
		
		m_monitorBasic.addChangeFacilityIdListener(new IChangeFacilityIdListener(){
			private String lastFacilityId = null;
			@Override
			public void facilityIdChanged() {
				if(lastFacilityId == null){
					if(m_monitorBasic.getFacilityId() == null){
						return;
					} else {
						setupCmbTarget();
					}
				} else {
					if(m_monitorBasic.getFacilityId() == null){
						cmbTarget.clearSelection();
						cmbTarget.removeAll();
					} else if(!lastFacilityId.equals(m_monitorBasic.getFacilityId())){
						setupCmbTarget();
					}
				}
				lastFacilityId = m_monitorBasic.getFacilityId();
			}
		});

		
		cmbTarget.addMouseListener(new MouseAdapter(){
			@Override
			public void mouseDown(MouseEvent e){
					assert m_monitorBasic != null;
					if(m_monitorBasic.getFacilityId() == null || m_monitorBasic.getFacilityId().isEmpty()){
						MessageDialog.openInformation(
								null,
								Messages.getString("failed"),
								msgSelectScope);
					}
			}
		});
		
		this.setInputData(info);

	}


	/**
	 * 更新処理
	 * 
	 */
	@Override
	public void update(){
		super.update();

//		// 必須項目を明示
//		if(this.m_textTimeout.getEnabled() && "".equals(this.m_textTimeout.getText())){
//			this.m_textTimeout.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
//		}else{
//			this.m_textTimeout.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
//		}
	}


	/**
	 * 各項目に入力値を設定します。
	 * 
	 * @param monitor
	 *            設定値として用いる通知情報
	 */
	@Override
	protected void setInputData(MonitorInfo monitor) {
		super.setInputData(monitor);

		this.inputData = monitor;

		if(inputData.getFacilityId() != null && !inputData.getFacilityId().isEmpty()){
			setupCmbTarget();
		}
		
		// 監視条件クラウド課金監視情報
		PluginCheckInfo info = monitor.getPluginCheckInfo();
		if (info != null && info.getMonitorPluginStringInfoList() != null && !info.getMonitorPluginStringInfoList().isEmpty()) {
			MonitorPluginStringInfo stringInfo = info.getMonitorPluginStringInfoList().get(0);
			if(cmbTarget.indexOf(stringInfo.getValue()) != -1){
				this.cmbTarget.select(cmbTarget.indexOf(stringInfo.getValue()));
			}
		}
		
		m_numericValueInfo.setInputData(monitor);
	}

	/**
	 * 入力値を用いて通知情報を生成します。
	 * 
	 * @return 入力値を保持した通知情報
	 */
	@Override
	protected MonitorInfo createInputData() {
		super.createInputData();
		if(validateResult != null){
			return null;
		}

		if(cmbTarget.getText() == null || cmbTarget.getText().isEmpty()){
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					msgSelectTarget);
			return null;
		}
		
		// クラウド課金監視固有情報を設定
		monitorInfo.setMonitorTypeId(BillingMonitor.monitorPluginId);

		// 監視条件 クラウド課金監視情報
		PluginCheckInfo pluginInfo = new PluginCheckInfo();
		pluginInfo.setMonitorId(monitorInfo.getMonitorId());

		pluginInfo.setMonitorTypeId(BillingMonitor.monitorPluginId);
		//TODO 
		MonitorPluginStringInfo stringInfo = new MonitorPluginStringInfo();
		stringInfo.setMonitorId(monitorInfo.getMonitorId());
		stringInfo.setKey("target");
		stringInfo.setValue((String)cmbTarget.getData(cmbTarget.getText()));
		pluginInfo.getMonitorPluginStringInfoList().add(stringInfo);
		
		monitorInfo.setPluginCheckInfo(pluginInfo);

		// 結果判定の定義
		validateResult = m_numericValueInfo.createInputData(monitorInfo);
		if(validateResult != null){
			return null;
		}

		// 通知関連情報とアプリケーションの設定
		// 通知グループIDの設定
		monitorInfo.setNotifyGroupId(NotifyGroupIdGenerator.createNotifyGroupId(BillingMonitor.monitorPluginId, pluginInfo.getMonitorId()));
		validateResult = m_notifyInfo.createInputData(monitorInfo);
		if (validateResult != null) {
			if(validateResult.getID() == null){	// 通知ID警告用出力
				if(!displayQuestion(validateResult)){
					validateResult = null;
					return null;
				}
			}
			else{	// アプリケーション未入力チェック
				return null;
			}
		}

		return monitorInfo;
	}

	/**
	 * 入力値をマネージャに登録します。
	 * 
	 * @return true：正常、false：異常
	 * 
	 * @see com.clustercontrol.dialog.CommonDialog#action()
	 */
	@Override
	protected boolean action() {
		boolean result = false;

		MonitorInfo info = this.inputData;
		if(info != null){
			String[] args = { info.getMonitorId() };
			if(!this.updateFlg){
				// 作成の場合
				try {
					result = MonitorSettingEndpointWrapper.addMonitor(info);

					if(result){
						MessageDialog.openInformation(
								null,
								Messages.getString("successful"),
								Messages.getString("message.monitor.33", args));
					} else {
						MessageDialog.openError(
								null,
								Messages.getString("failed"),
								Messages.getString("message.monitor.34", args));
					}
				} catch (MonitorDuplicate_Exception e) {
					// 監視項目IDが重複している場合、エラーダイアログを表示する
					MessageDialog.openInformation(
							null,
							Messages.getString("message"),
							Messages.getString("message.monitor.53", args));

				} catch (Exception e) {
					String errMessage = "";
					if (e instanceof InvalidRole_Exception) {
						// アクセス権なしの場合、エラーダイアログを表示する
						MessageDialog.openInformation(
								null,
								Messages.getString("message"),
								Messages.getString("message.accesscontrol.16"));
					} else {
						errMessage = ", " + e.getMessage();
					}

					MessageDialog.openError(
							null,
							Messages.getString("failed"),
							Messages.getString("message.monitor.34", args) + errMessage);

				}

			}
			else{
				// 変更の場合
				String errMessage = "";
				try {
					result = MonitorSettingEndpointWrapper.modifyMonitor(info);
				} catch (InvalidRole_Exception e) {
					// アクセス権なしの場合、エラーダイアログを表示する
					MessageDialog.openInformation(
							null,
							Messages.getString("message"),
							Messages.getString("message.accesscontrol.16"));
				} catch (Exception e) {
					errMessage = ", " + e.getMessage();
				}

				if(result){
					MessageDialog.openInformation(
							null,
							Messages.getString("successful"),
							Messages.getString("message.monitor.35", args));
				}
				else{
					MessageDialog.openError(
							null,
							Messages.getString("failed"),
							Messages.getString("message.monitor.36", args) + errMessage);
				}
			}
		}

		return result;
	}

	/**
	 * MonitorInfoに初期値を設定します
	 * 
	 * @see com.clustercontrol.dialog.CommonMonitorDialog#setInfoInitialValue()
	 */
	@Override
	protected void setInfoInitialValue(MonitorInfo monitor) {
		super.setInfoInitialValue(monitor);
	}

	private void setupCmbTarget(){
		cmbTarget.removeAll();
		try {
			List<String> billingServices = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class).getCloudServicesForBilling(m_monitorBasic.getFacilityId());
			if(billingServices != null){
				for(String service: billingServices){
					CreateBillingMonitorDialog.this.cmbTarget.add(service);
					CreateBillingMonitorDialog.this.cmbTarget.setData(service, service);							
				}
			}
		} catch (CloudManagerFault_Exception | com.clustercontrol.ws.cloud.InvalidRole_Exception | InvalidUserPass_Exception e1) {
			e1.printStackTrace();
		}
	}
}