package com.clustercontrol.cloud.presenter;

import java.util.List;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.plugin.decorator.IAccountResourceDecorator;
import com.clustercontrol.ws.cloud.CloudAccountResource;
import com.clustercontrol.ws.cloud.CloudEndpoint;


public class AccountResourceManager extends InternalContainer<AccountResource, CloudAccountResource> implements IAccountResourceManager {
	private CloudResourceManager resourceManager;
	
	public AccountResourceManager(CloudResourceManager resourceManager) {
		this.resourceManager = resourceManager;
	}

	@Override
	public AccountResource[] getAccountResources() {
		return getComponents().toArray(new AccountResource[getComponents().size()]);
	}

	@Override
	public AccountResource getAccountResource(String accountResourceId) {
		for (AccountResource accountResource: getComponents()) {
			if (accountResource.getAccountResourceId().equals(accountResourceId)) {
				return accountResource;
			}
		}
		return null;
	}

	@Override
	public CloudResourceManager getCloudResourceManager() {
		return resourceManager;
	}

	@Override
	public List<CloudAccountResource> getSources() throws CloudModelException {
		try {
			return getCloudResourceManager().getEndpoint(CloudEndpoint.class).getAllAccountResources();
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	public AccountResource createComponent(CloudAccountResource source) throws CloudModelException {
		AccountResource accountResource =  AccountResource.createAccountResource(this, source);
		
		if(accountResource != null){
			for(IAccountResourceDecorator decorator: getCloudResourceManager().getARDecoratorProvider().getDecoratorList()){
				decorator.decorate(accountResource);
			}
		}
		
		return accountResource;
	}

	@Override
	public AccountResource createAccountResource(CreateAccountResourceRequest createAccountResourceRequest, CreateCloudUserRequest createCloudUserRequest) {
		com.clustercontrol.ws.cloud.CreateAccountResourceRequest wsCreateAccountResourceRequest = new com.clustercontrol.ws.cloud.CreateAccountResourceRequest();
		ControlUtil.exportObject(createAccountResourceRequest, wsCreateAccountResourceRequest);
		com.clustercontrol.ws.cloud.Account account = new com.clustercontrol.ws.cloud.Account();
		ControlUtil.exportObject(createCloudUserRequest, account);
		wsCreateAccountResourceRequest.setAccount(account);
		
		try {
			com.clustercontrol.ws.cloud.CloudAccountResource reWsAccountResource = getCloudResourceManager().getEndpoint(CloudEndpoint.class).addAccountResource(wsCreateAccountResourceRequest);
			AccountResource accountResource = createComponent(reWsAccountResource);
			getComponents().add(accountResource);
			fireElementAdded(p2.accountResources, accountResource);
			return accountResource;
		} catch (Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	public void removeAccountResource(String accountResourceId) {
		try {
			getCloudResourceManager().getEndpoint(CloudEndpoint.class).removeAccountResource(accountResourceId);
			AccountResource accountResource = getAccountResource(accountResourceId);
			getComponents().remove(accountResource);
			fireElementRemoved(p2.accountResources, accountResource);
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}
	
	@Override
	protected void fireComponentAdded(AccountResource addedValue) {
		fireElementAdded(IAccountResourceManager.p2.accountResources, addedValue);
	}

	@Override
	protected void fireComponentRemoved(AccountResource removedValue) {
		fireElementAdded(IAccountResourceManager.p2.accountResources, removedValue);
	}
}
