package com.clustercontrol.cloud.presenter;

import java.util.List;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.AccountResource.Region;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;

public class CloudStorageBackupManager extends InternalContainer<CloudStorageBackup, com.clustercontrol.ws.cloud.CloudStorageBackup> implements ICloudStorageBackupManager {
	private Region region;
	private CloudComputeService cloudComputeService;
	
	public CloudStorageBackupManager(CloudComputeService cloudComputeService) {
		this.cloudComputeService = cloudComputeService;
		this.region = cloudComputeService.getRegion();
	}
	
	@Override
	public Region getRegion() {
		return region;
	}

	public CloudStorageBackup getCloudStorageBackup(String cloudStorageBackupId){
		for(CloudStorageBackup cloudStorageBackup: getComponents()){
			if(cloudStorageBackup.getStorageBackupId().equals(cloudStorageBackupId)){
				return cloudStorageBackup;
			}
		}
		return null;
	}
	
	@Override
	public CloudStorageBackup[] getCloudStorageBackups() {
		return getComponents().toArray(new CloudStorageBackup[0]);
	}

	@Override
	public CloudStorageBackup backupCloudStorage(CreateStorageBackupRequest createStorageBackupRequest) {
		com.clustercontrol.ws.cloud.CreateStorageBackupRequest wsCreateCloudStorageBackupRequest = new com.clustercontrol.ws.cloud.CreateStorageBackupRequest();
		ControlUtil.exportObject(createStorageBackupRequest, wsCreateCloudStorageBackupRequest);
		try {
			com.clustercontrol.ws.cloud.CloudStorageBackup reWsCloudStorageBackup = getEndpoint().addStorageBackup(getRoleId(), region.getRegion(), wsCreateCloudStorageBackupRequest);
			CloudStorageBackup cloudStorageBackup = CloudStorageBackup.createCloudStorageBackup(this, reWsCloudStorageBackup);
			getComponents().add(cloudStorageBackup);
			fireComponentAdded(cloudStorageBackup);
			return cloudStorageBackup;
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	public void removeCloudStorageBackup(String storageBackupId) {
		try {
			getEndpoint().removeStorageBackup(getRoleId(), getRegion().getRegion(), storageBackupId);
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
		CloudStorageBackup cloudStorageBackup = getCloudStorageBackup(storageBackupId);
		getComponents().remove(cloudStorageBackup);
		fireComponentRemoved(cloudStorageBackup);
	}

	@Override
	protected List<com.clustercontrol.ws.cloud.CloudStorageBackup> getSources() throws CloudModelException {
		try {
			return getEndpoint().getStorageBackupsByRegion(getRoleId(), region.getRegion());
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	protected CloudStorageBackup createComponent(com.clustercontrol.ws.cloud.CloudStorageBackup source) throws CloudModelException {
		CloudStorageBackup cloudStorageBackup = new CloudStorageBackup(this);
		cloudStorageBackup.overwrite(source);
		return cloudStorageBackup;
	}

	@Override
	protected void fireComponentAdded(CloudStorageBackup addedValue) {
		fireElementAdded(p2.cloudStorageBackups, addedValue);
	}

	@Override
	protected void fireComponentRemoved(CloudStorageBackup removedValue) {
		fireElementRemoved(p2.cloudStorageBackups, removedValue);
	}
	
	private CloudEndpoint getEndpoint(){
		return getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
	}
	
	private String getRoleId(){
		return getRegion().getAccountResource().getActiveUser().getRoleId();
	}

	@Override
	public ICloudComputeService getCloudComputeService() {
		return cloudComputeService;
	}
}
