/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;



public class EventNotifier2 {
	private interface Command {
		void execute();
	}
	
	private Map<Object, List<?>> listenersMap = new HashMap<Object, List<?>>();
	private List<Command> commands = new ArrayList<Command>();
	protected int notifyingDepth = 0;

	public EventNotifier2() {
	}

	public <L extends EventListener> void addEventListeners(final Type<L> type, final L listener) {
		synchronized (listenersMap) {
			if (notifyingDepth == 0) {
				doAdd(type, listener);
			}
			else {
				commands.add(
					new Command() {
						@Override
						public void execute() {
							doAdd(type, listener);
						}
					});
			}
		}
	}
	
	private <L extends EventListener> void doAdd(Type<L> type, L listener) {
		@SuppressWarnings("unchecked")
		List<L> list = (List<L>)listenersMap.get(type);
		if (list == null) {
			list = new ArrayList<L>();
			listenersMap.put(type, list);
		}
		list.add(listener);
	}

	public <L extends EventListener> void removeEventListeners(final Type<L> type, final L listener) {
		synchronized (listenersMap) {
			if (notifyingDepth == 0) {
				doRemove(type, listener);
			}
			else {
				commands.add(
					new Command() {
						@Override
						public void execute() {
							doRemove(type, listener);
						}
					});
			}
		}
	}
	
	private <L extends EventListener> void doRemove(Type<L> type, L listener) {
		@SuppressWarnings("unchecked")
		List<L> list = (List<L>)listenersMap.get(type);
		if (list != null) {
			list.remove(listener);
		}
	}

	public <S, L extends EventListener> void fireEvent(Event<S, L> event) {
		synchronized (listenersMap) {
			++notifyingDepth;
			@SuppressWarnings("unchecked")
			List<L> list = (List<L>)listenersMap.get(event.getAssociatedType());
			if (list != null) {
				for (L listener: list) {
					event.dispatch(listener);
				}
			}
			for (Command c: commands) {
				c.execute();
			}
			--notifyingDepth;
		}
	}
}
