/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.resources;

import java.util.List;

public interface CloudResourceProvider {
	List<String> getAllRegion();
	List<AvailabilityZone> getAvailabilityZones(String regionName);
	List<Image> getImages(String regionName, List<Filter> filters);
	List<GroupIdentifier> getSecurityGroups(String regionName, List<Filter> filters);
	List<GroupIdentifier> getSecurityGroupsByRegion(String regionName);
	List<String> getAllInstanceType();
	List<String> getKeyNames(String regionName);
	List<Snapshot> getSnapshots(String regionName, List<Filter> filters);
	List<String> getAllVolumeType();
	List<String> getAllServiceName();
	List<Subnet> getSubnets(String regionName, List<Filter> filters);
	List<Subnet> getSubnetsByRegion(String regionName);
}