/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.ISelectionListener;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.cloud.presenter.IElement;
import com.clustercontrol.cloud.presenter.INode;
import com.clustercontrol.cloud.presenter.IScope;

public abstract class FilterlingViewPartByScopeTree<R extends IElement, E extends IElement , M> extends FilterlingViewPart<IRegion, R, E, M> implements ISelectionListener, IAROrientedView {
	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	private String zoneName;
	private String facilityId;

	private IAccountResource currentAccountResource;
	private IAccountResource nextAccountResource;

	protected Map<IRegion, String> resultMap = new HashMap<IRegion, String>();

	@Override
	protected boolean prepareFilterConditiion(String viweId, ISelection selection) {
		if (!viweId.equals(ScopeView.Id)) {
			return false;
		}
		
		if (!(selection instanceof IStructuredSelection)) {
			return false;
		}

		IStructuredSelection sselection = (IStructuredSelection)selection;
		if (sselection.isEmpty()) {
			return false;
		}
		
		try {
			IAccountResource accountResource = null;
			Object selected = sselection.getFirstElement();
			if (selected instanceof IScope) {
				IScope scope = (IScope)selected;
				
				switch(scope.getScopeType()) {
				case region:
					{
						accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(IScope.ScopeType.region.getAccountResourceId(scope));
						setNextState(accountResource != null ? accountResource.getRegion(IScope.ScopeType.region.getRegion(scope)): null);
						zoneName = null;
						facilityId = null;
					}
					break;
				case zone:
					{
						accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(IScope.ScopeType.region.getAccountResourceId(scope.getParent()));
						setNextState(accountResource != null ? accountResource.getRegion(IScope.ScopeType.region.getRegion(scope.getParent())): null);
						zoneName = scope.getFacilityId().replace(accountResource.getAccountResourceId() + "_", "");
						facilityId = null;
					}
					break;
				case root:
					{
						setNextState(null);
						zoneName = null;
						facilityId = null;
					}
					break;
				case account_resource_scope:
					{
						accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(IScope.ScopeType.account_resource_scope.getAccountResourceId(scope));
						setNextState(null);
						zoneName = null;
						facilityId = null;
					}
					break;
				default:
					return false;
				}
			}
			else if (selected instanceof INode) {
				INode node = (INode)selected;
				accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(IScope.ScopeType.region.getAccountResourceId(node.getParent().getParent()));
				setNextState(accountResource.getRegion(IScope.ScopeType.region.getRegion(node.getParent().getParent())));
				zoneName = node.getParent().getFacilityId().replace(accountResource.getAccountResourceId() + "_", "");
				facilityId = node.getFacilityId();
			}

			nextAccountResource = accountResource;
			if(nextAccountResource != null){
				if(!AccountControlUtil.isInitializedActiveUser(nextAccountResource.getAccountResourceId())){
					AccountControlUtil.selectActiveUser(getSite().getPage().findView(ScopeView.Id));
				}
			}
		}
		catch (Exception e) {
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e.getMessage(), e);
			
			return false;
		}
		
		return true;
	}

	protected String getHeaderByFacilityId(IRegion region, String facilityId) {
		return bundle_messages.getString("word.facility_id") + bundle_messages.getString("caption.title_separator") + facilityId;
	}
	
	protected String getHeaderByAvailabilityZone(IRegion region, String availabilityZone) {
		return bundle_messages.getString("word.region") + bundle_messages.getString("caption.title_separator") + region.getRegionName() + "\t" +
				bundle_messages.getString("word.zone") + bundle_messages.getString("caption.title_separator") + availabilityZone;
	}
	
	protected String getHeaderByRegion(IRegion region) {
		return bundle_messages.getString("word.region") + bundle_messages.getString("caption.title_separator") + region.getRegionName();
	}

	protected String getEmptyHeader() {
		return "";
	}
	
	@Override
	protected void startGetManagerData(IRegion region) {
		getLeftFooter().setText(bundle_messages.getString("caption.accessing_to", new String[]{region.getRegionName()}));
	}

	@Override
	protected boolean isMatch(E element) {
		return getCurrentState() != null && isMatchRegion(getCurrentState(), element) &&
			(zoneName == null || isMatchAvailabilityZone(zoneName, element)) &&
			(facilityId == null || isMatchFacilityId(facilityId, element));
	}
	
	protected abstract boolean isMatchRegion(IRegion region, E element);

	protected abstract boolean isMatchAvailabilityZone(String zoneName, E element);

	protected abstract boolean isMatchFacilityId(String facilityId, E element);

	protected abstract Label getHeaderLabel();
	
	protected abstract Label getLeftFooter();
	
	protected abstract Label getRightFooter();

	@Override
	protected void failedPrepareFilterConditiion(Exception exception) {
		super.failedPrepareFilterConditiion(exception);
		
		getHeaderLabel().setText("");
		
		if (exception instanceof CloudModelException) {
			getLeftFooter().setText(((CloudModelException)exception).getMessage());
		}
		else {
			getLeftFooter().setText(bundle_messages.getString("word.fail"));
		}

		getRightFooter().setText(bundle_messages.getString("word.view_item_count") + bundle_messages.getString("caption.title_separator") + getCurrentElements().size());
	}
	
	@Override
	protected void successGetManagerData(IRegion targetState, List<M> managerElements) {
		super.successGetManagerData(targetState, managerElements);
		resultMap.put(targetState, bundle_messages.getString("word.success"));
	}

	@Override
	protected void failedGetManagerData(IRegion targetState, Exception exception) {
		super.failedGetManagerData(targetState, exception);
		resultMap.put(targetState, bundle_messages.getString("word.fail"));
	}
	
	@Override
	protected void updateStatus() {
		if (getCurrentState() != null) {
			if (getActiveFacilityId() != null) {
				getHeaderLabel().setText(getHeaderByFacilityId(getCurrentState(), getActiveFacilityId()));
			}
			else if (getActiveZone() != null) {
				getHeaderLabel().setText(getHeaderByAvailabilityZone(getCurrentState(), getActiveZone()));
			}
			else {
				getHeaderLabel().setText(getHeaderByRegion(getCurrentState()));
			}
		}
		else {
			getHeaderLabel().setText(getEmptyHeader());
		}

		getLeftFooter().setText(resultMap.get(getCurrentState()) == null ? "": resultMap.get(getCurrentState()));

		getRightFooter().setText(bundle_messages.getString("word.view_item_count") + bundle_messages.getString("caption.title_separator") + getCurrentElements().size());
	}

	@Override
	protected void nextState() {
		IAccountResource oldAccountResource = currentAccountResource;
		
		super.nextState();

		currentAccountResource = nextAccountResource;
		
		// アカウントリソースが変更された場合に、ファイア。
		if (oldAccountResource != currentAccountResource) {
			firePropertyChange(Prop_AccountResource);
		}
	}
	
	@Override
	protected void updateStatus(Exception exception) {
		if (getCurrentState() != null) {
			if (getActiveFacilityId() != null) {
				getHeaderLabel().setText(getHeaderByFacilityId(getCurrentState(), getActiveFacilityId()));
			}
			else if (getActiveZone() != null) {
				getHeaderLabel().setText(getHeaderByAvailabilityZone(getCurrentState(), getActiveZone()));
			}
			else {
				getHeaderLabel().setText(getHeaderByRegion(getCurrentState()));
			}
		}
		else {
			getHeaderLabel().setText(getEmptyHeader());
		}

		getLeftFooter().setText(resultMap.get(getCurrentState()) == null ? "": resultMap.get(getCurrentState()));

		getRightFooter().setText(bundle_messages.getString("word.view_item_count") + bundle_messages.getString("caption.title_separator") + getCurrentElements().size());
	}
	
	public IRegion getActiveRegion() {
		return getCurrentState();
	}
	
	public String getActiveZone() {
		return zoneName;
	}

	public String getActiveFacilityId() {
		return facilityId;
	}
	@Override
	public void update() {
		ISelection selection = getSite().getPage().getSelection(ScopeView.Id);
		update(new ConcreteDataHolder(ScopeView.Id, selection), true);
	}

	@Override
	public IAccountResource getCurrentAccountResource() {
		return currentAccountResource;
	}
}