package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.util.Messages;

public class EstablishAgentConnectionAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.EstablishAgentConnectionAction";

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String strFacilityId = messages.getString("word.facility_id");
	private String msgEstablishAgentConnectionConfirm = messages.getString("message.confirm_that_perform_some_action", new Object[]{"word.agent_auto_detect"});
	private String msgEstablishAgentConnectionResult = messages.getString("message.performed_some_action", new Object[]{"word.agent_auto_detect"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		IStructuredSelection selection = (IStructuredSelection)viewPart.getSite().getSelectionProvider().getSelection();
		ICloudInstance instance = (ICloudInstance)selection.getFirstElement();
		if (
				MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgEstablishAgentConnectionConfirm + "\n" + strFacilityId + " = " + instance.getFacilityId())
			){

				instance.establishAgentConnection();
			
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						msgEstablishAgentConnectionResult);
		}
	}
	
	@Override
	protected boolean canEnabled(IStructuredSelection selection){
		boolean b = super.canEnabled(selection);
		if(b){
			ICloudInstance instance = (ICloudInstance)selection.getFirstElement();
			if(instance.getFacilityId() != null && ! instance.getFacilityId().isEmpty()){
				return true;
			}
		}
		return false;
	}
}
