/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.base.ui.dialogs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.base.resources.GroupIdentifier;
import com.clustercontrol.cloud.aws.base.resources.Image;
import com.clustercontrol.cloud.aws.base.resources.Subnet;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceRequest;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.presenter.TemplateJobsArgument;
import com.clustercontrol.cloud.ui.dialogs.EditTemplateJobArgumentDialog;
import com.clustercontrol.util.Messages;

public class CreateInstanceDialog extends Dialog {
	public static class EbsBlockDevice {
		public Integer volumeSize;
		public Boolean deleteOnTermination;
		public String volumeType;
		public Integer iops;
	}
	
	public static class InstanceDetail {
		public String subnetId;
		public List<String> securityGroupIds = new ArrayList<>();
		public String keyName;
		public Boolean monitoring;
		public Boolean disableApiTermination;
		public String instanceInitiatedShutdownBehavior;
		public Boolean ebsOptimized;
		public EbsBlockDevice rootBlockDevice;
	}
	
	public static class Model extends CreateCloudInstanceRequest implements Serializable {
		private static final long serialVersionUID = -8364801407665470030L;
		private String regionName;
		private String templateId;
		private List<TemplateJobsArgument> arguments;
		private Boolean isTemplateUsed = false;
		private Subnet subnet;
		
		private AvailabilityZone availabilityZone;
		private Image image;
		private String keyName;
		private String instanceInitiatedShutdownBehavior;
		private Boolean monitoring;
		private Boolean disableApiTermination;
		private List<GroupIdentifier> securityGroups;
		private Boolean ebsOptimized;
		private EbsBlockDevice rootBlockDevice;
		
		public String getRegionName() {
			return regionName;
		}

		public void setRegionName(String regionName) {
			this.regionName = regionName;
		}

		public String getTemplateId() {
			return templateId;
		}

		public void setTemplateId(String templateId) {
			this.templateId = templateId;
		}

		public List<TemplateJobsArgument> getArguments() {
			return arguments;
		}

		public void setArguments(List<TemplateJobsArgument> arguments) {
			this.arguments = arguments;
		}

		public Boolean isTemplateUsed() {
			return isTemplateUsed;
		}

		public void setIsTemplateUsed(Boolean isTemplateUsed) {
			this.isTemplateUsed = isTemplateUsed;
		}

		public Subnet getSubnet() {
			return subnet;
		}

		public void setSubnet(Subnet subnet) {
			this.subnet = subnet;
		}

		public AvailabilityZone getAvailabilityZone() {
			return availabilityZone;
		}

		public void setAvailabilityZone(AvailabilityZone availabilityZone) {
			this.availabilityZone = availabilityZone;
		}

		public Image getImage() {
			return image;
		}

		public void setImage(Image image) {
			this.image = image;
		}

		public String getKeyName() {
			return keyName;
		}

		public void setKeyName(String keyName) {
			this.keyName = keyName;
		}

		public String getInstanceInitiatedShutdownBehavior() {
			return instanceInitiatedShutdownBehavior;
		}

		public void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
			this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
		}

		public Boolean getMonitoring() {
			return monitoring;
		}

		public void setMonitoring(Boolean monitoring) {
			this.monitoring = monitoring;
		}

		public Boolean getDisableApiTermination() {
			return disableApiTermination;
		}

		public void setDisableApiTermination(Boolean disableApiTermination) {
			this.disableApiTermination = disableApiTermination;
		}

		public List<GroupIdentifier> getSecurityGroups() {
			return securityGroups;
		}

		public void setSecurityGroups(List<GroupIdentifier> securityGroups) {
			this.securityGroups = securityGroups;
		}

		public Boolean getEbsOptimized() {
			return ebsOptimized;
		}

		public void setEbsOptimized(Boolean ebsOptimized) {
			this.ebsOptimized = ebsOptimized;
		}

		public EbsBlockDevice getRootBlockDevice() {
			return rootBlockDevice;
		}

		public void setRootBlockDevice(EbsBlockDevice rootBlockDevice) {
			this.rootBlockDevice = rootBlockDevice;
		}

		public Model deepCopy() {
//			return ControlUtil.deepCopy(this);
			return this;
		}
	}
	
	interface IDialogBehavior {
		void setInput(Model input);
		void setProvider(CloudResourceProvider provider);
		
		void setupFacilityId(Text facilityId);
		void setupFacilityName(Text facilityName);
		void setupReplaceNode(Button btnReplaceNode);
		void setupDescription(Text description);
		void setupNodeName(Text nodeName);
		void setupRegion(Combo region);
		void setupAvailabilityZone(Combo availabilityZone);
		void setupKeyPair(Combo keyPair);
		void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate);
		void setupAmi(Text ami, Button selectAmi);
		void setupTemplate(Button useTemplate, Combo template, Button editArgument);
		void setupDetailSettings(Button detailSettings);
	}
	
	public static class DialogBehavior implements IDialogBehavior{
		protected MessageManagerExt messages = MessageManagerExt.getInstance("messages");
		protected CloudResourceProvider provider;
		protected Model input;
		
		public void setInput(Model input){
			this.input = input;
		};
		public void setProvider(CloudResourceProvider provider){
			this.provider = provider;
		};
		
		public void setupFacilityId(Text facilityId){};
		public void setupFacilityName(Text facilityName){};
		public void setupReplaceNode(Button btnReplaceNode){};
		public void setupDescription(Text description){};
		public void setupNodeName(Text nodeName){};
		public void setupRegion(Combo region){};
		public void setupAvailabilityZone(Combo availabilityZone){};
		public void setupKeyPair(Combo keyPair){};
		public void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate){};
		public void setupAmi(Text ami, Button selectAmi){};
		public void setupTemplate(Button useTemplate, Combo template, Button editArgument){};
		public void setupDetailSettings(Button detailSettings){};
	}
	
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String strSeparator = messages.getString("caption.title_separator");
	private String strNodeInfo = messages.getString("word.node_info");
	private String strFacilityId = messages.getString("word.facility_id");
	private String strNodeReplaceDescription = messages.getString("caption.node_replace_description");
	private String strFacilityName = messages.getString("word.facility_name");
	private String strDescription = messages.getString("word.description");
	private String strNodeName = messages.getString("word.node_name");
	private String strInstanceInfo = messages.getString("word.instance_info");
	private String strRegion = messages.getString("word.region");
	private String strAvailabilityZone = messages.getString("word.availability_zone");
	private String strVpcEnable = messages.getString("caption.vpc_enable");
	private String strSubnet = messages.getString("word.subnet");
	private String strKeyPair = messages.getString("word.key_pair");
	private String strAmi = messages.getString("word.ami");
	private String strRefer = messages.getString("word.refer");
	private String strUseTemplate = messages.getString("caption.use_subjects", new Object[]{"word.template"});
	private String strTemplate = messages.getString("word.template");
	private String strEditArgument = messages.getString("caption.edit_argument");
	private String strDetailSettings = messages.getString("word.detail_settings");
	private String strCreateInstanceDialog = messages.getString("caption.create_instance_dialog");
	private String msgSubnetDoesNotExists = messages.getString("message.subnet_does_not_exists");
	private String msgTemplateDoesNotExists = messages.getString("message.template_does_not_exists");
	private String msgMustFullyInput = messages.getString("message.must_fully_input");
	private String msgThatRegionHasNoKeypair = messages.getString("message.that_region_has_no_key_pair");

	private Shell shell;

	private Text facilityId;
	private Button btnReplaceNode;
	private Text facilityName;
	private Text description;
	private Text nodeName;
	private Combo cmbRegion;
	private Combo cmbAvailabilityZone;
	private Combo cmbKeyPair;
	private Text txtAMI;
	private Combo cmbTemplate;
	private Button btnUseTemplate;
	
	private Button btnSelectAMI;
	private Button btnEditArgument;
	
	private ControlDecoration ctdcKeyPair;
	
	private CloudResourceProvider provider;
	
	private Model input;
	private Model output = new Model();
	
	private IDialogBehavior behavior = new DialogBehavior();

	private ICloudTemplateManager cloudTemplateManager;
	
	public void setCloudTemplateManager(ICloudTemplateManager cloudTemplateManager) {
		this.cloudTemplateManager = cloudTemplateManager;
	}

	private List<TemplateJobsArgument> arguments;
	private Label lblAvailabilityZone;
	private Label lblAMI;
	private Label lblUseTemplate;
	private Label lblLaunchInVPC;
	private Label lblTemplate;
	private Button btnLaunchInVPC;
	private Combo cmbSubnet;
	private Label lblSubnet;
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateInstanceDialog(Shell parentShell){
		super(parentShell);
		this.shell = parentShell;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(1, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);

		Group grpNodeInfo = new Group(container, SWT.NONE);
		grpNodeInfo.setText(strNodeInfo + strSeparator);
		GridLayout gl_grpNodeInfo = new GridLayout(2, false);
		gl_grpNodeInfo.verticalSpacing = 9;
		gl_grpNodeInfo.horizontalSpacing = 15;
		grpNodeInfo.setLayout(gl_grpNodeInfo);
		grpNodeInfo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 5, 1));

		Label lblid = new Label(grpNodeInfo, SWT.RIGHT);
		lblid.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblid.setText(strFacilityId + strSeparator);

		facilityId = new Text(grpNodeInfo, SWT.BORDER);
		facilityId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		new Label(grpNodeInfo, SWT.NONE);
		
		btnReplaceNode = new Button(grpNodeInfo, SWT.CHECK);
		btnReplaceNode.setText(strNodeReplaceDescription);

		Label lblFacilityName = new Label(grpNodeInfo, SWT.RIGHT);
		lblFacilityName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblFacilityName.setText(strFacilityName + strSeparator);

		facilityName = new Text(grpNodeInfo, SWT.BORDER);
		facilityName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		Label lblDescription = new Label(grpNodeInfo, SWT.RIGHT);
		lblDescription.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblDescription.setText(strDescription + strSeparator);

		description = new Text(grpNodeInfo, SWT.BORDER);
		description.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));

		Label lblNodeName = new Label(grpNodeInfo, SWT.RIGHT);
		lblNodeName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNodeName.setText(strNodeName + strSeparator);

		nodeName = new Text(grpNodeInfo, SWT.BORDER);
		GridData gd_nodeName = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_nodeName.widthHint = 66;
		nodeName.setLayoutData(gd_nodeName);

		Group grpInstacneInfo = new Group(container, SWT.NONE);
		grpInstacneInfo.setText(strInstanceInfo);
		GridLayout gl_grpInstacneInfo = new GridLayout(3, false);
		gl_grpInstacneInfo.verticalSpacing = 9;
		gl_grpInstacneInfo.horizontalSpacing = 15;
		grpInstacneInfo.setLayout(gl_grpInstacneInfo);
		GridData gd_grpInstacneInfo = new GridData(SWT.FILL, SWT.CENTER, false, false, 5, 1);
		gd_grpInstacneInfo.heightHint = 350;
		grpInstacneInfo.setLayoutData(gd_grpInstacneInfo);

		Label lblRegion = new Label(grpInstacneInfo, SWT.RIGHT);
		lblRegion.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblRegion.setText(strRegion + strSeparator);

		cmbRegion = new Combo(grpInstacneInfo, SWT.READ_ONLY);
		cmbRegion.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		cmbRegion.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				// キーペアの更新
				cmbKeyPair.removeAll();
				for(String keyName: provider.getKeyNames((String)cmbRegion.getData(cmbRegion.getText()))){
					cmbKeyPair.add(keyName);
				}	
				if(cmbKeyPair.getItemCount() > 0){
					cmbKeyPair.setEnabled(true);
					cmbKeyPair.select(0);
				}
				else {
					cmbKeyPair.setEnabled(false);
				}
				checkKeyPair();

				String regionName = (String)cmbRegion.getData(cmbRegion.getText());
				
				// アベイラビリティーゾーンの更新。
				cmbAvailabilityZone.removeAll();
				java.util.List<AvailabilityZone> azs = provider.getAvailabilityZones(regionName);
				for(AvailabilityZone az: azs){
					cmbAvailabilityZone.add(az.getZoneName());
				}
				cmbAvailabilityZone.select(0);

				// サブネットのクリア。
				cmbSubnet.removeAll();
				btnLaunchInVPC.setSelection(false);
				lblAvailabilityZone.setEnabled(true);
				cmbAvailabilityZone.setEnabled(true);
				lblSubnet.setEnabled(false);
				cmbSubnet.setEnabled(false);
				
				// テンプレートのクリア。
				btnUseTemplate.setSelection(false);
				cmbTemplate.removeAll();
				lblTemplate.setEnabled(false);
				cmbTemplate.setEnabled(false);
				btnEditArgument.setEnabled(false);
				lblAMI.setEnabled(true);
				txtAMI.setEnabled(true);
				btnSelectAMI.setEnabled(true);

				//AMI情報のクリア
				txtAMI.setText("");
				txtAMI.setData(null);
			}
		});
		
		lblAvailabilityZone = new Label(grpInstacneInfo, SWT.NONE);
		lblAvailabilityZone.setAlignment(SWT.RIGHT);
		lblAvailabilityZone.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblAvailabilityZone.setText(strAvailabilityZone + strSeparator);
		
		cmbAvailabilityZone = new Combo(grpInstacneInfo, SWT.READ_ONLY);
		cmbAvailabilityZone.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		lblLaunchInVPC = new Label(grpInstacneInfo, SWT.NONE);
		lblLaunchInVPC.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblLaunchInVPC.setAlignment(SWT.RIGHT);
		lblLaunchInVPC.setText(strVpcEnable + strSeparator);
		
		btnLaunchInVPC = new Button(grpInstacneInfo, SWT.CHECK);
		btnLaunchInVPC.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if (btnLaunchInVPC.getSelection()) {
					if (cmbSubnet.getItemCount() == 0) {
						List<Subnet> subnets = provider.getSubnetsByRegion((String)cmbRegion.getData(cmbRegion.getText()));
						if (!subnets.isEmpty()) {
							for (Subnet subnet: subnets) {
								cmbSubnet.add(subnet.getSubnetId());
								cmbSubnet.setData(subnet.getSubnetId(), subnet);
							}
							cmbSubnet.select(0);

							lblAvailabilityZone.setEnabled(false);
							cmbAvailabilityZone.setEnabled(false);
							lblSubnet.setEnabled(true);
							cmbSubnet.setEnabled(true);
						}
						else {
							MessageDialog.openError(null, Messages.getString("failed"),  msgSubnetDoesNotExists);
							btnLaunchInVPC.setSelection(false);
						}
					}
					else {
						lblAvailabilityZone.setEnabled(false);
						cmbAvailabilityZone.setEnabled(false);
						lblSubnet.setEnabled(true);
						cmbSubnet.setEnabled(true);
					}
				}
				else {
					lblAvailabilityZone.setEnabled(true);
					cmbAvailabilityZone.setEnabled(true);
					lblSubnet.setEnabled(false);
					cmbSubnet.setEnabled(false);
				}
			}
		});
		btnLaunchInVPC.setAlignment(SWT.RIGHT);
		btnLaunchInVPC.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		new Label(grpInstacneInfo, SWT.NONE);
		
		lblSubnet = new Label(grpInstacneInfo, SWT.NONE);
		lblSubnet.setEnabled(false);
		lblSubnet.setAlignment(SWT.RIGHT);
		lblSubnet.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblSubnet.setText(strSubnet + strSeparator);
		
		cmbSubnet = new Combo(grpInstacneInfo, SWT.READ_ONLY);
		cmbSubnet.setEnabled(false);
		cmbSubnet.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		Label lblKeyPair = new Label(grpInstacneInfo, SWT.RIGHT);
		lblKeyPair.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblKeyPair.setText(strKeyPair + strSeparator);

		cmbKeyPair = new Combo(grpInstacneInfo, SWT.READ_ONLY);
		GridData gd_cmbKeyPair = new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1);
		gd_cmbKeyPair.widthHint = 100;
		cmbKeyPair.setLayoutData(gd_cmbKeyPair);
		
		//キーペアの有無確認
		ctdcKeyPair = new ControlDecoration(cmbKeyPair, SWT.LEFT | SWT.TOP);
		ctdcKeyPair.setImage(ResourceManager.getPluginImage(Activator.ID, "icons/error.gif"));
		
		lblAMI = new Label(grpInstacneInfo, SWT.NONE);
		lblAMI.setAlignment(SWT.RIGHT);
		lblAMI.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAMI.setText(strAmi + strSeparator);
		
		txtAMI = new Text(grpInstacneInfo, SWT.BORDER | SWT.READ_ONLY);
		txtAMI.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		btnSelectAMI = new Button(grpInstacneInfo, SWT.NONE);
		btnSelectAMI.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnSelectAMI.setText(strRefer);
		
		btnSelectAMI.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				SelectAMIDialog dialog = new SelectAMIDialog(shell);
				dialog.setCloudInfoProvider(provider);
				dialog.setRegion((String)cmbRegion.getData(cmbRegion.getText()));
				dialog.open();
	
				if (dialog.getReturnCode() == Window.OK) {
					Image image = dialog.getOutput();
					txtAMI.setText("("+image.getImageId()+") "+image.getName());
					txtAMI.setData(image);
				}
			}
		});
						
		lblUseTemplate = new Label(grpInstacneInfo, SWT.NONE);
		lblUseTemplate.setAlignment(SWT.RIGHT);
		lblUseTemplate.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblUseTemplate.setText(strUseTemplate + strSeparator);
		
		btnUseTemplate = new Button(grpInstacneInfo, SWT.CHECK);
		btnUseTemplate.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnUseTemplate.setAlignment(SWT.RIGHT);
		
		btnUseTemplate.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				if (btnUseTemplate.getSelection()) {
					if (cmbTemplate.getItemCount() == 0) {
						for(ICloudTemplate tmpTemplate: cloudTemplateManager.getCloudTemplates()){
							if(tmpTemplate.getRegion().equals(cmbRegion.getData(cmbRegion.getText()))){
								String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
								cmbTemplate.add(tmpLabel);
								cmbTemplate.setData(tmpLabel, tmpTemplate);
							}
						}
					}
					
					if (cmbTemplate.getItemCount() > 0) {
						cmbTemplate.select(0);

						lblTemplate.setEnabled(true);
						cmbTemplate.setEnabled(true);
						btnEditArgument.setEnabled(true);
						lblAMI.setEnabled(false);
						txtAMI.setEnabled(false);
						btnSelectAMI.setEnabled(false);
						txtAMI.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
					} else {
						MessageDialog.openError(null, Messages.getString("failed"), msgTemplateDoesNotExists);
						btnUseTemplate.setSelection(false);
					}
				} else {
					lblTemplate.setEnabled(false);
					cmbTemplate.setEnabled(false);
					btnEditArgument.setEnabled(false);
					lblAMI.setEnabled(true);
					txtAMI.setEnabled(true);
					btnSelectAMI.setEnabled(true);

					if(txtAMI.getText().equals("")){
						txtAMI.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
					}
				}
			}
		});
		new Label(grpInstacneInfo, SWT.NONE);
		
		lblTemplate = new Label(grpInstacneInfo, SWT.NONE);
		lblTemplate.setEnabled(false);
		lblTemplate.setAlignment(SWT.RIGHT);
		lblTemplate.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblTemplate.setText(strTemplate + strSeparator);
				
		cmbTemplate = new Combo(grpInstacneInfo, SWT.BORDER | SWT.READ_ONLY);
		cmbTemplate.setEnabled(false);
		GridData gd_cmbTemplate = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_cmbTemplate.widthHint = 100;
		cmbTemplate.setLayoutData(gd_cmbTemplate);
						
		btnEditArgument = new Button(grpInstacneInfo, SWT.NONE);
		btnEditArgument.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnEditArgument.setText(strEditArgument);
						
		btnEditArgument.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(cmbTemplate.getText().equals("")){
					return;
				}
				ICloudTemplate tmpTemplate = (ICloudTemplate)cmbTemplate.getData(cmbTemplate.getText()); 
				if(tmpTemplate == null || tmpTemplate.getLaunchJobId() == null || tmpTemplate.getLaunchJobId().equals("")){
					return;
				}
				EditTemplateJobArgumentDialog dialog = new EditTemplateJobArgumentDialog(shell, cloudTemplateManager.getAccountResource().getAccountResourceId(), tmpTemplate.getTemplateId(), tmpTemplate.getLaunchJobId());


				if (dialog.open() == Window.OK) {
					arguments = dialog.getArguments();
				}
			}
		});
		new Label(grpInstacneInfo, SWT.NONE);
		new Label(grpInstacneInfo, SWT.NONE);
		new Label(grpInstacneInfo, SWT.NONE);
		new Label(grpInstacneInfo, SWT.NONE);
		new Label(grpInstacneInfo, SWT.NONE);
		
		Button btnDetailSettings = new Button(grpInstacneInfo, SWT.NONE);
		btnDetailSettings.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnDetailSettings.setText(strDetailSettings);
		
		btnDetailSettings.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				InstanceDetailDialog dialog = new InstanceDetailDialog(shell);
				dialog.setCloudInfoProvider(provider);

				output.setRegionName((String)cmbRegion.getData(cmbRegion.getText()));
				output.setFacilityName(facilityName.getText());
				
				if (btnLaunchInVPC.getSelection()) {
					output.setSubnet(((Subnet)cmbSubnet.getData(cmbSubnet.getText())));
				}
				else {
					output.setSubnet(null);
				}

				dialog.setInput(output);
				if (dialog.open() == Window.OK) {
					output = dialog.getOutput();
				}
			}
		});
		checkKeyPair();

		ControlUtil.setRequired(new Control[]{facilityId, facilityName, nodeName, txtAMI});
		
		{
			behavior.setInput(input);
			behavior.setProvider(provider);		
			behavior.setupFacilityId(facilityId);
			behavior.setupReplaceNode(btnReplaceNode);
			behavior.setupFacilityName(facilityName);
			behavior.setupDescription(description);
			behavior.setupNodeName(nodeName);
			behavior.setupRegion(cmbRegion);
			behavior.setupAvailabilityZone(cmbAvailabilityZone);
			behavior.setupDetailSettings(btnDetailSettings);
			behavior.setupAmi(txtAMI, btnSelectAMI);
			behavior.setupTemplate(btnUseTemplate, cmbTemplate, btnEditArgument);
			behavior.setupKeyPair(cmbKeyPair);
		}

		// 項目名の幅をグループ間で一致させる。
		container.layout();
		Control[] labels = new Control[]{lblid, lblFacilityName, lblDescription, lblNodeName, lblRegion, lblAvailabilityZone, lblLaunchInVPC, lblSubnet, lblKeyPair, lblAMI, lblUseTemplate, lblTemplate};
		int maxWidth = 0;
		for (Control l: labels) {
			Point p = l.getSize();
			maxWidth = Math.max(maxWidth, p.x);
		}
		for (Control l: labels) {
			((GridData)l.getLayoutData()).widthHint = maxWidth;
		}
		grpNodeInfo.layout(true);
		grpInstacneInfo.layout(true);

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 690);
	}

	@Override
	protected void okPressed() {
		if (
			facilityId.getText().equals("") ||
			facilityName.getText().equals("") ||
			nodeName.getText().equals("") ||
			cmbRegion.getText().equals("") ||
			cmbKeyPair.getText().equals("") ||
			(!btnLaunchInVPC.getSelection() && cmbAvailabilityZone.getText().equals("")) ||
			(btnLaunchInVPC.getSelection() && cmbSubnet.getText().equals("")) ||
			(!btnUseTemplate.getSelection() && txtAMI.getText().equals("")) ||
			(btnUseTemplate.getSelection() && cmbTemplate.getText().equals(""))
			){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					msgMustFullyInput);
			return;
		}

		output.setRegionName((String)cmbRegion.getData(cmbRegion.getText()));
		output.setFacilityId(facilityId.getText());
		output.setFacilityName(facilityName.getText());
		output.setDescription(description.getText());
		output.setNodeName(nodeName.getText());
		output.setKeyName(cmbKeyPair.getText());
		output.setImage((Image)txtAMI.getData());
		output.setReplaceNode(btnReplaceNode.getSelection());

		if (!btnLaunchInVPC.getSelection()) {
			output.setAvailabilityZone(new AvailabilityZone());
			output.getAvailabilityZone().setZoneName(cmbAvailabilityZone.getText());
			output.setSubnet(null);
		}
		else {
			output.setAvailabilityZone(null);
			output.setSubnet(((Subnet)cmbSubnet.getData(cmbSubnet.getText())));
		}

		if (!btnUseTemplate.getSelection()) {
			output.setImage((Image)txtAMI.getData());
			output.templateId = null;
		}
		else {
			output.templateId = ((ICloudTemplate)cmbTemplate.getData(cmbTemplate.getText())).getTemplateId();
			Image image = new Image();
			image.setImageId((((ICloudTemplate)cmbTemplate.getData(cmbTemplate.getText())).getImageId()));
			output.setImage(image);
			if(arguments != null && arguments.size() > 0){
				output.arguments = arguments;
			}
			output.isTemplateUsed = true;
			output.setImage(null);
		}

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strCreateInstanceDialog);
	}

	public void setInput(Model input) {
		assert input != null;
		this.input = input;
		output = input.deepCopy();
	}

	public CreateInstanceDialog.Model getOutput() {
		return output;
	}

	public void setCloudInfoProvider(CloudResourceProvider provider) {
		this.provider = provider;
	}
	
	public void setBehavior(IDialogBehavior behavior){
		this.behavior = behavior;
	}

	public void checkKeyPair(){
		if(cmbKeyPair.getItemCount() > 0){
			ctdcKeyPair.hide();
			ctdcKeyPair.setDescriptionText("");
			ctdcKeyPair.showHoverText("");
			ctdcKeyPair.setShowHover(false);
		} else {
			ctdcKeyPair.show();
			ctdcKeyPair.setShowHover(true);
			ctdcKeyPair.setDescriptionText(msgThatRegionHasNoKeypair);
			ctdcKeyPair.showHoverText(msgThatRegionHasNoKeypair);
		}
	}
}
