/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.base.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.base.resources.Filter;
import com.clustercontrol.cloud.aws.base.resources.GroupIdentifier;
import com.clustercontrol.cloud.aws.base.ui.dialogs.CreateInstanceDialog.EbsBlockDevice;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.ParameterManager;
import com.clustercontrol.cloud.resources.Tag;
import com.clustercontrol.util.Messages;

public class InstanceDetailDialog extends Dialog {
	public static class Decorator {
		private Combo control;
		
		private static ModifyListener modifyListener = new ModifyListener(){
			@Override
			public void modifyText(ModifyEvent e) {
				if(((Combo)e.getSource()).getText().equals("")){
					((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				} else {
					((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				}
			}
		};
		
		public Decorator(Combo control) {
			this.control = control;
			setEnabled(false);
		}
		
		public void setEnabled(boolean enable) {
			if (enable) {
				if (control.getText().equals("")) {
					control.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				}
				else {
					control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				}
				control.addModifyListener(modifyListener);
			}
			else {
				control.removeModifyListener(modifyListener);
				control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
			}
		}
	}
	
	private static final int multiply = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.multiply"));
	private static final int minIops = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.miniops"));
	private static final int maxIops = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.maxiops"));
	private static final int skip = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.skip"));
	
	private static final Integer NUM_OF_TAGS = 9;
	
	private static final String IOPS_VALUE = "io1";
	
	private CreateInstanceDialog.Model input;
	private CreateInstanceDialog.Model output;
	private Combo shutdownBehaviour;
	private Combo type;
	private Button btnDetailedMonitoring;
	private Button btnTerminationProtection;
	private Button btnLaunchAsAnEBSOptimized;
	private List securityGroups;
	private Button btnDeleteOnTermination;
	private Text volumeSize;
	private Combo volumeType;
	private Combo cmbIops;
	private Text keyName;
	private Text valueName;
	private Text[] key = new Text[NUM_OF_TAGS];
	private Text[] value = new Text[NUM_OF_TAGS];

	private ControlDecoration ctdcIops;
	private ControlDecoration ctdcSize;

	private Decorator decorator; 
	
	private CloudResourceProvider provider;

	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");

	private String strSeparator = messages.getString("caption.title_separator");
	private String strInstanceDetail = messages.getString("word.instance_detail");
	private String strInstanceType = messages.getString("word.instance_type");
	private String strShutdownBehavior = messages.getString("word.shutdown_behavior");
	private String strDetailedMonitoring = messages.getString("word.detailed_monitoring");
	private String strTerminationProtection = messages.getString("caption.termination_protection");
	private String strVolumeSizeUnit = messages.getString("word.volume_size_unit");
	private String strVolumeSize = messages.getString("word.volume_size");
	private String strSelectSecurityGroup = messages.getString("word.select_security_group");
	private String strVolumeType = messages.getString("word.volume_type");
	private String strDeleteOnTermination = messages.getString("word.delete_on_termination");
	private String strRootVolumeSettings = messages.getString("word.root_volume_settings");
	private String strIops = messages.getString("word.iops");
	private String strSecuritySettings = messages.getString("word.security_settings");
	private String strStorageDeviceSettings = messages.getString("word.storage_device_settings");
	private String strDetailedMonitoringDescription = messages.getString("caption.detailed_monitoring_description");
	private String strEbsOptimized = messages.getString("word.ebs_optimized");
	private String strTagsValue = messages.getString("word.tags_value");
	private String strTagsName = messages.getString("word.tags_name");
	private String strTagSettings = messages.getString("word.tag_settings");
	private String strEditInstanceDetailDialog = messages.getString("caption.edit_instance_detail_dialog");
	private String strEbsOptimizedDescription = messages.getString("caption.ebs_optimized_description");
	private String strEbsOptimizedDescriptionNoSupported = messages.getString("caption.ebs_optimized_description_no_supported");
	private String msgMustFullyInput = messages.getString("message.must_fully_input");
	private String msgMustGraterThanX = messages.getString("message.iops_must_be_less_than_X_times_of_volume_size", new String[]{Integer.toString(multiply)});
	private String msgIopsMustBeLessThanXTimesOfVolumeSize = messages.getString("message.must_grater_than_X", new Object[]{Integer.toString(minIops), Integer.toString(maxIops)});

	private ParameterManager paramEbsOptimized = ParameterManager.getInstance("ebs_optimized_enable_list");
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public InstanceDetailDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setLayoutData(new GridData(GridData.FILL_BOTH));

		TabFolder tabFolder = new TabFolder(container, SWT.NONE);
		tabFolder.setBounds(0, 0, 596, 360);


		// Instance Details tab
		TabItem tbtmInstanceDetails = new TabItem(tabFolder, SWT.NONE);
		tbtmInstanceDetails.setText(strInstanceDetail);

		Composite composite = new Composite(tabFolder, SWT.NONE);
		tbtmInstanceDetails.setControl(composite);
		GridLayout gl_composite = new GridLayout(2, false);
		gl_composite.marginTop = 10;
		gl_composite.verticalSpacing = 20;
		composite.setLayout(gl_composite);

		Label lblType = new Label(composite, SWT.NONE);
		lblType.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblType.setText(strInstanceType + strSeparator);

		type = new Combo(composite, SWT.READ_ONLY);
		GridData gd_type = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_type.widthHint = 100;
		type.setLayoutData(gd_type);

		Label lblShutdownBehaviour = new Label(composite, SWT.NONE);
		lblShutdownBehaviour.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblShutdownBehaviour.setText(strShutdownBehavior + strSeparator);

		shutdownBehaviour = new Combo(composite, SWT.READ_ONLY);
		GridData gd_shutdownBehaviour = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_shutdownBehaviour.widthHint = 100;
		shutdownBehaviour.setLayoutData(gd_shutdownBehaviour);

		Label lblDetailedMonitoring = new Label(composite, SWT.NONE);
		lblDetailedMonitoring.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblDetailedMonitoring.setText(strDetailedMonitoring + strSeparator);

		btnDetailedMonitoring = new Button(composite, SWT.CHECK);
		btnDetailedMonitoring.setText(strDetailedMonitoringDescription);

		Label lblTerminationProtection = new Label(composite, SWT.NONE);
		lblTerminationProtection.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblTerminationProtection.setText(strTerminationProtection + strSeparator);

		btnTerminationProtection = new Button(composite, SWT.CHECK);

		Label lblLaunchAsAnEBSOptimizedInstance = new Label(composite, SWT.NONE);
		lblLaunchAsAnEBSOptimizedInstance.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblLaunchAsAnEBSOptimizedInstance.setText(strEbsOptimized + strSeparator);

		btnLaunchAsAnEBSOptimized = new Button(composite, SWT.CHECK);

		composite.layout();
		
		// Modify Tags tab
		TabItem tbtmModifyTags = new TabItem(tabFolder, SWT.NONE);
		tbtmModifyTags.setText(strTagSettings);

		Composite composite_1 = new Composite(tabFolder, SWT.NONE);
		tbtmModifyTags.setControl(composite_1);
		GridLayout gl_composite_1 = new GridLayout(2, false);
		gl_composite_1.verticalSpacing = 2;
		composite_1.setLayout(gl_composite_1);
		
		Label lblKey = new Label(composite_1, SWT.NONE);
		lblKey.setText(strTagsName + strSeparator);
		
		Label lblValue = new Label(composite_1, SWT.NONE);
		lblValue.setText(strTagsValue + strSeparator);

		keyName = new Text(composite_1, SWT.BORDER);
		keyName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		keyName.setText("Name");
		keyName.setEditable(false);
		valueName = new Text(composite_1, SWT.BORDER);
		valueName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		valueName.setEditable(false);
		
		for(int i = 0; i < NUM_OF_TAGS; i++){
			key[i]= new Text(composite_1, SWT.BORDER);
			key[i].setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
			
			value[i] = new Text(composite_1, SWT.BORDER);
			value[i].setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		}

		composite_1.layout();

		// Security Settings tab
		TabItem tbtmSecuritySettigns = new TabItem(tabFolder, SWT.NONE);
		tbtmSecuritySettigns.setText(strSecuritySettings);
		
		Composite composite_2 = new Composite(tabFolder, SWT.NONE);
		tbtmSecuritySettigns.setControl(composite_2);
		GridLayout gl_composite_2 = new GridLayout(1, false);
		gl_composite_2.marginTop = 10;
		gl_composite_2.verticalSpacing = 10;
		composite_2.setLayout(gl_composite_2);
		
		Group group_1 = new Group(composite_2, SWT.NONE);
		group_1.setLayout(new GridLayout(1, false));
		GridData gd_group_1 = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_group_1.heightHint = 187;
		gd_group_1.widthHint = 572;
		group_1.setLayoutData(gd_group_1);
		group_1.setText(strSelectSecurityGroup + strSeparator);
		
		securityGroups = new List(group_1, SWT.BORDER | SWT.V_SCROLL | SWT.MULTI);
		GridData gd_securityGroups = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_securityGroups.heightHint = 172;
		gd_securityGroups.widthHint = 539;
		securityGroups.setLayoutData(gd_securityGroups);
		securityGroups.select(0);


		// Storage Device Configuration tab
		TabItem tbtmStorageDeviceConfiguration = new TabItem(tabFolder, SWT.NONE);
		tbtmStorageDeviceConfiguration.setText(strStorageDeviceSettings);
		
		Composite composite_4 = new Composite(tabFolder, SWT.NONE);
		tbtmStorageDeviceConfiguration.setControl(composite_4);
		GridLayout gl_composite_4 = new GridLayout(1, false);
		gl_composite_4.marginTop = 10;
		gl_composite_4.verticalSpacing = 20;
		composite_4.setLayout(gl_composite_4);
		
		Group group = new Group(composite_4, SWT.NONE);
		GridLayout gl_group = new GridLayout(3, false);
		gl_group.horizontalSpacing = 15;
		group.setLayout(gl_group);
		GridData gd_group = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_group.widthHint = 569;
		group.setLayoutData(gd_group);
		group.setText(strRootVolumeSettings + strSeparator);
		
		Label lblVolumeSize = new Label(group, SWT.NONE);
		lblVolumeSize.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblVolumeSize.setText(strVolumeSize + strSeparator);
		
		volumeSize = new Text(group, SWT.BORDER);
		volumeSize.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		ctdcSize = new ControlDecoration(volumeSize, SWT.LEFT | SWT.TOP);
		ctdcSize.setImage(ResourceManager.getPluginImage(Activator.ID, "icons/error.gif"));
		ctdcSize.setDescriptionText("");
		ctdcSize.hide();
		
		Label lblGib = new Label(group, SWT.NONE);
		lblGib.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		lblGib.setText(strVolumeSizeUnit);
		new Label(group, SWT.NONE);
		new Label(group, SWT.NONE);
		new Label(group, SWT.NONE);
		
		Label lblVolumeType = new Label(group, SWT.NONE);
		lblVolumeType.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblVolumeType.setText(strVolumeType + strSeparator);
		
		volumeType = new Combo(group, SWT.READ_ONLY);
		GridData gd_volumeType = new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1);
		gd_volumeType.widthHint = 100;
		volumeType.setLayoutData(gd_volumeType);
		new Label(group, SWT.NONE);
		new Label(group, SWT.NONE);
		new Label(group, SWT.NONE);
		
		Label lblIops = new Label(group, SWT.NONE);
		lblIops.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblIops.setText(strIops + strSeparator);
		
		cmbIops = new Combo(group, SWT.BORDER);
		GridData gd_cmbIops = new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1);
		gd_cmbIops.widthHint = 100;
		cmbIops.setLayoutData(gd_cmbIops);
		cmbIops.setEnabled(false);

		ctdcIops = new ControlDecoration(cmbIops, SWT.LEFT | SWT.TOP);
		ctdcIops.setImage(ResourceManager.getPluginImage(Activator.ID, "icons/error.gif"));
		ctdcIops.hide();
		
		cmbIops.addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(KeyEvent e) {
				if (!(((e.keyCode >= '0' && e.keyCode <= '9') && e.stateMask == 0) || ((e.keyCode >= 16777264 && e.keyCode <= 16777273) && e.stateMask == 0) || checkKey(e.keyCode))) {
					e.doit = false;
				}
			}
		});

		cmbIops.addModifyListener(new ModifyListener(){
			@Override
			public void modifyText(ModifyEvent e) {
				checkIops();
			}
		});
		
		new Label(group, SWT.NONE);
		new Label(group, SWT.NONE);
		new Label(group, SWT.NONE);

		Label lblDeleteOnTermination = new Label(group, SWT.NONE);
		lblDeleteOnTermination.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblDeleteOnTermination.setText(strDeleteOnTermination + strSeparator);

		btnDeleteOnTermination = new Button(group, SWT.CHECK);
		btnDeleteOnTermination.setSelection(true);

		new Label(group, SWT.NONE);

		// 選択可能項目の設定。
		// インスタンス種別設定。
		java.util.List<String> instanceTypes = provider.getAllInstanceType();
		for(String it: instanceTypes){
			String itemName = it + " (" + messages.getString(it) + ")";
			type.add(itemName);
			type.setData(itemName, it);
		}
		if (!instanceTypes.isEmpty()) {
			type.select(0);
			checkEbsOptimized();
		}
		
		// シャットダウン時の振る舞い項目を設定。
		shutdownBehaviour.add("stop");
		shutdownBehaviour.add("terminate");
		shutdownBehaviour.select(0);

		// セキュリティグループ設定。
		java.util.List<GroupIdentifier> sgs = Collections.emptyList();
		if (input.getSubnet() != null) {
			sgs = provider.getSecurityGroups(input.getRegionName(), Arrays.asList(new Filter("vpc-id", Arrays.asList(input.getSubnet().getVpcId()))));
		}
		else {
			sgs = new ArrayList<GroupIdentifier>(provider.getSecurityGroupsByRegion(input.getRegionName()));
			Iterator<GroupIdentifier> iter = sgs.iterator();
			while (iter.hasNext()) {
				GroupIdentifier sg = iter.next();
				if (sg.getVpcId() != null) {
					iter.remove();
				}
			}
		}
		
		for (int i = 0; i < sgs.size(); ++i) {
			GroupIdentifier sg = sgs.get(i);
			securityGroups.add(sg.getGroupName());
			securityGroups.setData(Integer.toString(i), sg);
		}

		for (String volumeTypeName: provider.getAllVolumeType()) {
			String volumeTypeLocaleName = messages.getString(volumeTypeName);
			volumeType.add(volumeTypeLocaleName);
			volumeType.setData(volumeTypeLocaleName, volumeTypeName);
		}
		volumeType.select(0);
		
		// 入力値をコントロールに反映。
		if (input != null) {
			if (input.getFlavor() != null) {
				String itemName = input.getFlavor() + " (" + messages.getString(input.getFlavor()) + ")";
				type.setText(itemName);
				checkEbsOptimized();
			}

			if (input.getInstanceInitiatedShutdownBehavior() != null) {
				shutdownBehaviour.setText(input.getInstanceInitiatedShutdownBehavior());
			}
						
			if (input.getMonitoring() != null) {
				btnDetailedMonitoring.setSelection(input.getMonitoring());
			}
			
			if (input.getDisableApiTermination() != null) {
				btnTerminationProtection.setSelection(input.getDisableApiTermination());
			}

			if (input.getFacilityName() != null){
				valueName.setText(input.getFacilityName());
			}
			
			if (input.getSecurityGroups() != null) {
				java.util.List<Integer> selections = new ArrayList<Integer>();
				int size = securityGroups.getItems().length;
				for (int i = 0; i < size; ++i) {
					GroupIdentifier selectable = (GroupIdentifier)securityGroups.getData(Integer.toString(i));
					for (GroupIdentifier sg: input.getSecurityGroups()) {
						if (selectable.getGroupId().equals(sg.getGroupId())) {
							selections.add(i);
							break;
						}
					}
				}
				int[] indices = new int[selections.size()];
				for (int i = 0; i < selections.size(); ++i) {
					indices[i] = selections.get(i);
				}
				securityGroups.select(indices);
			}
			
			if(input.getEbsOptimized() != null){
				btnLaunchAsAnEBSOptimized.setSelection(input.getEbsOptimized());
			}
			
			if(input.getTags() != null && !input.getTags().isEmpty()){
				int i = 0;
				for(Tag tag: input.getTags()){
					key[i].setText(tag.name);
					value[i].setText(tag.value);
					i++;
				}
			}

			if (input.getRootBlockDevice() != null) {
				if(input.getRootBlockDevice().volumeSize != null){
					volumeSize.setText(input.getRootBlockDevice().volumeSize.toString());
				}

				if(input.getRootBlockDevice().volumeType != null){
					volumeType.setText(messages.getString(input.getRootBlockDevice().volumeType));
				}

				if(input.getRootBlockDevice().iops != null){
					cmbIops.setText(input.getRootBlockDevice().iops.toString());
				}

				if(input.getRootBlockDevice().deleteOnTermination != null){
					btnDeleteOnTermination.setSelection(input.getRootBlockDevice().deleteOnTermination);
				}

				if (messages.getString(IOPS_VALUE).equals(volumeType.getText())){
					cmbIops.setEnabled(true);
					if(!"".equals(volumeSize.getText())){
						String n = cmbIops.getText();
						cmbIops.removeAll();
						int iops = skip;
						while (iops <= maxIops) {
							cmbIops.add(Integer.toString(iops));
							iops += skip;
						}
						cmbIops.setText(n);
					}
				}
				checkIops();
			}
		}

		type.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				checkEbsOptimized();
			}
		});

		volumeType.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				if(volumeType.getText().equals(messages.getString(IOPS_VALUE))){
					cmbIops.setEnabled(true);
					decorator.setEnabled(true);
				}
				else {
					decorator.setEnabled(false);
					cmbIops.setEnabled(false);
				}
				checkIops();
			}
		});

		ControlUtil.setInputRestriction(new Control[]{volumeSize, cmbIops}, Pattern.compile("^[0-9]+$"));

		volumeSize.addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(FocusEvent e) {
				if(!"".equals(volumeSize.getText())){
					String n = cmbIops.getText();
					cmbIops.removeAll();
					int iops = skip;
					while (iops <= maxIops) {
						cmbIops.add(Integer.toString(iops));
						iops += skip;
					}
					cmbIops.setText(n);
				}
			}
		});

		volumeSize.addModifyListener(new ModifyListener(){
			@Override
			public void modifyText(ModifyEvent e) {
				checkIops();
			}
		});
		
		decorator = new Decorator(cmbIops);
		
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}
	
	@Override
	protected void okPressed() {
		if(
			IOPS_VALUE.equals(volumeType.getData((volumeType.getText())))
			&& (volumeSize.getText().isEmpty() || cmbIops.getText().isEmpty())
		){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					msgMustFullyInput);
			return;
		}
		
		if (input != null) {
			output = input.deepCopy();
		}
		else {
			output = new CreateInstanceDialog.Model();
		}
		
		output.setFlavor((String)type.getData(type.getText()));
		output.setInstanceInitiatedShutdownBehavior(shutdownBehaviour.getText());
		output.setMonitoring(btnDetailedMonitoring.getSelection());
		output.setDisableApiTermination(btnTerminationProtection.getSelection());
		output.setEbsOptimized(btnLaunchAsAnEBSOptimized.getSelection());
		output.setSecurityGroups(new ArrayList<GroupIdentifier>());
		int[] indices = securityGroups.getSelectionIndices();
		for (int index: indices) {
			output.getSecurityGroups().add((GroupIdentifier)securityGroups.getData(Integer.toString(index)));
		}
		output.setTags(new ArrayList<Tag>());
		for(int i = 0; i < NUM_OF_TAGS; i++){
			if(!key[i].getText().equals("")/* && !value[i].getText().equals("") */){
				Tag tag = new Tag();
				tag.name = key[i].getText();
				tag.value = value[i].getText();
				output.getTags().add(tag);
			}
		}
		output.setRootBlockDevice(new EbsBlockDevice());
		if(!volumeSize.getText().isEmpty()){
			output.getRootBlockDevice().volumeSize = Integer.parseInt(volumeSize.getText());
		}
		output.getRootBlockDevice().volumeType = (String)volumeType.getData(volumeType.getText());
		if(!cmbIops.getText().equals("")){
			output.getRootBlockDevice().iops = Integer.parseInt(cmbIops.getText());
		}
		output.getRootBlockDevice().deleteOnTermination = btnDeleteOnTermination.getSelection();
		
		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strEditInstanceDetailDialog);
	}

	public void setInput(CreateInstanceDialog.Model input) {
		assert input != null;
		this.input = input;
	}

	public CreateInstanceDialog.Model getOutput() {
		return output;
	}

	public void setCloudInfoProvider(CloudResourceProvider provider) {
		this.provider = provider;
	}

	/**
	 * テキストボックスに対して、
	 * キーボードの入力制限を行う
	 * @param keyCode
	 * @return
	 */
	private static boolean checkKey(int keyCode) {
		int[] keys = {
		SWT.SHIFT, // （[Shift]キー）
		SWT.ALT, // （[Alt]キー）
		SWT.ARROW_DOWN, // （[↓]キー）
		SWT.ARROW_LEFT, // （[←]キー）
		SWT.ARROW_RIGHT, // （[→]キー）
		SWT.ARROW_UP, // （[↑]キー）
		SWT.BS, // （[BackSpace]キー）
		SWT.CONTROL, //
		SWT.CTRL, // （[Ctrl]キー）
		SWT.DEL, // （[Delete]キー）
		SWT.ESC, // （[Esc]キー）
		SWT.F1, // - SWT.F12 （ファンクションキー）
		SWT.F2, // - SWT.F12 （ファンクションキー）
		SWT.F3, // - SWT.F12 （ファンクションキー）
		SWT.F4, // - SWT.F12 （ファンクションキー）
		SWT.F5, // - SWT.F12 （ファンクションキー）
		SWT.F6, // - SWT.F12 （ファンクションキー）
		SWT.F7, // - SWT.F12 （ファンクションキー）
		SWT.F8, // - SWT.F12 （ファンクションキー）
		SWT.F9, // - SWT.F12 （ファンクションキー）
		SWT.F10, // - SWT.F12 （ファンクションキー）
		SWT.F11, // - SWT.F12 （ファンクションキー）
		SWT.F12, // - SWT.F12 （ファンクションキー）
		};

		for (int key: keys) {
			if (keyCode == key) {
				return true;
			}
		}

		return false;
	}

	public void checkIops(){
		if (messages.getString(IOPS_VALUE).equals(volumeType.getText()) &&
				((cmbIops.getText().isEmpty() || Integer.parseInt(cmbIops.getText()) < minIops || Integer.parseInt(cmbIops.getText()) > maxIops))) {
			ctdcIops.show();
			ctdcIops.setShowHover(true);
			ctdcIops.setDescriptionText(msgIopsMustBeLessThanXTimesOfVolumeSize);
			ctdcIops.showHoverText(msgIopsMustBeLessThanXTimesOfVolumeSize);
		}
		else {
			ctdcIops.hide();
			ctdcIops.setDescriptionText("");
			ctdcIops.showHoverText("");
			ctdcIops.setShowHover(false);
		}

		if (messages.getString(IOPS_VALUE).equals(volumeType.getText()) &&
				((volumeSize.getText().isEmpty() && !cmbIops.getText().isEmpty()) || (!volumeSize.getText().isEmpty() && !cmbIops.getText().isEmpty() && Integer.parseInt(volumeSize.getText()) * multiply < Integer.parseInt(cmbIops.getText())))) {
			ctdcSize.show();
			ctdcSize.setShowHover(true);
			ctdcSize.setDescriptionText(msgMustGraterThanX);
			ctdcSize.showHoverText(msgMustGraterThanX);
		}
		else {
			ctdcSize.hide();
			ctdcSize.setDescriptionText("");
			ctdcSize.showHoverText("");
			ctdcSize.setShowHover(false);
		}
		
		//IOPS の場合　ストレージサイズは必須
		if(messages.getString(IOPS_VALUE).equals(volumeType.getText())){
			if(volumeSize.getText().equals("")){
				volumeSize.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
			} else {
				volumeSize.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
			}
		}
	}

	private void checkEbsOptimized(){
		if(paramEbsOptimized.getList().contains(type.getData(type.getText()))){
			btnLaunchAsAnEBSOptimized.setEnabled(true);
			btnLaunchAsAnEBSOptimized.setText(strEbsOptimizedDescription);
		} else {
			btnLaunchAsAnEBSOptimized.setEnabled(false);
			btnLaunchAsAnEBSOptimized.setSelection(false);
			btnLaunchAsAnEBSOptimized.setText(strEbsOptimizedDescriptionNoSupported);
		}
		btnLaunchAsAnEBSOptimized.getParent().layout();
	}
}
