/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.base.ui.dialogs;

import java.util.Arrays;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.base.resources.Filter;
import com.clustercontrol.cloud.aws.base.resources.Snapshot;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.CreateStorageRequest;
import com.clustercontrol.util.Messages;

public class CreateStorageDialog extends Dialog {
	public static class Decorator {
		private Combo control;
		
		private static ModifyListener modifyListener = new ModifyListener(){
			@Override
			public void modifyText(ModifyEvent e) {
				if(((Combo)e.getSource()).getText().equals("")){
					((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				} else {
					((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				}
			}
		};
		
		public Decorator(Combo control) {
			this.control = control;
			setEnabled(false);
		}
		
		public void setEnabled(boolean enable) {
			if (enable) {
				if (control.getText().equals("")) {
					control.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				}
				else {
					control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				}
				control.addModifyListener(modifyListener);
			}
			else {
				control.removeModifyListener(modifyListener);
				control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
			}
		}
	}

	public static class StorageDetail {
		public Integer iops;
	}
	
	private static final int multiply = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.multiply"));
	private static final int minIops = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.miniops"));
	private static final int maxIops = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.maxiops"));
	private static final int skip = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.skip"));
	
	public static class DialogData extends CreateStorageRequest {
		private String region;
		private Integer iops;
		public String getRegion() {
			return region;
		}
		public void setRegion(String region) {
			this.region = region;
		}
		public Integer getIops() {
			return iops;
		}
		public void setIops(Integer iops) {
			this.iops = iops;
		}
	}
	
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String strSeparator = messages.getString("caption.title_separator");
	private String strStorageName = messages.getString("word.storage_name");
	private String strStorageSize = messages.getString("word.storage_size");
	private String strSnapshot = messages.getString("word.snapshot");
	private String strVolumeType = messages.getString("word.volume_type");
	private String strRegion = messages.getString("word.region");
	private String strIops = messages.getString("word.iops");
	private String strCreateStorageDialog = messages.getString("caption.create_storage_dialog");
	private String strAvailabilityZone = messages.getString("word.availability_zone");
	private String msgMustFullyInput = messages.getString("message.must_fully_input");
	private String msgMustGraterThanX = messages.getString("message.iops_must_be_less_than_X_times_of_volume_size", new String[]{Integer.toString(multiply)});
	private String msgIopsMustBeLessThanXTimesOfVolumeSize = messages.getString("message.must_grater_than_X", new Object[]{Integer.toString(minIops), Integer.toString(maxIops)});
	

	private static final String IOPS_VALUE = "io1";
	
	private Text txtVolumeName;
	private Text txtSize;
	private Combo cmbUnitSize;
	private Combo cmbAvailabilityZone;
	private Combo cmbSnapshot;
	private Combo cmbVolumeType;
	private Combo cmbIops;
	private ControlDecoration ctdcIops;
	private ControlDecoration ctdcSize;
	private Label lblRegion;
	private Combo cmbRegion;

	private CloudResourceProvider provider;

	private DialogData input = new DialogData();
	private DialogData output = new DialogData();

	private IDialogBehavior behavior;
	
	private Decorator decorator; 
	
	public interface IDialogBehavior{
		void setProvider(CloudResourceProvider provider);
		
		void setupVolumeName(Text txtVolumeName);
		void setupSize(Text txtSize, Combo cmbUnit);
		void setupRegion(Combo cmbRegion);
		void setupAvailabilityZone(Combo cmbAvailabilityZone);
		void setupSnapshot(Combo cmbSnapshot);
		void setupVolumeType(Combo cmbVolumeType);
		void setupIops(Combo cmbIops);
	}
	
	public static class DialogBehavior implements IDialogBehavior{
		private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
		private CloudResourceProvider provider;
		private Combo cmbRegion;
		private Combo cmbAvailabilityZone;
		private Combo cmbSnapshot;

		@Override
		public void setProvider(CloudResourceProvider provider) {
			this.provider = provider;
		}

		@Override
		public void setupVolumeName(Text txtVolumeName) {}

		@Override
		public void setupSize(Text txtSize, Combo txtUnit) {}

		@Override
		public void setupRegion(final Combo cmbRegion) {
			this.cmbRegion = cmbRegion;
			cmbRegion.addModifyListener(new ModifyListener() {
				public void modifyText(ModifyEvent e) {
					String region = (String)cmbRegion.getData(cmbRegion.getText());

					if (cmbAvailabilityZone != null) {
						// アベイラビリティゾーンの入れ替え。
						List<AvailabilityZone> avs = provider.getAvailabilityZones(region);
						cmbAvailabilityZone.removeAll();
						for (AvailabilityZone name: avs) {
							cmbAvailabilityZone.add(name.getZoneName());
						}

						if (!avs.isEmpty()) {
							cmbAvailabilityZone.select(0);
						}
					}

					if (cmbSnapshot != null) {
						// スナップショットの入れ替え。
						cmbSnapshot.removeAll();
						cmbSnapshot.add("--- No Snapshot ---");
						
						 //リージョン毎のスナップショットの情報は、スナップショットにフォーカスが入った時に動作する。
//						List<Snapshot> snapshots = provider.getSnapshots(region, Arrays.asList(new CloudResourceProvider.MultiValueFilter[0]));
//						for (Snapshot s: snapshots) {
//							String snapshotName = s.getSnapshotId() + " -- " + s.getDescription();
//							cmbSnapshot.add(snapshotName);
//							cmbSnapshot.setData(snapshotName, s);
//						}

						cmbSnapshot.select(0);
					}
				}
			});

			for (String regionName: provider.getAllRegion()) {
				String regionLocaleName = messages.getString(regionName);
				cmbRegion.add(regionLocaleName);
				cmbRegion.setData(regionLocaleName, regionName);
			}
			
			if (cmbRegion.getItemCount() > 0) {
				cmbRegion.select(0);
			}
		}

		@Override
		public void setupAvailabilityZone(final Combo cmbAvailabilityZone) {
			this.cmbAvailabilityZone = cmbAvailabilityZone;

			if (cmbRegion != null) {
				String region = (String)cmbRegion.getData(cmbRegion.getText());

				// アベイラビリティゾーンの入れ替え。
				List<AvailabilityZone> avs = provider.getAvailabilityZones(region);
				cmbAvailabilityZone.removeAll();
				for (AvailabilityZone name: avs) {
					cmbAvailabilityZone.add(name.getZoneName());
				}

				if (!avs.isEmpty()) {
					cmbAvailabilityZone.select(0);
				}
			}
		}

		@Override
		public void setupSnapshot(final Combo cmbSnapshot) {
			this.cmbSnapshot = cmbSnapshot;

			cmbSnapshot.add("--- No Snapshot ---");
			cmbSnapshot.select(0);

			cmbSnapshot.addFocusListener(new FocusAdapter() {
				@Override
				public void focusGained(FocusEvent e) {
					// "--- No Snapshot ---" しか登録されていない場合、現在選択されているリージョンから、スナップショットのリストを取得。
					if (cmbSnapshot.getItemCount() <= 1) {
						List<Snapshot> snapshots = provider.getSnapshots((String)cmbRegion.getData(cmbRegion.getText()), Arrays.asList(new Filter[0]));
						for (Snapshot s: snapshots) {
							String snapshotName = s.getSnapshotId() + " -- " + s.getDescription();
							cmbSnapshot.add(snapshotName);
							cmbSnapshot.setData(snapshotName, s);
						}
					}
				}
			});	
		}

		@Override
		public void setupVolumeType(Combo volumeType) {
			for (String volumeTypeName: provider.getAllVolumeType()) {
				String volumeTypeLocaleName = messages.getString(volumeTypeName);
				volumeType.add(volumeTypeLocaleName);
				volumeType.setData(volumeTypeLocaleName, volumeTypeName);
			}
			volumeType.select(0);
		}

		@Override
		public void setupIops(Combo Iops) {
		}
	}
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateStorageDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(4, false);
		gl_container.horizontalSpacing = 15;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		Label lblVolumeName = new Label(container, SWT.NONE);
		lblVolumeName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblVolumeName.setText(strStorageName + strSeparator);
		
		txtVolumeName = new Text(container, SWT.BORDER);
		txtVolumeName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblSize = new Label(container, SWT.NONE);
		lblSize.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblSize.setText(strStorageSize + strSeparator);
		
		txtSize = new Text(container, SWT.BORDER);
		GridData gd_size = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_size.widthHint = 146;
		txtSize.setLayoutData(gd_size);
		
		ctdcSize = new ControlDecoration(txtSize, SWT.LEFT | SWT.TOP);
		ctdcSize.setImage(ResourceManager.getPluginImage(com.clustercontrol.cloud.Activator.ID, "icons/error.gif"));
		ctdcSize.setDescriptionText("");
		ctdcSize.hide();
		
		cmbUnitSize = new Combo(container, SWT.READ_ONLY);
		GridData gd_unitSize = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_unitSize.widthHint = 124;
		cmbUnitSize.setLayoutData(gd_unitSize);
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		lblRegion = new Label(container, SWT.NONE);
		lblRegion.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblRegion.setText(strRegion + strSeparator);
		
		cmbRegion = new Combo(container, SWT.READ_ONLY);
		cmbRegion.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblAvailabilityzone = new Label(container, SWT.NONE);
		lblAvailabilityzone.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblAvailabilityzone.setText(strAvailabilityZone + strSeparator);
		
		cmbAvailabilityZone = new Combo(container, SWT.READ_ONLY);
		cmbAvailabilityZone.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblSnapshot = new Label(container, SWT.NONE);
		lblSnapshot.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblSnapshot.setText(strSnapshot + strSeparator);
		
		cmbSnapshot = new Combo(container, SWT.READ_ONLY);
		GridData gd_snapshot = new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1);
		gd_snapshot.widthHint = 570;
		cmbSnapshot.setLayoutData(gd_snapshot);
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblVolumeType = new Label(container, SWT.NONE);
		lblVolumeType.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblVolumeType.setText(strVolumeType + strSeparator);
		
		cmbVolumeType = new Combo(container, SWT.READ_ONLY);
		GridData gd_volumeType = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_volumeType.widthHint = 220;
		cmbVolumeType.setLayoutData(gd_volumeType);
		
		Label lblIops = new Label(container, SWT.NONE);
		lblIops.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblIops.setText(strIops + strSeparator);
		
		cmbIops = new Combo(container, SWT.BORDER);
		GridData gd_iops = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_iops.widthHint = 208;
		cmbIops.setLayoutData(gd_iops);
		
		ctdcIops = new ControlDecoration(cmbIops, SWT.LEFT | SWT.TOP);
		ctdcIops.setImage(ResourceManager.getPluginImage(com.clustercontrol.cloud.Activator.ID, "icons/error.gif"));
		ctdcIops.hide();

		cmbUnitSize.add("GiB");
		cmbUnitSize.add("TiB");
		cmbUnitSize.select(0);
		cmbIops.setEnabled(false);

		behavior.setProvider(provider);
		behavior.setupVolumeName(txtVolumeName);
		behavior.setupSize(txtSize, cmbUnitSize);
		behavior.setupRegion(cmbRegion);
		behavior.setupAvailabilityZone(cmbAvailabilityZone);
		behavior.setupSnapshot(cmbSnapshot);
		behavior.setupVolumeType(cmbVolumeType);
		behavior.setupIops(cmbIops);
		
		txtSize.addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(FocusEvent e) {
				if(!"".equals(txtSize.getText())){
					String n = cmbIops.getText();
					cmbIops.removeAll();
					int iops = skip;
					while (iops <= maxIops) {
						cmbIops.add(Integer.toString(iops));
						iops += skip;
					}
					cmbIops.setText(n);
				}
			}
		});

		txtSize.addVerifyListener(new VerifyListener() {
			public void verifyText(VerifyEvent e) {
				try {
					String t = txtSize.getText().substring(0, e.start) + e.text + txtSize.getText().substring(e.start);
					if (t.length() != 0) {
						Integer.valueOf(t);
					}
				}
				catch(Exception e1) {
					e.doit = false;
				}
			}
		});
		
		txtSize.addModifyListener(new ModifyListener(){
			@Override
			public void modifyText(ModifyEvent e) {
				checkIops();
			}
		});

		cmbVolumeType.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				if(cmbVolumeType.getText().equals(messages.getString(IOPS_VALUE))){
					cmbIops.setEnabled(true);
					decorator.setEnabled(true);
				}
				else {
					decorator.setEnabled(false);
					cmbIops.setEnabled(false);
				}
				checkIops();
			}
		});

		cmbIops.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				checkIops();
			}
		});

		cmbIops.addVerifyListener(new VerifyListener() {
			public void verifyText(VerifyEvent e) {
				try {
					String t = cmbIops.getText().substring(0, e.start) + e.text + cmbIops.getText().substring(e.start);
					if (t.length() != 0) {
						Integer.valueOf(t);
					}
				}
				catch(Exception e1) {
					e.doit = false;
				}
			}
		});

		decorator = new Decorator(cmbIops);
		ControlUtil.setRequired(new Control[]{txtVolumeName, txtSize});

		if (input != null) {
			if (input.getZone() != null) cmbAvailabilityZone.setText(input.getZone());
			if (input.getStorageSize() != null) txtSize.setText(input.getStorageSize().toString());
			if (input.getIops() != null) cmbIops.setText(input.getIops().toString());
			if (input.getFlavor() != null) {
				for (int i = 0; i < cmbVolumeType.getItems().length; ++i) {
					if (input.getFlavor().equals(cmbVolumeType.getData(cmbVolumeType.getItems()[i]))) {
						cmbVolumeType.select(i);
						
						if(cmbVolumeType.getText().equals(messages.getString(IOPS_VALUE))){
							cmbIops.setEnabled(true);
							decorator.setEnabled(true);
						}
						else {
							decorator.setEnabled(false);
							cmbIops.setEnabled(false);
						}
						checkIops();
						break;
					}
				}
			}
		}

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {
		if("".equals(txtVolumeName.getText()) || "".equals(txtSize.getText())){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					msgMustFullyInput);
			return;
		}

		output = new DialogData();
		output.setStorageName(txtVolumeName.getText());
		output.setStorageSize(Integer.parseInt(txtSize.getText()));
		output.setRegion(((String)cmbRegion.getData(cmbRegion.getText())));
		output.setZone(cmbAvailabilityZone.getText());
		output.setSnapshotId((String)cmbSnapshot.getData(cmbSnapshot.getText()));
		output.setFlavor((String)cmbVolumeType.getData(cmbVolumeType.getText()));
		if (messages.getString(IOPS_VALUE).equals(cmbVolumeType.getText())) {
			output.setIops("".equals(cmbIops.getText()) || cmbIops.getText() == null ? null: Integer.parseInt(cmbIops.getText()));
		}

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strCreateStorageDialog);
	}

	public void checkIops(){
		if (messages.getString(IOPS_VALUE).equals(cmbVolumeType.getText()) &&
				((cmbIops.getText().isEmpty() || Integer.parseInt(cmbIops.getText()) < minIops || Integer.parseInt(cmbIops.getText()) > maxIops))) {
			ctdcIops.show();
			ctdcIops.setShowHover(true);
			ctdcIops.setDescriptionText(msgIopsMustBeLessThanXTimesOfVolumeSize);
			ctdcIops.showHoverText(msgIopsMustBeLessThanXTimesOfVolumeSize);
		}
		else {
			ctdcIops.hide();
			ctdcIops.setDescriptionText("");
			ctdcIops.showHoverText("");
			ctdcIops.setShowHover(false);
		}

		if (messages.getString(IOPS_VALUE).equals(cmbVolumeType.getText()) &&
				((txtSize.getText().isEmpty() && !cmbIops.getText().isEmpty()) || (!txtSize.getText().isEmpty() && !cmbIops.getText().isEmpty() && Integer.parseInt(txtSize.getText()) * multiply < Integer.parseInt(cmbIops.getText())))) {
			ctdcSize.show();
			ctdcSize.setShowHover(true);
			ctdcSize.setDescriptionText(msgMustGraterThanX);
			ctdcSize.showHoverText(msgMustGraterThanX);
		}
		else {
			ctdcSize.hide();
			ctdcSize.setDescriptionText("");
			ctdcSize.showHoverText("");
			ctdcSize.setShowHover(false);
		}
	}

	public CreateStorageDialog.DialogData getOutput() {
		return output;
	}

	public void setCloudInfoProvider(CloudResourceProvider provider) {
		this.provider = provider;
	}

	public void setBehavior(IDialogBehavior behavior) {
		this.behavior = behavior;
	}

	public void setInput(DialogData input) {
		this.input = input;
	}
}
