#!/bin/bash

# Copyright (C) 2011 NTT DATA Corporation
#
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../conf/hinemos_agent.cfg
AGENT_LIB=${HINEMOS_AGENT_HOME}/lib
AGENT_CONF=${HINEMOS_AGENT_HOME}/conf
TIMEOUT=3
export PROG=`basename $0`

# Logging
function Logging() {
    MODE=$2
    OPTS="-e"
    case ${MODE} in
        withline)
            EchoLine
            Logging "$1"
            EchoLine
            return 0
            ;;
        noreturn)
            OPTS="${OPTS} -n"
            ;;
        *)
            ;;
    esac
    echo ${OPTS} "$1" >&2
    /usr/bin/logger "${PROG} $1"
}

# change current directory
cd ${HINEMOS_AGENT_HOME}/var/log

# check process
if [ -f ${HINEMOS_AGENT_PID} ]
then
        read PID < ${HINEMOS_AGENT_PID}
        if [ `ps --no-headers --pid ${PID} e | grep "${JAVA_HOME}/bin/java.*com.clustercontrol.agent.Agent" | wc -l` -gt 0 ]
        then
                Logging "Hinemos Agent is running..."
                exit 1
        fi
fi

# check java version
if [ `${JAVA_HOME}/bin/java -version 2>&1 | grep '%%JAVA_CHECK_REGEX%%' | wc -l` -eq 0 ]
then
        Logging "This Java is not supported."
        ${JAVA_HOME}/bin/java -version 2>&1
        exit 1
fi
if [ `${JAVA_HOME}/bin/java -version 2>&1 | grep %%OPENJDK_CHECK_REGEX%% | wc -l` -eq 0 ]
then
        Logging "This Java is not supported."
        ${JAVA_HOME}/bin/java -version 2>&1
        exit 1
fi

# check version and module
STDOUT=${HINEMOS_AGENT_HOME}/var/log/agent_stdout.log
STDERR=${HINEMOS_AGENT_HOME}/var/log/agent_stderr.log

echo > ${STDOUT}
echo > ${STDERR}

echo "##############################" >> ${STDOUT}
echo "HinemosAgent Info" >> ${STDOUT}
echo "##############################" >> ${STDOUT}
echo OutputDate:`date +%Y%m%d%H%M%S` >> ${STDOUT}
echo VersionFile:`cat ${HINEMOS_AGENT_HOME}/_version` >> ${STDOUT}
echo SerialFile:`cat ${HINEMOS_AGENT_HOME}/var/_serial` >> ${STDOUT}
echo JavaVersion: >> ${STDOUT}
echo `${JAVA_HOME}/bin/java -version 2>&1` >> ${STDOUT}
echo PackageFile\(MD5\): >> ${STDOUT}
md5sum ${HINEMOS_AGENT_HOME}/lib/Hinemos*.jar >> ${STDOUT}
md5sum ${HINEMOS_AGENT_HOME}/lib/AgentWS.jar >> ${STDOUT}

# java option
JAVA_OPTS="${JAVA_OPTS} -server"
JAVA_OPTS="${JAVA_OPTS} ${JVM_HEAP_OPTS}"
JAVA_OPTS="${JAVA_OPTS} -Dhinemos.agent.log.dir=${HINEMOS_AGENT_LOG_DIR}"
JAVA_OPTS="${JAVA_OPTS} -XX:CMSInitiatingOccupancyFraction=75 -XX:+UseCMSInitiatingOccupancyOnly"
JAVA_OPTS="${JAVA_OPTS} -XX:+UseConcMarkSweepGC -XX:+CMSParallelRemarkEnabled -XX:+UseParNewGC -XX:+DisableExplicitGC"
JAVA_OPTS="${JAVA_OPTS} -XX:SurvivorRatio=3 -XX:MaxTenuringThreshold=32 -XX:TargetSurvivorRatio=90"
JAVA_OPTS="${JAVA_OPTS} ${JVM_GCLOG_OPTS}"
JAVA_OPTS="${JAVA_OPTS} ${JVM_JCONSOLE_OPTS}"
JAVA_OPTS="${JAVA_OPTS} ${JVM_OOM_OPTS}"

## classpath (java)
CP="${AGENT_LIB}/AgentWS.jar"
CP="${CP}:${AGENT_LIB}/HinemosAgent.jar"
CP="${CP}:${AGENT_LIB}/HinemosCommon.jar"
CP="${CP}:${AGENT_LIB}/commons-logging-1.1.1.jar"
CP="${CP}:${AGENT_LIB}/log4j-1.2.15.jar"
CP="${CP}:${AGENT_CONF}"

## startup
CMD="nohup ${JAVA_HOME}/bin/java ${JAVA_OPTS} -cp ${CP} com.clustercontrol.agent.Agent ${AGENT_CONF}/Agent.properties ${AGENT_CONF}/log4j.properties"
echo $CMD >> ${STDOUT}
$CMD >> ${STDOUT} 2>> ${STDERR} &
echo $! > ${HINEMOS_AGENT_PID}

## check process
read PID < ${HINEMOS_AGENT_PID}
for TIME in `seq 1 ${TIMEOUT}`
do
        sleep 1
        if [ `ps --no-headers --pid ${PID} e | grep "${JAVA_HOME}/bin/java.*com.clustercontrol.agent.Agent" | wc -l` -gt 0 ]
        then
                Logging "Hinemos Agent started."
                exit 0
        fi
done

Logging "Hinemos Agent startup failed."
exit 1
