/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.factory.CloudAccessorUtil;
import com.clustercontrol.cloud.util.AuthorizingUtil;
import com.clustercontrol.cloud.validation.CustomEntityValidator;
import com.clustercontrol.cloud.validation.EntityValidator;
import com.clustercontrol.cloud.validation.ValidationConstants;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.annotation.CustomEntityValidation;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.Size;

@CustomEntityValidation(value=CloudUserValidator.class)
public class CreateCloudUserRequest {
    private String cloudUserId;
    private String cloudUserName;
    private String accountResourceId;
    private String description;
    private String accessKey;
    private String secretKey;
    private String roleId;

    @ElementId(value="cloudUserId")
    @Identity
    public String getCloudUserId() {
        return this.cloudUserId;
    }

    public void setCloudUserId(String cloudUserId) {
        this.cloudUserId = cloudUserId;
    }

    @ElementId(value="cloudUserName")
    @NotNull
    @Size(max=128)
    public String getCloudUserName() {
        return this.cloudUserName;
    }

    public void setCloudUserName(String cloudUserName) {
        this.cloudUserName = cloudUserName;
    }

    @ElementId(value="accountResourceId")
    @Identity
    public String getAccountResourceId() {
        return this.accountResourceId;
    }

    public void setAccountResourceId(String accountResourceId) {
        this.accountResourceId = accountResourceId;
    }

    @ElementId(value="description")
    @Size(max=256)
    @NotNull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ElementId(value="accessKey")
    @Size(max=64)
    @NotNull
    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @ElementId(value="secretKey")
    @Size(max=8192)
    @NotNull
    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @ElementId(value="roleId")
    @Identity
    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public static class CloudUserValidator
    implements CustomEntityValidator<CreateCloudUserRequest>,
    ValidationConstants {
        public void validate(CreateCloudUserRequest entity, String group, IMessagesHolder messages, EntityValidator.EntityValidationContext context) throws ValidationFault {
            try {
                if (!AuthorizingUtil.checkHinemousUser_administrators_account(SessionService.current().getHinemosCredential().getUserId(), entity.getAccountResourceId())) {
                    throw ErrorCode.NEED_ADMINISTRATORS_ROLE_OR_ACCOUNT_USER.cloudManagerFault(SessionService.current().getHinemosCredential().getUserId(), entity.getAccountResourceId());
                }
                CloudAccessorUtil.getUser(entity.getAccountResourceId(), entity.getAccessKey(), entity.getSecretKey());
            }
            catch (CloudManagerFault e) {
                throw new ValidationFault(e.getMessage(), e.getErrorCode(), (Throwable)((Object)e));
            }
        }
    }
}

