/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudRequest;
import com.clustercontrol.cloud.util.AuthorizingUtil;
import com.clustercontrol.cloud.validation.CustomEntityValidator;
import com.clustercontrol.cloud.validation.EntityValidator;
import com.clustercontrol.cloud.validation.ModifiableAccountResource;
import com.clustercontrol.cloud.validation.ValidationConstants;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.annotation.CustomEntityValidation;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.Size;

@CustomEntityValidation(value=ModifyAccountResourceValidator.class)
public class ModifyAccountResourceRequest
extends CloudRequest {
    private String accountResourceId;
    private String accountResourceName;
    private String description;

    @ElementId(value="accountResourceId")
    @Identity
    @ModifiableAccountResource
    public String getAccountResourceId() {
        return this.accountResourceId;
    }

    public void setAccountResourceId(String accountResourceId) {
        this.accountResourceId = accountResourceId;
    }

    @ElementId(value="accountResourceName")
    @Size(max=128)
    public String getAccountResourceName() {
        return this.accountResourceName;
    }

    public void setAccountResourceName(String accountResourceName) {
        this.accountResourceName = accountResourceName;
    }

    @ElementId(value="description")
    @Size(max=256)
    @NotNull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static class ModifyAccountResourceValidator
    implements CustomEntityValidator<ModifyAccountResourceRequest>,
    ValidationConstants {
        public void validate(ModifyAccountResourceRequest entity, String group, IMessagesHolder messages, EntityValidator.EntityValidationContext context) throws ValidationFault {
            try {
                if (!AuthorizingUtil.checkHinemousUser_administrators_account(SessionService.current().getHinemosCredential().getUserId(), entity.getAccountResourceId())) {
                    throw ErrorCode.NEED_ADMINISTRATORS_ROLE_OR_ACCOUNT_USER.cloudManagerFaultByIndex(1, SessionService.current().getHinemosCredential().getUserId(), entity.getAccountResourceId());
                }
            }
            catch (CloudManagerFault e) {
                throw new ValidationFault((Throwable)((Object)e));
            }
        }
    }
}

