/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory.monitors;

import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudRegion;
import com.clustercontrol.cloud.bean.CloudService;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.InstanceStateKind;
import com.clustercontrol.cloud.commons.CloudPropertyConstants;
import com.clustercontrol.cloud.factory.IStorageOperator;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.CloudCredential;
import com.clustercontrol.cloud.util.RepositoryControllerBeanWrapper;
import com.clustercontrol.cloud.util.ResourceRegion;
import com.clustercontrol.cloud.util.ResourceUtil;
import com.clustercontrol.repository.bean.NodeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class InstanceMonitorService {
    private Map<String, InstanceInfo> instanceInfoMap = new HashMap<String, InstanceInfo>();
    private final int interval;
    private final int maxPingCount;
    private final ScheduledExecutorService executor;
    private List<InstanceTraceListner> listeners = Collections.synchronizedList(new ArrayList());
    private ScheduledFuture<?> sf;
    private static InstanceMonitorService singleton;

    private InstanceMonitorService(int interval, int maxPingCount) {
        this.interval = interval;
        this.maxPingCount = maxPingCount;
        this.executor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "InstanceMonitorService-thread-1");
            }
        }){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                SessionService.current().close();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitor(String indtanecId, String facilityId, SessionService.ContextData data, CloudService service, CloudRegion region, CloudUser user, boolean updateStorage, InstanceStateKind ... stoppedStatus) {
        if (CloudPropertyConstants.autoupdate_node.match("off")) {
            return;
        }
        Map<String, InstanceInfo> map = this.instanceInfoMap;
        synchronized (map) {
            InstanceInfo info = new InstanceInfo();
            info.facilityId = facilityId;
            info.data = data;
            info.service = service;
            info.region = region;
            info.user = user;
            info.stoppedStatus = stoppedStatus;
            info.pingCount = 0;
            info.updateStorage = updateStorage;
            this.instanceInfoMap.put(indtanecId, info);
            if (this.sf == null) {
                this.sf = this.executor.scheduleWithFixedDelay(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Map map = InstanceMonitorService.this.instanceInfoMap;
                        synchronized (map) {
                            RepositoryControllerBeanWrapper bean = RepositoryControllerBeanWrapper.bean();
                            Logger logger = Logger.getLogger(InstanceMonitorService.class);
                            for (Map.Entry entry : InstanceMonitorService.this.instanceInfoMap.entrySet()) {
                                logger.debug((Object)("instanceid : " + (String)entry.getKey() + ", condition : " + ((InstanceInfo)entry.getValue()).stoppedStatus.toString()));
                                ++((InstanceInfo)entry.getValue()).pingCount;
                                try {
                                    SessionService.changeContext((SessionService.ContextData)((InstanceInfo)entry.getValue()).data);
                                    IResourceManagement rm = (IResourceManagement)ObjectRegistryService.registry().get(IResourceManagement.class, (Object)((InstanceInfo)entry.getValue()).service.getCloudTypeId());
                                    if (rm == null) {
                                        throw new InternalManagerError();
                                    }
                                    rm.setAccessDestination(new CloudCredential(((InstanceInfo)entry.getValue()).user), new ResourceRegion(((InstanceInfo)entry.getValue()).region));
                                    IResourceManagement.Instance instance = rm.getInstance((String)entry.getKey());
                                    NodeInfo node = bean.getNode(((InstanceInfo)entry.getValue()).facilityId);
                                    if (node.getIpAddressV4() == null || instance.getIpAddress() == null && !"123.123.123.123".equals(node.getIpAddressV4()) || instance.getIpAddress() != null && !node.getIpAddressV4().equals(instance.getIpAddress())) {
                                        String oldIpAddress = node.getIpAddressV4();
                                        if (instance.getIpAddress() != null) {
                                            node.setIpAddressV4(instance.getIpAddress());
                                        } else {
                                            node.setIpAddressV4("123.123.123.123");
                                        }
                                        logger.info((Object)("Change Node, Method=autoRegist, CloudUser=" + ((InstanceInfo)entry.getValue()).user.getCloudUserId() + ", FacilityID=" + node.getFacilityId() + ", InstanceId=" + instance.getInstanceId() + ", OldIpAddress=" + oldIpAddress + ", NewIpAddress=" + node.getIpAddressV4()));
                                        bean.modifyNode(node);
                                    }
                                    if (((InstanceInfo)entry.getValue()).updateStorage) {
                                        IStorageOperator operator = ResourceUtil.getResourceOperator(IStorageOperator.class);
                                        for (IResourceManagement.Instance.BlockDeviceMapping ibd : instance.getBlockDeviceMappings()) {
                                            operator.updateStorage(ibd.getStorageId());
                                        }
                                    }
                                    for (InstanceStateKind state : ((InstanceInfo)entry.getValue()).stoppedStatus) {
                                        if (!state.equals((Object)instance.getState())) continue;
                                        InstanceMonitorService.this.instanceInfoMap.remove(entry.getKey());
                                        break;
                                    }
                                    if (InstanceMonitorService.this.maxPingCount == ((InstanceInfo)entry.getValue()).pingCount) {
                                        InstanceMonitorService.this.instanceInfoMap.remove(entry.getKey());
                                    }
                                    for (InstanceTraceListner listener : InstanceMonitorService.this.listeners) {
                                        listener.onNotify(((InstanceInfo)entry.getValue()).user.getAccountResourceId(), instance);
                                    }
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                    InstanceMonitorService.this.instanceInfoMap.remove(entry.getKey());
                                    for (InstanceTraceListner listener : InstanceMonitorService.this.listeners) {
                                        listener.onError(((InstanceInfo)entry.getValue()).user.getAccountResourceId(), (String)entry.getKey(), e);
                                    }
                                }
                            }
                            InstanceMonitorService.this.mustStop();
                        }
                    }
                }, this.interval, this.interval, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitor(String indtanecId) {
        Map<String, InstanceInfo> map = this.instanceInfoMap;
        synchronized (map) {
            this.instanceInfoMap.remove(indtanecId);
            this.mustStop();
        }
    }

    private void mustStop() {
        if (this.sf != null && this.instanceInfoMap.isEmpty()) {
            this.sf.cancel(true);
            this.sf = null;
        }
    }

    public void shutdown() {
        this.executor.shutdown();
        this.instanceInfoMap.clear();
    }

    public void addListener(InstanceTraceListner listner) {
        this.listeners.add(listner);
    }

    public void removeListener(InstanceTraceListner listner) {
        this.listeners.remove(listner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InstanceMonitorService getSingleton() {
        if (singleton != null) return singleton;
        Class<InstanceMonitorService> clazz = InstanceMonitorService.class;
        synchronized (InstanceMonitorService.class) {
            if (singleton != null) return singleton;
            singleton = new InstanceMonitorService(Integer.valueOf(CloudPropertyConstants.registcheck_interval.value()), Integer.valueOf(CloudPropertyConstants.registcheck_count.value()));
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private static class InstanceInfo {
        public String facilityId;
        public SessionService.ContextData data;
        public CloudService service;
        public CloudRegion region;
        public CloudUser user;
        public InstanceStateKind[] stoppedStatus;
        public int pingCount;
        public boolean updateStorage;

        private InstanceInfo() {
        }
    }

    public static interface InstanceTraceListner {
        public void onNotify(String var1, IResourceManagement.Instance var2);

        public void onError(String var1, String var2, Exception var3);
    }
}

