/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.cloud.validation.annotation.Size;

public class InstanceDetail {
	private String flavor;
	private String networkId;
	private List<Tag> tags = new ArrayList<Tag>();

	public String getFlavor() {
		return flavor;
	}

	public void setFlavor(String flavor) {
		this.flavor = flavor;
	}
	/**
	 * EC2 インスタンスを起動するサブネット Id を取得する。
	 * 
	 * @return サブネット Id
	 */
	@Size(max=64)
	public String getNetworkId() {
		return networkId;
	}

	/**
	 * EC2 インスタンスを起動するサブネット Id を指定する。
	 * この値は、64 文字以内となります。
	 * 
	 * @param subnetId サブネット Id
	 */
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}

	public List<Tag> getTags() {
		return tags;
	}

	public void setTags(List<Tag> tags) {
		this.tags = tags;
	}
}
