/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.factory;

import javax.persistence.NoResultException;
import javax.persistence.Query;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.IUserManagement;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.registry.ObjectRegistryService;

public class CloudAccessorUtil {
	public static IResourceManagement getResourceManagement(String accountResourceId) throws CloudManagerFault {
		return ObjectRegistryService.registry().get(IResourceManagement.class, getCloudTypeId(accountResourceId));
	}

	public static IUserManagement getUserManagement(String accountResourceId) throws CloudManagerFault {
		return ObjectRegistryService.registry().get(IUserManagement.class, getCloudTypeId(accountResourceId));
	}

	public static IUserManagement.User getUser(String accountResourceId, String accessKey, String secretKey) throws CloudManagerFault {
		IUserManagement um = CloudAccessorUtil.getUserManagement(accountResourceId);
		um.setCredential(new IUserManagement.Credential(accessKey, secretKey));
		IUserManagement.User user = um.getCurrentUser();
		if (user == null) {
			throw ErrorCode.CLOUDUSER_INVALID_ACCESSKEY.cloudManagerFault();
		}
		return user;
	}

	public static String getCloudTypeId(String accountResourceId) throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		Query query = em.createQuery("select s.cloudTypeId from CloudServiceDao s left join CloudAccountResourceDao r on (s.cloudServiceId = r.cloudServiceId) where r.accountResourceId = '" + accountResourceId + "'");
		
		try {
			return (String)query.getSingleResult();
		}
		catch(NoResultException e) {
			throw ErrorCode.ACCOUNTRESOURCE_INVALID_ACCOUNTRESOURCE_NOT_FOUND.cloudManagerFault(accountResourceId);
		}
	}
}
