/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.validation;

import java.lang.reflect.Method;

import javax.persistence.NoResultException;
import javax.persistence.Query;

import com.clustercontrol.accesscontrol.bean.RoleIdConstant;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.validation.MethodValidator.MethodValidationContext;

public class AuthorizingValidator_get_clouduser implements CustomMethodValidator {
	@Override
	public void validate(Method method, Object[] params, String group, IMessagesHolder messages, MethodValidationContext context) throws ValidationFault {
		try {
			EntityManagerEx em = SessionService.current().getEntityManagerEx();
			Query query = em.createQuery("SELECT DISTINCT c FROM CloudUserDao c JOIN c.accountResource a JOIN RoleEntity r ON c.roleId = r.roleId " +
					"WHERE c.cloudUserId = :cloudUserId " +
					"AND (:userId IN (SELECT u.userId FROM r.userEntities u) " +
						"OR EXISTS (SELECT u FROM UserEntity u JOIN u.roleEntities r WHERE u.userId = :userId AND r.roleId = :ADMINISTRATORS) " +
						"OR EXISTS (SELECT c2 FROM CloudUserDao c2 JOIN c2.accountResource a JOIN RoleEntity r ON c2.roleId = r.roleId JOIN r.userEntities u " +
							"WHERE u.userId = :userId AND c2.accountResource.accountResourceId = c.accountResource.accountResourceId AND c2.cloudUserId = c2.accountResource.account.cloudUserId))");
			query.setParameter("userId", SessionService.current().getHinemosCredential().getUserId());
			query.setParameter("cloudUserId", (String)params[0]);
			query.setParameter("ADMINISTRATORS", RoleIdConstant.ADMINISTRATORS);
			
			try {
				query.getSingleResult();
			}
			catch (NoResultException e) {
				throw ErrorCode.CLOUDUSER_NOT_FOUND.cloudManagerFault((String)params[0]);
			}
		}
		catch (CloudManagerFault e) {
			throw new ValidationFault(e);
		}
	}
}