SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

BEGIN;

--\set ON_ERROR_STOP

COPY cc_collector_platform_mst (platform_id, platform_name, order_no) FROM stdin (DELIMITER ',');
AWS,Amazon Web Services,110
\.

COMMIT;

BEGIN;

--\set ON_ERROR_STOP

COPY cc_collector_sub_platform_mst (sub_platform_id, sub_platform_name, type, order_no) FROM stdin (DELIMITER ',');
AWS,Amazon Web Services,Cloud,110
\.

COMMIT;

BEGIN;

--\set ON_ERROR_STOP

COPY cc_cloud_type_mst (cloud_id, cloud_name, description) FROM stdin (DELIMITER ',');
AWS,AWS,AWS
\.

COMMIT;

BEGIN;

--\set ON_ERROR_STOP

COPY cc_cloud_service (cloud_service_id, cloud_service_name, cloud_type_id, description) FROM stdin (DELIMITER ',');
AWS,Amazon Web Services,AWS,http://aws.amazon.com/jp/ 
\.

COMMIT;

BEGIN;

--\set ON_ERROR_STOP

COPY cc_cloud_region (region, cloud_service_id, region_name, description) FROM stdin (DELIMITER ',');
us-east-1,AWS,米国東部(バージニア北部),EC2 利用可能ゾーン数: 5*    2006 年開始
us-west-2,AWS,米国西部(オレゴン),EC2 利用可能ゾーン数: 3    2011年開始
us-west-1,AWS,米国西部(北カリフォルニア),EC2 利用可能ゾーン数: 3*    2009 年開始
eu-west-1,AWS,欧州(アイルランド),EC2 利用可能ゾーン数: 3    2007年開始
ap-southeast-1,AWS,アジアパシフィック(シンガポール),EC2 利用可能ゾーン数: 2    2010年開始
ap-southeast-2,AWS,アジアパシフィック(シドニー),EC2 利用可能ゾーン数: 2    2012 年開始
ap-northeast-1,AWS,アジアパシフィック(東京),EC2 利用可能ゾーン数: 3    2011年開始
sa-east-1,AWS,南アメリカ (サンパウロ),EC2 利用可能ゾーン数: 2    2011年開始
\.

COMMIT;

BEGIN;

--\set ON_ERROR_STOP
--\http://docs.aws.amazon.com/general/latest/gr/rande.html
COPY cc_cloud_endpoint (ep_type, cloud_service_id, region, location) FROM stdin (DELIMITER ',');
ec2,AWS,us-east-1,ec2.us-east-1.amazonaws.com
ec2,AWS,us-west-2,ec2.us-west-2.amazonaws.com
ec2,AWS,us-west-1,ec2.us-west-1.amazonaws.com
ec2,AWS,eu-west-1,ec2.eu-west-1.amazonaws.com
ec2,AWS,ap-southeast-1,ec2.ap-southeast-1.amazonaws.com
ec2,AWS,ap-southeast-2,ec2.ap-southeast-2.amazonaws.com
ec2,AWS,ap-northeast-1,ec2.ap-northeast-1.amazonaws.com
ec2,AWS,sa-east-1,ec2.sa-east-1.amazonaws.com
elb,AWS,us-east-1,elasticloadbalancing.us-east-1.amazonaws.com
elb,AWS,us-west-2,elasticloadbalancing.us-west-2.amazonaws.com
elb,AWS,us-west-1,elasticloadbalancing.us-west-1.amazonaws.com
elb,AWS,eu-west-1,elasticloadbalancing.eu-west-1.amazonaws.com
elb,AWS,ap-southeast-1,elasticloadbalancing.ap-southeast-1.amazonaws.com
elb,AWS,ap-southeast-2,elasticloadbalancing.ap-southeast-2.amazonaws.com
elb,AWS,ap-northeast-1,elasticloadbalancing.ap-northeast-1.amazonaws.com
elb,AWS,sa-east-1,elasticloadbalancing.sa-east-1.amazonaws.com
CloudWatch,AWS,us-east-1,monitoring.us-east-1.amazonaws.com
CloudWatch,AWS,us-west-2,monitoring.us-west-2.amazonaws.com
CloudWatch,AWS,us-west-1,monitoring.us-west-1.amazonaws.com
CloudWatch,AWS,eu-west-1,monitoring.eu-west-1.amazonaws.com
CloudWatch,AWS,ap-southeast-1,monitoring.ap-southeast-1.amazonaws.com
CloudWatch,AWS,ap-southeast-2,monitoring.ap-southeast-2.amazonaws.com
CloudWatch,AWS,ap-northeast-1,monitoring.ap-northeast-1.amazonaws.com
CloudWatch,AWS,sa-east-1,monitoring.sa-east-1.amazonaws.com
\.

COMMIT;

BEGIN;

COPY cc_monitor_process_method_mst (platform_id, sub_platform_id, collect_method) FROM stdin (DELIMITER ',');
LINUX,AWS,SNMP
WINDOWS,AWS,SNMP
OTHER,AWS,SNMP
\.

COMMIT;

BEGIN;

COPY cc_monitor_process_polling_mst (collect_method, platform_id, sub_platform_id, variable_id, entry_key, polling_target) FROM stdin (DELIMITER ',');
SNMP,LINUX,AWS,path,.1.3.6.1.2.1.25.4.2.1.4.*,.1.3.6.1.2.1.25.4.2.1.4
SNMP,LINUX,AWS,param,.1.3.6.1.2.1.25.4.2.1.5.*,.1.3.6.1.2.1.25.4.2.1.5
SNMP,LINUX,AWS,name,.1.3.6.1.2.1.25.4.2.1.2.*,.1.3.6.1.2.1.25.4.2.1.2
SNMP,WINDOWS,AWS,path,.1.3.6.1.2.1.25.4.2.1.4.*,.1.3.6.1.2.1.25.4.2.1.4
SNMP,WINDOWS,AWS,param,.1.3.6.1.2.1.25.4.2.1.5.*,.1.3.6.1.2.1.25.4.2.1.5
SNMP,WINDOWS,AWS,name,.1.3.6.1.2.1.25.4.2.1.2.*,.1.3.6.1.2.1.25.4.2.1.2
WBEM,LINUX,AWS,param,Linux_UnixProcess.Parameters.*,Linux_UnixProcess.Parameters
WBEM,LINUX,AWS,name,Linux_UnixProcess.ModulePath.*,Linux_UnixProcess.ModulePath
\.

COMMIT;
