/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.validation;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.util.RepositoryControllerBeanWrapper;
import com.clustercontrol.cloud.validation.CustomMethodValidator;
import com.clustercontrol.cloud.validation.MethodValidator;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.repository.bean.FacilityTreeItem;
import java.lang.reflect.Method;
import java.util.Locale;

public class AuthorizingValidator_facility
implements CustomMethodValidator {
    public void validate(Method method, Object[] params, String group, IMessagesHolder messages, MethodValidator.MethodValidationContext context) throws ValidationFault {
        try {
            FacilityTreeItem treeItem;
            try {
                treeItem = RepositoryControllerBeanWrapper.bean().getFacilityTree(null, Locale.getDefault());
            }
            catch (HinemosUnknown e1) {
                throw ErrorCode.HINEMOS_MANAGER_ERROR.cloudManagerFault((Exception)((Object)e1));
            }
            if (this.serarchFacility(treeItem, (String)params[0]) == null) {
                throw ErrorCode.FACILITY_NOT_FOUND.cloudManagerFault((String)params[0]);
            }
        }
        catch (CloudManagerFault e) {
            throw new ValidationFault((Throwable)((Object)e));
        }
    }

    private FacilityTreeItem serarchFacility(FacilityTreeItem treeItem, String facilityId) {
        if (!treeItem.getData().isNotReferFlg().booleanValue() && treeItem.getData().getFacilityId().equals(facilityId)) {
            return treeItem;
        }
        for (FacilityTreeItem child : treeItem.getChildrenArray()) {
            FacilityTreeItem result = this.serarchFacility(child, facilityId);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

