/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util;

import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.persistence.TransactionException;
import com.clustercontrol.cloud.util.HinemosUtil;
import com.clustercontrol.cloud.util.ITaskResult;
import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.fault.NotifyDuplicate;
import com.clustercontrol.fault.NotifyNotFound;
import com.clustercontrol.fault.UsedFacility;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.notify.bean.OutputBasicInfo;
import com.clustercontrol.notify.session.NotifyControllerBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class NotifyControllerBeanWrapper
extends NotifyControllerBean {
    private static ThreadLocal<NotifyControllerBeanWrapper> instance = new ThreadLocal<NotifyControllerBeanWrapper>(){

        @Override
        protected NotifyControllerBeanWrapper initialValue() {
            return null;
        }
    };

    public NotifyInfo getNotify(final String notifyId) throws NotifyNotFound, InvalidRole, HinemosUnknown {
        try {
            return this.execute(new Callable<NotifyInfo>(){

                @Override
                public NotifyInfo call() throws Exception {
                    return new NotifyControllerBean().getNotify(notifyId);
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof NotifyNotFound) {
                throw new NotifyNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public boolean addNotify(final NotifyInfo info) throws NotifyDuplicate, InvalidSetting, InvalidRole, HinemosUnknown {
        try {
            boolean result = this.execute(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return new NotifyControllerBean().addNotify(info);
                }
            });
            SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                @Override
                public void rollback() throws TransactionException {
                    try {
                        NotifyControllerBeanWrapper.this.execute(new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                new NotifyControllerBean().deleteNotify(info.getNotifyId());
                                return null;
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new TransactionException((Throwable)e);
                    }
                }
            });
            return result;
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof NotifyDuplicate) {
                throw new NotifyDuplicate(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof InvalidSetting) {
                throw new InvalidSetting(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public boolean deleteNotify(final String notifyId) throws NotifyNotFound, InvalidRole, HinemosUnknown {
        try {
            ITaskResult<Boolean> result = this.execute(new Callable<ITaskResult<Boolean>>(){

                @Override
                public ITaskResult<Boolean> call() throws Exception {
                    NotifyControllerBean bean = new NotifyControllerBean();
                    final NotifyInfo info = bean.getNotify(notifyId);
                    final boolean result = bean.deleteNotify(notifyId);
                    ITaskResult<Boolean> rolebackAction = new ITaskResult<Boolean>(){

                        @Override
                        public void rollback() throws TransactionException {
                            try {
                                NotifyControllerBeanWrapper.this.execute(new Callable<Object>(){

                                    @Override
                                    public Object call() throws Exception {
                                        new NotifyControllerBean().addNotify(info);
                                        return null;
                                    }
                                });
                            }
                            catch (Exception e) {
                                throw new TransactionException((Throwable)e);
                            }
                        }

                        @Override
                        public Boolean getResult() throws Exception {
                            return result;
                        }
                    };
                    return rolebackAction;
                }
            });
            SessionService.current().addRollbackAction(result);
            return result.getResult();
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof NotifyNotFound) {
                throw new NotifyNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    private <T> T execute(Callable<T> task) throws Exception {
        return HinemosUtil.submit(task).get();
    }

    public static NotifyControllerBeanWrapper bean() {
        NotifyControllerBeanWrapper bean = instance.get();
        if (bean == null) {
            bean = new NotifyControllerBeanWrapper();
            instance.set(bean);
        }
        return bean;
    }

    public boolean modifyNotify(NotifyInfo info) throws NotifyDuplicate, InvalidRole, HinemosUnknown, InvalidSetting {
        throw new UnsupportedOperationException();
    }

    public ArrayList<NotifyInfo> getNotifyList() throws NotifyNotFound, InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<NotifyInfo> getNotifyListByOwnerRole(String ownerRoleId) throws InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public HashMap<String, NotifyInfo> getNotifyMap() throws InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<NotifyRelationInfo> getNotifyRelation(final String notifyGroupId) throws InvalidRole, HinemosUnknown {
        try {
            return this.execute(new Callable<ArrayList<NotifyRelationInfo>>(){

                @Override
                public ArrayList<NotifyRelationInfo> call() throws Exception {
                    return new NotifyControllerBean().getNotifyRelation(notifyGroupId);
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public boolean modifyNotifyRelation(final Collection<NotifyRelationInfo> info, final String notifyGroupId) throws NotifyNotFound, InvalidRole, HinemosUnknown {
        try {
            ITaskResult<Boolean> result = this.execute(new Callable<ITaskResult<Boolean>>(){

                @Override
                public ITaskResult<Boolean> call() throws Exception {
                    NotifyControllerBean bean = new NotifyControllerBean();
                    final ArrayList relations = bean.getNotifyRelation(notifyGroupId);
                    final boolean result = bean.modifyNotifyRelation(info, notifyGroupId);
                    ITaskResult<Boolean> rolebackAction = new ITaskResult<Boolean>(){

                        @Override
                        public void rollback() throws TransactionException {
                            try {
                                NotifyControllerBeanWrapper.this.execute(new Callable<Object>(){

                                    @Override
                                    public Object call() throws Exception {
                                        NotifyControllerBean bean = new NotifyControllerBean();
                                        bean.modifyNotifyRelation((Collection)relations, notifyGroupId);
                                        return null;
                                    }
                                });
                            }
                            catch (Exception e) {
                                throw new TransactionException((Throwable)e);
                            }
                        }

                        @Override
                        public Boolean getResult() throws Exception {
                            return result;
                        }
                    };
                    return rolebackAction;
                }
            });
            SessionService.current().addRollbackAction(result);
            return result.getResult();
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public boolean deleteNotifyRelation(String notifyGroupId) throws InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public boolean addNotifyRelation(final Collection<NotifyRelationInfo> info) throws InvalidRole, HinemosUnknown {
        try {
            ITaskResult<Boolean> result = this.execute(new Callable<ITaskResult<Boolean>>(){

                @Override
                public ITaskResult<Boolean> call() throws Exception {
                    NotifyControllerBean bean = new NotifyControllerBean();
                    HashMap map = new HashMap();
                    final ArrayList relations = new ArrayList(info);
                    Iterator iter = relations.iterator();
                    block0: while (iter.hasNext()) {
                        NotifyRelationInfo relation = (NotifyRelationInfo)iter.next();
                        ArrayList rs = (ArrayList)map.get(relation.getNotifyGroupId());
                        if (rs == null) {
                            rs = bean.getNotifyRelation(relation.getNotifyGroupId());
                            if (rs == null) {
                                rs = Collections.emptyList();
                            }
                            map.put(relation.getNotifyGroupId(), rs);
                        }
                        for (NotifyRelationInfo r : rs) {
                            if (!relation.getNotifyId().equals(r.getNotifyId())) continue;
                            iter.remove();
                            continue block0;
                        }
                    }
                    final boolean result = bean.addNotifyRelation(relations);
                    ITaskResult<Boolean> rolebackAction = new ITaskResult<Boolean>(){

                        @Override
                        public void rollback() throws TransactionException {
                            try {
                                NotifyControllerBeanWrapper.this.execute(new Callable<Object>(){

                                    @Override
                                    public Object call() throws Exception {
                                        NotifyControllerBean bean = new NotifyControllerBean();
                                        block0: for (NotifyRelationInfo relation : relations) {
                                            ArrayList rs = new ArrayList(bean.getNotifyRelation(relation.getNotifyGroupId()));
                                            Iterator iter = rs.iterator();
                                            while (iter.hasNext()) {
                                                NotifyRelationInfo r = (NotifyRelationInfo)iter.next();
                                                if (!r.getNotifyId().equals(relation.getNotifyId())) continue;
                                                iter.remove();
                                                bean.deleteNotifyRelation(relation.getNotifyGroupId());
                                                bean.addNotifyRelation(rs);
                                                continue block0;
                                            }
                                        }
                                        return null;
                                    }
                                });
                            }
                            catch (Exception e) {
                                throw new TransactionException((Throwable)e);
                            }
                        }

                        @Override
                        public Boolean getResult() throws Exception {
                            return result;
                        }
                    };
                    return rolebackAction;
                }
            });
            SessionService.current().addRollbackAction(result);
            return result.getResult();
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public ArrayList<String> checkNotifyId(String notifyId) throws InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void setNotifyStatus(String notifyId, boolean validFlag) throws HinemosUnknown, NotifyNotFound, NotifyDuplicate, InvalidRole {
        throw new UnsupportedOperationException();
    }

    public void isUseFacilityId(String facilityId) throws UsedFacility {
        throw new UnsupportedOperationException();
    }

    public void insertEventLog(OutputBasicInfo output, int confirmState) throws InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void sendAfterConvertHostname(String ipAddress, int port, String facility, String severity, String facilityId, String message, String timeStamp) throws InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void sendMail(String[] address, OutputBasicInfo outputBasicInfo) throws InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void notify(String pluginId, String monitorId, String facilityId, String subKey, long generationDate, int priority, String application, String messageId, String message, String messageOrg, ArrayList<String> notifyIdList, String srcId) throws FacilityNotFound, HinemosUnknown, NotifyNotFound, InvalidRole {
        throw new UnsupportedOperationException();
    }

    public void notify(final OutputBasicInfo notifyInfo, final String notifyGroupId) {
        try {
            this.execute(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    new NotifyControllerBean().notify(notifyInfo, notifyGroupId);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    protected void notify(OutputBasicInfo notifyInfo, List<String> notifyIdList) {
        throw new UnsupportedOperationException();
    }
}

