/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.rest.api;

import com.clustercontrol.cloud.Messages;
import com.clustercontrol.cloud.cloudn.rest.api.RestfulApplicationException;
import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;

public class CloudnRestfulApplicationError {
    private static final List<CloudnRestfulApplicationError> errors = new ArrayList<CloudnRestfulApplicationError>();
    public static final CloudnRestfulApplicationError Signature_FailToMakeSignature = new CloudnRestfulApplicationError("Cloudn.Signature.FailToMakeSignature");
    public static final CloudnRestfulApplicationError Params_FailToMakeParamString = new CloudnRestfulApplicationError("Cloudn.Params.FailToMakeParamString");
    public static final CloudnRestfulApplicationError Params_NotInitialiseMarshaller = new CloudnRestfulApplicationError("Cloudn.Params.NotInitialiseMarshaller");
    public static final CloudnRestfulApplicationError Params_NeedParamAnotation = new CloudnRestfulApplicationError("Cloudn.Params.NeedParamAnotation");
    public static final CloudnRestfulApplicationError Endpoint_Unset = new CloudnRestfulApplicationError("Cloudn.Endpoint.Unset");
    public static final CloudnRestfulApplicationError Request_ProcessingError = new CloudnRestfulApplicationError("Cloudn.Request.ProcessingError");
    private final String errorCode;

    public CloudnRestfulApplicationError(String errorCode) {
        this.errorCode = errorCode;
        errors.add(this);
    }

    public String getMessage(Object ... args) {
        MessageFormat messageFormat = new MessageFormat(this.getMessage());
        return messageFormat.format(args);
    }

    public ImmutableList<CloudnRestfulApplicationError> getErrors() {
        ImmutableList.Builder builder = ImmutableList.builder();
        return builder.addAll(errors).build();
    }

    public String errorCode() {
        return this.errorCode;
    }

    public boolean match(String errorCode) {
        return this.errorCode().equals(errorCode);
    }

    public boolean match(RestfulApplicationException e) {
        return this.errorCode().equals(e.getErrorCode());
    }

    public String getMessage() {
        try {
            return Messages.messages().getString(this.errorCode());
        }
        catch (MissingResourceException e) {
            return this.errorCode();
        }
    }

    public RestfulApplicationException restRequestException(int statusCode, String detailCode, String requestUrl, String reason, Exception e, Object ... args) {
        return new RestfulApplicationException(this.errorCode(), statusCode, detailCode, requestUrl, reason, e);
    }

    public RestfulApplicationException exceptionException(Exception e, Object ... args) {
        return new RestfulApplicationException(this.errorCode(), this.getMessage(args), e);
    }

    public RestfulApplicationException exceptionException(String message, Exception e) {
        return new RestfulApplicationException(this.errorCode(), e.getMessage(), e);
    }

    public RestfulApplicationException exception(Object ... args) {
        return new RestfulApplicationException(this.errorCode(), this.getMessage(args));
    }
}

