/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.rest.api;

import com.clustercontrol.cloud.cloudn.rest.api.CloudnRestfulApplicationError;
import com.clustercontrol.cloud.cloudn.rest.api.DirectParam;
import com.clustercontrol.cloud.cloudn.rest.api.MarshalParam;
import com.clustercontrol.cloud.cloudn.rest.api.ParamHolder;
import com.clustercontrol.cloud.cloudn.rest.api.RestfulApplicationException;
import com.clustercontrol.cloud.util.Tuple;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.annotation.Nullable;

public class ParamAnnotations {
    private ParamAnnotations() {
    }

    private static ParamHolder.Param createParam(DirectParam dp, Object v) {
        return ParamHolder.Param.build(dp.name(), v.toString());
    }

    private static Collection<ParamHolder.Param> createParam(MarshalParam mp, Object c) {
        MarshalParam.marshaller m;
        try {
            m = mp.value().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw CloudnRestfulApplicationError.Params_NotInitialiseMarshaller.exception(e);
        }
        return m.marshal(c);
    }

    public static Collection<ParamHolder.Param> makeRestParams(Method method, @Nullable Object[] args) {
        Preconditions.checkNotNull((Object)method);
        if (args == null || args.length == 0) {
            return Collections.emptyList();
        }
        Invokable invokable = Invokable.from((Method)method);
        ImmutableList metodParams = invokable.getParameters();
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (int i = 0; i < metodParams.size(); ++i) {
            tuples.add(Tuple.build((Object[])new Object[]{metodParams.get(i), args[i]}));
        }
        ArrayList<ParamHolder.Param> restParams = new ArrayList<ParamHolder.Param>();
        for (int i = 0; i < tuples.size(); ++i) {
            try {
                restParams.addAll(ParamAnnotations.makeRestParamsFromMethodParam((Parameter)((Tuple)tuples.get(i)).get(0, Parameter.class), ((Tuple)tuples.get(i)).get(1)));
                continue;
            }
            catch (RestfulApplicationException e) {
                if (!CloudnRestfulApplicationError.Params_NeedParamAnotation.match(e)) continue;
                throw CloudnRestfulApplicationError.Params_NeedParamAnotation.exception(method.getName(), i);
            }
        }
        return restParams;
    }

    public static Collection<ParamHolder.Param> makeRestParamsFromMethodParam(Parameter p, @Nullable Object v) {
        if (v == null) {
            return Collections.emptyList();
        }
        DirectParam dp = (DirectParam)p.getAnnotation(DirectParam.class);
        if (dp != null) {
            return Arrays.asList(ParamAnnotations.createParam(dp, v));
        }
        MarshalParam mp = (MarshalParam)p.getAnnotation(MarshalParam.class);
        if (mp != null) {
            return ParamAnnotations.createParam(mp, v);
        }
        mp = v.getClass().getAnnotation(MarshalParam.class);
        if (mp != null) {
            return ParamAnnotations.createParam(mp, v);
        }
        throw CloudnRestfulApplicationError.Params_NeedParamAnotation.exception(new Object[0]);
    }

    public static Collection<ParamHolder.Param> makeRestParamsFromField(Field f, @Nullable Object c) {
        Object v;
        if (c == null) {
            return Collections.emptyList();
        }
        try {
            v = f.get(c);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw CloudnRestfulApplicationError.Params_FailToMakeParamString.exception(e);
        }
        if (v == null) {
            return Collections.emptyList();
        }
        DirectParam dp = f.getAnnotation(DirectParam.class);
        if (dp != null) {
            return Arrays.asList(ParamAnnotations.createParam(dp, v));
        }
        MarshalParam mp = f.getAnnotation(MarshalParam.class);
        if (mp != null) {
            return ParamAnnotations.createParam(mp, v);
        }
        return Arrays.asList(ParamHolder.Param.build(f.getName(), v.toString()));
    }
}

