/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlTransient;

import com.clustercontrol.cloud.IResourceManagement.Storage;
import com.clustercontrol.cloud.dao.CloudStorageDao;

public class CloudStorage implements Serializable, ICloudResource {
	/**
	 * 
	 */
	private static final long serialVersionUID = 5047727801682788230L;

	private CloudStorageDao dao;
	private String state;
	private String facilityName;
	private Integer size;
	private String snapshotId;
	private String flavor;
	private StorageAttachment storageAttachment;
	
	private Storage storage;

	public CloudStorage() {
		super();
		this.dao = new CloudStorageDao();
	}

	public CloudStorage(CloudStorageDao tableData, String facilityName) {
		super();
		this.dao = new CloudStorageDao(tableData);
		this.facilityName = facilityName;
	}

	public CloudStorage(CloudStorageDao dao, Storage storage, String facilityName) {
		this(dao, facilityName);

		if (storage.getStorageAttachment() != null) {
			StorageAttachment sa = new StorageAttachment();
			sa.setInstanceId(storage.getStorageAttachment().getInstanceId());
			sa.setDevice(storage.getStorageAttachment().getDevice());
			sa.setState(storage.getStorageAttachment().getState().label());
			sa.setAttachTime(storage.getStorageAttachment().getAttachTime().getTime());
			this.setStorageAttachment(sa);
		}
		
		this.flavor = storage.getFlavor();
		this.facilityName = facilityName;
		this.snapshotId = storage.getSnapshotId();
		this.size = storage.getSize();
		this.state = storage.getState().label();
		this.storage = storage;
	}

	public String getStorageId() {
		return dao.getStorageId();
	}
	public void setStorageId(String storageId) {
		throw new UnsupportedOperationException();
	}

	public String getState() {
		return state;
	}
	public void setState(String status) {
		throw new UnsupportedOperationException();
	}

	public String getStorageName() {
		return dao.getStorageName();
	}
	public void setStorageName(String storageName) {
		throw new UnsupportedOperationException();
	}

	public String getFlavor() {
		return flavor;
	}
	public void setFlavor(String flavor) {
		throw new UnsupportedOperationException();
	}

	public String getFacilityId() {
		return dao.getFacilityId();
	}
	public void setFacilityId(String facilityId) {
		throw new UnsupportedOperationException();
	}

	public Integer getDeviceIndex(){
		return dao.getDeviceIndex();
	}
	public void setDeviceIndex(Integer deviceIndex){
		throw new UnsupportedOperationException();
	}
	
	public String getDeviceType(){
		return dao.getDeviceType();
	}
	public void setDeviceType(String deviceType){
		throw new UnsupportedOperationException();
	}

	public String getDeviceName(){
		return dao.getDeviceName();
	}
	public void setDeviceName(String deviceName){
		throw new UnsupportedOperationException();
	}
	
	public String getRegion() {
		return dao.getRegion();
	}
	public void setRegion(String region) {
		throw new UnsupportedOperationException();
	}

	public String getZone() {
		return dao.getZone();
	}
	public void setZone(String zone) {
		throw new UnsupportedOperationException();
	}

	public StorageRegistStateType getRegistState() {
		if (dao.getRegistStatus() == null) {
			return null;
		}
		return StorageRegistStateType.valueOf(dao.getRegistStatus().name());
	}
	public void setRegistState(StorageRegistStateType registState) {
		throw new UnsupportedOperationException();
	}
	
	public Long getRegDate() {
		return dao.getRegDate() != null ? dao.getRegDate().getTime(): null;
	}
	public void setRegDate(Long regDate) {
		throw new UnsupportedOperationException();
	}

	public Long getUpdateDate() {
		return dao.getUpdateDate() != null ? dao.getUpdateDate().getTime(): null;
	}
	public void setUpdateDate(Long updateDate) {
		throw new UnsupportedOperationException();
	}

	public String getRegUser() {
		return dao.getRegUser();
	}
	public void setRegUser(String regUser) {
		throw new UnsupportedOperationException();
	}

	public String getUpdateUser() {
		return dao.getUpdateUser();
	}
	public void setUpdateUser(String updateUser) {
		throw new UnsupportedOperationException();
	}

	public String getFacilityName() {
		return facilityName;
	}
	public void setFacilityName(String facilityName) {
		throw new UnsupportedOperationException();
	}

	public Integer getSize() {
		return size;
	}
	public void setSize(Integer size) {
		throw new UnsupportedOperationException();
	}

	public String getSnapshotId() {
		return snapshotId;
	}
	public void setSnapshotId(String snapshotId) {
		throw new UnsupportedOperationException();
	}
	
	public StorageAttachment getStorageAttachment() {
		return storageAttachment;
	}
	public void setStorageAttachment(StorageAttachment storageAttachment) {
		this.storageAttachment = storageAttachment;
	}

	@XmlTransient
	public Storage getResource() {
		return storage;
	}
}
