/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="cc_cloud_billing_detail_relation")
public class BillingDetailRelationDao /* implements IDHolder */ {
	public static enum RelationType {
		node,
		additional
	}
	
	private Long relationId;
	private BillingDetailDao billingDetail;
    private String facilityId;
    private String facilityName;
    private RelationType relationType;
    
    public BillingDetailRelationDao() {
    }
	
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name="relation_id")
	public Long getRelationId() {
		return relationId;
	}
	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	@ManyToOne(optional=false)
	@JoinColumn(name = "billing_detail_id")
	public BillingDetailDao getBillingDetail() {
		return billingDetail;
	}
	public void setBillingDetail(BillingDetailDao billingDetail) {
		this.billingDetail = billingDetail;
	}

	@Column(name="facility_id")
	public String getFacilityId() {
		return facilityId;
	}
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}

	@Column(name="facility_name")
	public String getFacilityName() {
		return facilityName;
	}
	public void setFacilityName(String facilityName) {
		this.facilityName = facilityName;
	}

//	@Override
//	public Object getId() {
//		return getRelationId();
//	}

	@Column(name="relation_type")
	@Enumerated(EnumType.STRING)
	public RelationType getRelationType() {
		return relationType;
	}
	public void setRelationType(RelationType relationType) {
		this.relationType = relationType;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((billingDetail == null) ? 0 : billingDetail.hashCode());
		result = prime * result
				+ ((facilityId == null) ? 0 : facilityId.hashCode());
		result = prime * result
				+ ((facilityName == null) ? 0 : facilityName.hashCode());
		result = prime * result
				+ ((relationId == null) ? 0 : relationId.hashCode());
		result = prime * result
				+ ((relationType == null) ? 0 : relationType.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		BillingDetailRelationDao other = (BillingDetailRelationDao) obj;
		if (billingDetail == null) {
			if (other.billingDetail != null)
				return false;
		} else if (!billingDetail.equals(other.billingDetail))
			return false;
		if (facilityId == null) {
			if (other.facilityId != null)
				return false;
		} else if (!facilityId.equals(other.facilityId))
			return false;
		if (facilityName == null) {
			if (other.facilityName != null)
				return false;
		} else if (!facilityName.equals(other.facilityName))
			return false;
		if (relationId == null) {
			if (other.relationId != null)
				return false;
		} else if (!relationId.equals(other.relationId))
			return false;
		if (relationType != other.relationType)
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "BillingDetailRelationDao [relationId=" + relationId
				+ ", billingDetail=" + billingDetail + ", facilityId="
				+ facilityId + ", facilityName=" + facilityName
				+ ", relationType=" + relationType + "]";
	}
}
