/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.factory;

import java.util.List;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.CreateCloudUserRequest;
import com.clustercontrol.cloud.bean.ModifyCloudUserRequest;
import com.clustercontrol.fault.InvalidRole;

public interface ICloudUserOperator {
	CloudUser createCloudAccount(CreateCloudUserRequest request) throws CloudManagerFault;
	CloudUser createCloudUser(CreateCloudUserRequest request) throws CloudManagerFault;
	CloudUser modifyCloudUser(ModifyCloudUserRequest request) throws CloudManagerFault;
	void removeCloudUser(String cloudUserId) throws CloudManagerFault, InvalidRole;

	CloudUser findCloudUser(String cloudUserId) throws CloudManagerFault;
	CloudUser findCloudUserByRoleId(String roleId) throws CloudManagerFault;
	CloudUser findCloudUserByUserIdAndRoleId(String hinemosUserId, String roleId) throws CloudManagerFault;

	List<CloudUser> findAllCloudUser() throws CloudManagerFault;
	List<CloudUser> findCloudUserByAccountResource(String accountResourceId) throws CloudManagerFault;
	List<CloudUser> findCloudUserByAccountResourceAndUserId(String accountResourceId, String hinemosUserId) throws CloudManagerFault;
}