/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.factory;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.IAccessDestination;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.bean.CloudAccountResource;
import com.clustercontrol.cloud.bean.CloudRegion;
import com.clustercontrol.cloud.bean.CloudService;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.persistence.Transactional;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.CloudCredential;
import com.clustercontrol.cloud.util.ResourceRegion;

public abstract class ResourceOperatorBase implements IResourceOperatorBase {
	private IAccessDestination accessDestination;
	private CloudRegion cloudRegion;
	private IResourceManagement resourceManagement;

	private Logger logger;
	
	@Override
	@Transactional(Transactional.TransactionType.Supported)
	public void setAccessDestination(IAccessDestination accessDestination) throws CloudManagerFault {
		this.accessDestination = accessDestination;
	}
	
	protected CloudUser getCloudUser()  {
		return accessDestination.getCloudUser();
	}

	protected CloudService getCloudService() {
		return accessDestination.getCloudService();
	}
	
	protected CloudAccountResource getAccountResource()  {
		return accessDestination.getCloudAccountResource();
	}

	protected CloudRegion getCloudRegion() {
		return cloudRegion;
	}

	protected IResourceManagement getResourceManagement() throws CloudManagerFault {
		if (resourceManagement == null) {
			resourceManagement = ObjectRegistryService.registry().get(IResourceManagement.class, getCloudService().getCloudTypeId());
			if (resourceManagement == null) {
				throw new InternalManagerError();
			}

			resourceManagement.setAccessDestination(new CloudCredential(getCloudUser()), new ResourceRegion(getCloudRegion()));
			resourceManagement.setStore(new ResourceStore(getAccountResource().getAccountResourceId(), getAccountResource().getCloudServiceId(), getCloudRegion().getRegion()));
		}
		return resourceManagement;
	}
	
	protected <T extends IResourceOperatorBase> T getResourceOperator(Class<T> clazz) throws CloudManagerFault {
		T operator = ObjectRegistryService.registry().get(clazz);
		operator.setAccessDestination(accessDestination);
		operator.setCloudRegion(cloudRegion);
		return operator;
	}

	protected Logger getLogger() {
		if (logger == null) {
			logger = Logger.getLogger(this.getClass());
		}
		return logger;
	}

	@Override
	public void setCloudRegion(CloudRegion cloudRegion) throws CloudManagerFault {
		this.cloudRegion = cloudRegion;
	}
}
