/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.util.proxy;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ProxyStore implements IProxyStore {
	private static class ProxyEntry implements IProxyEntry {
		private int id;
		private Proxy proxy;
		private List<String> destination;
		
		public ProxyEntry(int id, Proxy proxy, List<String> destination) {
			super();
			this.id = id;
			this.proxy = proxy;
			this.destination = destination;
		}

		@Override
		public int getId() {
			return id;
		}

		@Override
		public Proxy getProxy() {
			return proxy;
		}

		@Override
		public List<String> getDestination() {
			return destination;
		}
	}
	
	private final Map<Integer, ProxyEntry> proxiesMap = Collections.synchronizedMap(new HashMap<Integer, ProxyEntry>());
	private final Map<String, Proxy> destinationsMap = Collections.synchronizedMap(new HashMap<String, Proxy>());
	private final AtomicInteger idGen = new AtomicInteger();
	
	public ProxyStore() {
	}
	@Override
	public int add(String proxyHost, int port, String user, String password, String...host) {
		ProxyEntry entry = new ProxyEntry(
				idGen.incrementAndGet(),
				new Proxy(proxyHost, port, user, password),
				Arrays.asList(host)
				);
		proxiesMap.put(entry.getId(), entry);
		refresh();
		return entry.getId();
	}
	
	private void refresh() {
		synchronized (destinationsMap) {
			destinationsMap.clear();
			if (!proxiesMap.isEmpty()) {
				for (ProxyEntry value: proxiesMap.values()) {
					for (String d: value.getDestination()) {
						destinationsMap.put(d, value.getProxy());
					}
				}
			}
		}
	}
	@Override
	public void remove(int id) {
		proxiesMap.remove(id);
		refresh();
	}
	@Override
	public IProxyEntry getEntry(int id) {
		return proxiesMap.get(id);
	}
	@Override
	public Proxy getProxy(String destination) {
		return destinationsMap.get(destination);
	}
}