/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

import com.clustercontrol.cloud.cloudn.rest.api.MarshalParam;
import com.google.common.base.Preconditions;

@NonNullByDefault(false)
@MarshalParam
public class ListDiskOfferingsRequest extends RestApplicationRequest {
	// Disk OfferingのIdを指定する No
	public String id;
	// 任意キーワードによる検索条件の付与 No
	public String keyword;
	// pagesizeと同時に指定して、ページ番号を指定する No
	public Integer page; 
	// 一度のリクエストに含めるレスポンス(非同期ジョブ)の個数を指定する。pageと同時にしていする.(default:500)No 
	public Integer pagesize;
	// Disk offering名
	public String name;
	
	public ListDiskOfferingsRequest withId(@NonNull String id) {
		Preconditions.checkNotNull(id);
		this.id = id;
		return this;
	}
	public ListDiskOfferingsRequest withPage(int page) {
		this.page = page;
		return this;
	}
	public ListDiskOfferingsRequest withPageSize(int pagesize) {
		this.pagesize = pagesize;
		return this;
	}
	public ListDiskOfferingsRequest withName(@NonNull String name) {
		Preconditions.checkNotNull(name);
		this.name = name;
		return this;
	}
}
