/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.ws.cloudn;

import javax.xml.bind.annotation.XmlSeeAlso;

@XmlSeeAlso({
	PasswordResult.class,
	AttachStorageResult.class,
	DeleteInstanceResult.class,
})
public abstract class JobResult {
	protected JobStatus status;
	protected String errorCode;
	protected String errorText;
	
	public String getErrorCode() {
		return errorCode;
	}
	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}
	public String getErrorText() {
		return errorText;
	}
	public void setErrorText(String errorText) {
		this.errorText = errorText;
	}
	public JobStatus getStatus(){
		return status;
	}
	public void setStatus(JobStatus status){
		this.status = status;
	}
	public void setStatusByCode(int code){
		this.status = JobStatus.getStatusFromCode(code);
	}
	
	public static enum JobStatus{
		success(1),
		failure(2),
		running(0),
		error(-1);
		
		private int code;
		JobStatus(int code){
			this.code = code;
		}
		
		public int getCode(){
			return code;
		}
		
		public static JobStatus getStatusFromCode(int code){
			switch (code){
			case 0:
				return running;
			case 1:
				return success;
			case 2:
				return failure;
			default:
				return error;
			}
		}
	}
}
