/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.registry;

import com.clustercontrol.cloud.PluginFault;

public abstract class AbstractObjectChangedListener<T> implements IObjectChangedListener<T> {

	@Override
	public void postAdded(String eventName, T object) throws PluginFault {
	}

	@Override
	public void preRemoved(String eventName, T object) throws PluginFault {
	}

	@Override
	public void postModified(String eventName, T object) throws PluginFault {
	}

	@Override
	public void postRemoved(String eventName, T object) throws PluginFault {
	}

	@Override
	public void onInstall() {
	}

	@Override
	public void onUninstall() {
	}

	@Override
	public void preAdded(String type, T object) throws PluginFault {
	}

	@Override
	public void preModified(String type, T object) throws PluginFault {
	}
}
