/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.xcloud.azure.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.AccessKeyCredential;
import com.clustercontrol.ws.xcloud.Account;
import com.clustercontrol.ws.xcloud.AddPublicCloudScopeRequest;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.xcloud.azure.Activator;
import com.clustercontrol.xcloud.azure.ui.dialogs.CreateCloudScopeDialog;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.model.cloud.IHinemosManager;

public class CreateCloudScopeHandler extends AbstractHandler implements CloudStringConstants {
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		CreateCloudScopeDialog dialog = new CreateCloudScopeDialog(HandlerUtil.getActiveShell(event), false);
		loop_end:
		while(true){
			try {
				if (dialog.open() != Window.OK)
					break loop_end;
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
				break;
			}
			
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgConfirmCreateCloudScope)) {
				
				try {
					CreateCloudScopeDialog.DialogData output = dialog.getDialogData();
					
					final IHinemosManager manager = com.clustercontrol.xcloud.Activator.getDefault().getHinemosManager(output.getManagerName());
					
					AddPublicCloudScopeRequest request = new AddPublicCloudScopeRequest();
					request.setPlatformId(Activator.CLOUD_PLATFORM_ID);
					request.setCloudScopeId(output.getCloudScopeId());
					request.setScopeName(output.getCloudScopeName());
					request.setOwnerRoleId(output.getOwnerRoleId());
					request.setDescription(output.getDescription());
					Account account = new Account();
					AccessKeyCredential credential = new AccessKeyCredential();
					credential.setAccessKey(output.getAccessKey());
					credential.setSecretKey(output.getSecretKey());
					account.setCredential(credential);
					account.setDescription(output.getDescription());
					account.setLoginUserId(output.getAccountId());
					account.setUserName(output.getDisplayName());
					request.setAccount(account);
					
					manager.getEndpoint(CloudEndpoint.class).addCloudScope(request);
					
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						MessageFormat.format(msgFinishCreateCloudScope, output.getCloudScopeId()));
					
					Display.getCurrent().asyncExec(new Runnable() {
						@Override
						public void run() {
							manager.update();
						}
					});

					break loop_end;
				} catch (Exception e) {
					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e.getMessage(), e);

					String message = e.getMessage();
					if (message == null) {
						ByteArrayOutputStream bos = new ByteArrayOutputStream();
						PrintStream ps = new PrintStream(bos, true);
						e.printStackTrace(ps);
						
						message = bos.toString();
					}
					
					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), message);
				}
			}
		}
		return null;
	}
}