/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.azure.ui.dialogs;

import java.security.KeyPair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.clustercontrol.ws.xcloud.AzureOptionEndpoint;
//import com.clustercontrol.ws.xcloud.AvailabilityZone;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.ws.xcloud.CloudManagerException;
//import com.clustercontrol.ws.xcloud.Filter;
//import com.clustercontrol.ws.xcloud.Image;
import com.clustercontrol.ws.xcloud.Instance;
import com.clustercontrol.ws.xcloud.InvalidRole_Exception;
import com.clustercontrol.ws.xcloud.InvalidUserPass_Exception;
//import com.clustercontrol.ws.xcloud.KeyPair;
//import com.clustercontrol.ws.xcloud.NetworkInterface;
//import com.clustercontrol.ws.xcloud.SecurityGroup;
//import com.clustercontrol.ws.xcloud.Snapshot;
//import com.clustercontrol.ws.xcloud.Vpc;
import com.clustercontrol.xcloud.model.CloudModelException;
import com.clustercontrol.xcloud.model.cloud.ILocation;
import com.clustercontrol.xcloud.util.HinemosUtil;

public class AzureResourceProvider {
	protected ILocation location;
	protected CloudEndpoint endpoint;
	protected AzureOptionEndpoint azureEndpoint;
	
	protected List<String> instanceTypes;
	protected List<String> shutdownBehaviorTypes;
	protected List<String> volumeTypes;
	protected List<KeyPair> keyNames;
	protected List<Instance> instances;
	
	public AzureResourceProvider(ILocation location) {
		this.location = location;
	}
	
	public List<String> getInstanceTypes() {
		return instanceTypes;
	}
	public List<String> getVolumeType() {
		return volumeTypes;
	}
	public List<KeyPair> getKeyNames() {
		return keyNames;
	}

	public List<String> getInstanceInitiatedShutdownBehaviorTypes() {
		return shutdownBehaviorTypes;
	}

	public List<Instance> getInstances() {
		if (instances == null) {
			try {
				instances = getCloudEndpoint().getInstances(
						location.getCloudScope().getId(), location.getId(),
						HinemosUtil.emptyList(String.class));
			} catch (CloudManagerException | InvalidRole_Exception | InvalidUserPass_Exception e) {
				throw new CloudModelException(e);
			}
		}
		return instances;
	}
	protected CloudEndpoint getCloudEndpoint() {
		if (endpoint == null) {
			endpoint = location.getCounterScope().getCloudScopeScope().getHinemosManager().getEndpoint(CloudEndpoint.class);
		}
		return endpoint;
	}
	
	protected AzureOptionEndpoint getAzureOptionEndpoint() {
		if (azureEndpoint == null) {
			azureEndpoint = location.getCounterScope().getCloudScopeScope().getHinemosManager().getEndpoint(AzureOptionEndpoint.class);
		}
		return azureEndpoint;
	}
}