package com.clustercontrol.xcloud.aws.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.ws.xcloud.CloudManagerException;
import com.clustercontrol.ws.xcloud.InvalidRole_Exception;
import com.clustercontrol.ws.xcloud.InvalidUserPass_Exception;
import com.clustercontrol.xcloud.aws.ui.dialogs.job.AttachStorageJobWizard;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.CloudModelException;
import com.clustercontrol.xcloud.model.cloud.IStorage;

public class AttachStorageJobHandler implements ICloudOptionHandler, CloudStringConstants {

	protected String getMethodName() {
		return "makeAttachStorageCommand";
	}
	
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		try {
			IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
			final IStorage storage = (IStorage)selection.getFirstElement();

			CloudEndpoint endpoint = storage.getHinemosManager().getEndpoint(CloudEndpoint.class);
			
			try {
				endpoint.checkCallable(storage.getCloudScopeId(), getMethodName());
			} catch(CloudManagerException e) {
				if ("COMMUNITY_EDITION_FUNC_NOT_AVAILABLE".equals(e.getFaultInfo().getErrorCode())) {
					throw new CloudModelException(msgFucNotAvailable);
				}
				throw new CloudModelException(e);
			} catch(InvalidRole_Exception | InvalidUserPass_Exception e) {
				throw new CloudModelException(e);
			}
			
			Font bannerFont = JFaceResources.getBannerFont();
			Font dialogFont = JFaceResources.getDialogFont();
			FontData[] fontDatas = dialogFont.getFontData();
			for (FontData fontData: fontDatas) {
				fontData.setHeight(fontData.getHeight() + 2);
				fontData.setStyle(SWT.BOLD);
			}
			JFaceResources.getFontRegistry().put(JFaceResources.BANNER_FONT, fontDatas);
			
			try {
				AttachStorageJobWizard wizard = new AttachStorageJobWizard(endpoint, storage);
				WizardDialog wizardDialog = new WizardDialog(HandlerUtil.getActiveShell(event), wizard);
				wizardDialog.open();
			} finally {
				Font changed = JFaceResources.getBannerFont();
				JFaceResources.getFontRegistry().put(JFaceResources.BANNER_FONT, bannerFont.getFontData());
				changed.dispose();
			}
		} catch (Exception e) {
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e.getMessage(), e);

			String message = e.getMessage();
			if (message == null) {
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				PrintStream ps = new PrintStream(bos, true);
				e.printStackTrace(ps);
				
				message = bos.toString();
			}
			
			// 失敗報告ダイアログを生成
			MessageDialog.openError(null, Messages.getString("failed"), message);
		}
		return null;
	}
}