<?php
//  ------------------------------------------------------------------------ //
//                   This module; Copyright (c) 2005 gusagi                  //
//                        <http://good-tea.ddo.jp/dev>                       //
//  ------------------------------------------------------------------------ //

//*****************************************************************************/ 
// ľܸƤӽФ줿exit
//*****************************************************************************/ 
if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit ;

if( ! class_exists( 'CssadminModules' ) ) {

class CssadminModules {

	var $modules = array();
	var $del_modules = array();

	/**
	 * CssadminModules
	 * 
	 * @param void
	 * @return void
	 */
	function CssadminModules() {
	}

	/**
	 * getModules
	 * 
	 * @param void
	 * @return void
	 */
	function getModules() {
		return $this->modules;
	}

	/**
	 * getModuleList
	 * 
	 * @param void
	 * @return void
	 */
	function setModuleList() {
		// 
		$this->modules[0] = array(
			'mid' => 0 ,
			'name' => _AM_CSSADMIN_CUSTOM ,
			'dirname' => '', 
			'ucfirstname' => '', 
			'css' => '', 
			'current' => '', 
			'selected' => ''
		) ;
		// ⥸塼μ
		$module_handler =& xoops_gethandler('module');
		$criteria = new CriteriaCompo(new Criteria('isactive', 1));
		$criteria->add(new Criteria('mid', '1', '>'));
		$modulelist =& $module_handler->getObjects($criteria, true);
		array_unshift( $modulelist , $module_handler->get(1) ) ;
		foreach( $modulelist as $module ) {
			$this->modules[$module->getVar('mid')] = array(
				'mid' => $module->getVar('mid') ,
				'name' => $module->getVar('name') ,
				'dirname' => $module->getVar('dirname'), 
				'ucfirstname' => ucfirst($module->getVar('dirname')), 
				'css' => '', 
				'current' => '', 
				'selected' => ''
			) ;
		}
	}

	/**
	 * setModuleDirCss
	 * 
	 * @param void
	 * @return void
	 */
	function setModuleDirCss() {
		$modulelist = $this->modules;
		foreach( $modulelist as $key => $module ) {
			$css_path = XOOPS_ROOT_PATH .'/modules/' .$module['dirname'] .'/css/';
			if ( file_exists($css_path) && is_dir($css_path) ) {
				$handle = opendir( $css_path );
				while (false !== ($file = readdir($handle))) {
					if ( is_file($css_path .$file) && !preg_match("/^\..*$/",$file) ) {
						$this->modules[$key]['css'][] = basename( $file );
						if ( !empty($this->modules[$key]['current']) && 
							$this->modules[$key]['current'] === basename( $file ) ) {
							$this->modules[$key]['selected'] = basename( $file );
						}
					}
				}
				closedir($handle);
			}
		}
	}

	/**
	 * setModuleDbCss
	 * 
	 * @param void
	 * @return void
	 */
	function setModuleDbCss() {
		$xoopsDB =& Database::getInstance();
		$cssadmin_modules = $xoopsDB->prefix( 'cssadmin_modules' );
		$modules = $xoopsDB->prefix( 'modules' );
		$sql = "SELECT cssadmin_modules.mid, modules.dirname, cssadmin_modules.css FROM $cssadmin_modules cssadmin_modules";
		$sql .= " LEFT JOIN $modules modules ON modules.mid = cssadmin_modules.mid";
		$result = $xoopsDB->query( $sql );
		// SQL̤ѿ˳Ǽ
		if ( $myrow = $xoopsDB->fetchArray($result) ) {
			do {
				$mid = intval( $myrow['mid'] );
				$this->modules[$mid]['mid'] = intval( $myrow['mid'] );
				$this->modules[$mid]['current'] = htmlSpecialChars( $myrow['css'], ENT_QUOTES );
			} while ( $myrow = $xoopsDB->fetchArray($result) );
		}
	}


	function getModuleCssHeader( $module_dirname ) {
		// 
		$xoopsDB =& Database::getInstance();
		$cssadmin_modules = $xoopsDB->prefix( 'cssadmin_modules' );
		$cssadmin_module_css = '';
		$sql = '';
		$css = '';
		// ⥸塼μ
		$module_handler =& xoops_gethandler( 'module' );
		$module = & $module_handler->getByDirname( $module_dirname );
		$mid = $module->getVar( 'mid' ) ;
		// ⥸塼CSSμ
		$sql = "SELECT css FROM $cssadmin_modules";
		$sql .= " WHERE mid = $mid";
		$result = $xoopsDB->query( $sql );
		if ( $myrow = $xoopsDB->fetchArray($result) ) {
			$css = urlencode( htmlspecialchars($myrow['css'], ENT_QUOTES) );
		}
		return $css;
	}

	/**
	 * setDelModules
	 * 
	 * @param void
	 * @return void
	 */
	function setDelModules() {
		// 
		$xoopsDB =& Database::getInstance();
		$cssadmin_modules = $xoopsDB->prefix( 'cssadmin_modules' );
		$modules = $xoopsDB->prefix( 'modules' );
		$mid_list = array();
		$mids = '';
		// ¸ߤƤ֥åID
		$sql = "SELECT mid FROM $modules";
		$result = $xoopsDB->query( $sql );
		if ( $myrow = $xoopsDB->fetchArray($result) ) {
			do {
				$mid_list[] = intval($myrow['mid']);
			} while ( $myrow = $xoopsDB->fetchArray($result) );
		}
		// ֥åCSSˡ¸ߤƤʤ֥åξ󤬴ޤޤƤʤǧ
		if ( ! empty($mid_list) ) {
			$mids = implode( ',', $mid_list );
			$sql = "SELECT mid FROM $cssadmin_modules";
			$sql .= " WHERE mid NOT IN ( $mids )";
			$result = $xoopsDB->query( $sql );
			if ( $myrow = $xoopsDB->fetchArray($result) ) {
				do {
					$mid = intval($myrow['mid']);
					$this->del_modules[$mid] = $mid;
				} while ( $myrow = $xoopsDB->fetchArray($result) );
			}
		}

	}

	/**
	 * getDelModules
	 * 
	 * @param void
	 * @return void
	 */
	function getDelModules() {
		return $this->del_modules;
	}

// end of class
}

$CssadminModules = new CssadminModules();

}

?>