<?php
// vim: foldmethod=marker
/**
 *	Ethna_DB_XOOPS.php
 *
 *	@author		ITOH Takashi <itoh@itt-web.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_DB_XOOPS.php,v 1.2 2005/04/07 12:55:46 fujimoto Exp $
 */

// {{{ Ethna_DB_XOOPS
/**
 *	Ethna_DB饹μ(XOOPS)
 *
 *	@author		ITOH Takashi <itoh@itt-web.net>
 *	@access		public
 *	@package	Ethna
 */


class Ethna_DB_XOOPS extends Ethna_DB
{
	/**#@+
	 *	@access	private
	 */

	/**	@var	object	DB	XOOPS DB֥ */
	var $db;

	/**	@var	array	ȥ󥶥å */
	var	$transaction = array();


	/**	@var	object	Ethna_Logger	֥ */
	var $logger;

	/**	@var	object	Ethna_AppSQL	SQL֥ */
	var $sql;

	/**	@var	string	DB(mysql, pgsql...) */
	var $type;

	/**	@var	string	DSN */
	var $dsn;

	/**	@var	bool	³³ե饰 */
	var $persistent;

	/**#@-*/


	// {{{ Ethna_DB饹μ
	/**
	 *	Ethna_DB_PEAR饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Controller	&$controller	ȥ饪֥
	 *	@param	string	$dsn								DSN
	 *	@param	bool	$persistent							³³
	 */
	function Ethna_DB_XOOPS(&$controller, $dsn=null, $persistent=false)
	{
		$this->dsn = $dsn;
//		$this->persistent = $persistent;
		$this->db = null;
		$this->logger =& $controller->getLogger();
		$this->sql =& $controller->getSQL();
//		$dsninfo = DB::parseDSN($dsn);
		$this->type =  'mysql'; //$dsninfo['phptype']; // MySQLXOOPS̤б
	}

	/**
	 *	DB³(ｪλ)
	 *
	 *	@access	public
	 *	@return	mixed	0:ｪλ Ethna_Error:顼
	 */
	function connect()
	{
	    global $xoopsDB ;
	        $this->db =& $xoopsDB;
	        return 0 ;
/*
	        $this->db =& DB::connect($this->dsn, $this->persistent);
		if (DB::isError($this->db)) {
			$error = Ethna::raiseError('DB³顼: %s', E_DB_CONNECT, $this->db->getUserInfo());
			$error->addUserInfo($this->db);
			$this->db = null;
			return $error;
		}
		return 0;
*/
	}

	/**
	 *	DB³Ǥ
	 *
	 *	@access	public
	 */
	function disconnect()
	{
		if (is_null($this->db)) {
			return;
		}
		$this->db->close();
	}

	/**
	 *	DB³֤֤
	 *
	 *	@access	public
	 *	@return	bool	true: false:顼
	 */
	function isValid()
	{
		if (is_null($this->db)) {
			return false;
		} else {
			return true;
		}
	}

	/**
	 *	DBȥ󥶥򳫻Ϥ
	 *
	 *	@access	public
	 *	@return	mixed	0:ｪλ Ethna_Error:顼
	 */
	function begin()
	{
		if (count($this->transaction) > 0) {
			$this->transaction[] = true;
			return 0;
		}

		$r = $this->query('BEGIN;');
		if (Ethna::isError($r)) {
			return $r;
		}
		$this->transaction[] = true;

		return 0;
	}

	/**
	 *	DBȥ󥶥Ǥ
	 *
	 *	@access	public
	 *	@return	mixed	0:ｪλ Ethna_Error:顼
	 */
	function rollback()
	{
		if (count($this->transaction) == 0) {
			return 0;
		}

		// Хåϥå˴ؤ餺ȥ󥶥򥯥ꥢ
		$r = $this->query('ROLLBACK;');
		if (Ethna::isError($r)) {
			return $r;
		}
		$this->transaction = array();

		return 0;
	}

	/**
	 *	DBȥ󥶥λ
	 *
	 *	@access	public
	 *	@return	mixed	0:ｪλ Ethna_Error:顼
	 */
	function commit()
	{
		if (count($this->transaction) == 0) {
			return 0;
		} else if (count($this->transaction) > 1) {
			array_pop($this->transaction);
			return 0;
		}

		$r = $this->query('COMMIT;');
		if (Ethna::isError($r)) {
			return $r;
		}
		array_pop($this->transaction);

		return 0;
	}
	// }}}

	// {{{ Ethna_AppObjectϢȤΤμ
	/**
	 *	DBפ֤
	 *
	 *	@access	public
	 *	@return	string	DB
	 */
	function getType()
	{
		return $this->type;
	}

	/**
	 *	ȯԤ(2)
	 *
	 *	@access	public
	 *	@param	string	$query	SQLʸ
	 *	@return	mixed	DB_Result:̥֥ Ethna_Error:顼
	 */
	function &query($query)
	{
	        return $this->_query($query);
	}

	function &queryF($query)
	{
	        return $this->_query($query, true);
	}

	/**
	 *	ľINSERTˤID
	 *
	 *	³DBmysqlʤmysql_insert_id()֤ͤ
	 *
	 *	@access	public
	 *	@return	mixed	int:ľINSERTˤ줿ID null:̤ݡ
	 */
	function getInsertId()
	{
		if ($this->isValid() == false) {
			return null;
		} else if ($this->type == 'mysql') {
			return mysql_insert_id($this->db->conn);
		}

		return null;
	}

	/**
	 *	ľΥˤ빹Կ
	 *
	 *	@access	public
	 *	@return	int		Կ
	 */
	function affectedRows()
	{
		return $this->db->getAffectedRows();
	}
	// }}}

	// {{{ Ethna_DB_PEAR
	/**
	 *	SQLʸꥯȯԤ
	 *
	 *	@access	public
	 *	@param	string	$sqlid		SQL-ID(+)
	 *	@return	mixed	DB_Result:̥֥ Ethna_Error:顼
	 */
	function &sqlquery($sqlid)
	{
		$args = func_get_args();
		array_shift($args);
		$query = $this->sql->get($sqlid, $args);

		return $this->_query($query);
	}

	/**
	 *	SQLʸ
	 *	
	 *	@access	public
	 *	@param	string	$sqlid		SQL-ID
	 *	@return	string	SQLʸ
	 */
	function sql($sqlid)
	{
		$args = func_get_args();
		array_shift($args);
		$query = $this->sql->get($sqlid, $args);

		return $query;
	}

	/**
	 *	ơ֥å
	 *
	 *	@access	public
	 *	@param	mixed	åоݥơ֥̾
	 *	@return	mixed	DB_Result:̥֥ Ethna_Error:顼
	 */
	function lock($tables)
	{
		$this->message = null;

		$sql = "";
		foreach (to_array($tables) as $table) {
			if ($sql != "") {
				$sql .= ", ";
			}
			$sql .= "$table WRITE";
		}

		return $this->query("LOCK TABLES $sql");
	}

	/**
	 *	ơ֥Υå
	 *
	 *	@access	public
	 *	@return	mixed	DB_Result:̥֥ Ethna_Error:顼
	 */
	function unlock()
	{
		$this->message = null;
		return $this->query("UNLOCK TABLES");
	}

	/**
	 *	ȯԤ
	 *
	 *	@access	private
	 *	@param	string	$query	SQLʸ
	 *  @param  boolean true:queryFȤ
	 *	@return	mixed	DB_Result:̥֥ Ethna_Error:顼
	 */
	function &_query($query, $queryF=false)
	{
		$this->logger->log(LOG_DEBUG, "$query");
		if($queryF){
			$re =& $this->db->queryF($query);
		}else{
			$re =& $this->db->query($query);
		}
		// $remysql Result Resource
		$r =& new XOOPS_DB_Result($re);
/*
	        if (DB::isError($r)) {
			if ($r->getCode() == DB_ERROR_ALREADY_EXISTS) {
				$error = Ethna::raiseNotice('ˡ󥨥顼 SQL[%s]', E_DB_DUPENT, $query, $this->db->errorNative(), $r->getUserInfo());
			} else {
				$error = Ethna::raiseError('ꥨ顼 SQL[%s] CODE[%d] MESSAGE[%s]', E_DB_QUERY, $query, $this->db->errorNative(), $r->getUserInfo());
			}
			return $error;
		}
*/
		return $r ;
	}
	// }}}
}
// }}}


// PEAR::DB_ResultƱΥ᥽åɤĥåѡ
class XOOPS_DB_Result
{
    // {{{ properties

    var $dbh;
    var $result;
    var $row_counter = null;

    /**
     * for limit queries, the row to start fetching
     * @var integer
     */
    var $limit_from  = null;

    /**
     * for limit queries, the number of rows to fetch
     * @var integer
     */
    var $limit_count = null;

    // }}}
    // {{{ constructor

    /**
     * DB_result constructor.
     * @param resource $result  result resource id
     * @param array    $options assoc array with optional result options
     */
    function XOOPS_DB_Result( $result, $options = array())
    {
		global $xoopsDB ;
		
		$this->dbh =& $xoopsDB ;
        $this->result = $result;
        foreach ($options as $key => $value) {
            $this->setOption($key, $value);
        }
/*
        $this->limit_type  = $dbh->features['limit'];
        $this->autofree    = $dbh->options['autofree'];
        $this->fetchmode   = $dbh->fetchmode;
        $this->fetchmode_object_class = $dbh->fetchmode_object_class;
*/
    }

    function setOption($key, $value = null)
    {
        switch ($key) {
            case 'limit_from':
                $this->limit_from = $value; break;
            case 'limit_count':
                $this->limit_count = $value; break;
        }
    }

    // }}}
    // {{{ fetchRow()

    /**
     * Fetch a row of data and return it by reference into an array.
     *
     * The type of array returned can be controlled either by setting this
     * method's <var>$fetchmode</var> parameter or by changing the default
     * fetch mode setFetchMode() before calling this method.
     *
     * There are two options for standardizing the information returned
     * from databases, ensuring their values are consistent when changing
     * DBMS's.  These portability options can be turned on when creating a
     * new DB object or by using setOption().
     *
     *   + <samp>DB_PORTABILITY_LOWERCASE</samp>
     *     convert names of fields to lower case
     *
     *   + <samp>DB_PORTABILITY_RTRIM</samp>
     *     right trim the data
     *
     * @param int $fetchmode  how the resulting array should be indexed
     * @param int $rownum     the row number to fetch
     *
     * @return array  a row of data, null on no more rows or PEAR_Error
     *                object on error
     *
     * @see DB_common::setOption(), DB_common::setFetchMode()
     * @access public
     */
    function &fetchRow($fetchmode = DB_FETCHMODE_DEFAULT, $rownum=null)
    {
		switch($fetchmode){
			case DB_FETCHMODE_ORDERED :
				$method = 'fetchRow' ;
				break ;
			case DB_FETCHMODE_ASSOC :
			case DB_FETCHMODE_DEFAULT :
			default :
				$method = 'fetchArray' ;
				break ;
		}
		$fetchdata =& $this->dbh->$method($this->result);
		return $fetchdata ;
/*
        if ($fetchmode === DB_FETCHMODE_DEFAULT) {
            $fetchmode = $this->fetchmode;
        }
        if ($fetchmode === DB_FETCHMODE_OBJECT) {
            $fetchmode = DB_FETCHMODE_ASSOC;
            $object_class = $this->fetchmode_object_class;
        }
        if ($this->limit_from !== null) {
            if ($this->row_counter === null) {
                $this->row_counter = $this->limit_from;
                // Skip rows
                if ($this->limit_type == false) {
                    $i = 0;
                    while ($i++ < $this->limit_from) {
                        $this->dbh->fetchInto($this->result, $arr, $fetchmode);
                    }
                }
            }
            if ($this->row_counter >= (
                    $this->limit_from + $this->limit_count))
            {
                if ($this->autofree) {
                    $this->free();
                }
                $tmp = null;
                return $tmp;
            }
            if ($this->limit_type == 'emulate') {
                $rownum = $this->row_counter;
            }
            $this->row_counter++;
        }
        $res = $this->dbh->fetchInto($this->result, $arr, $fetchmode, $rownum);
        if ($res === DB_OK) {
            if (isset($object_class)) {
                // default mode specified in DB_common::fetchmode_object_class property
                if ($object_class == 'stdClass') {
                    $arr = (object) $arr;
                } else {
                    $arr = &new $object_class($arr);
                }
            }
            return $arr;
        }
        if ($res == null && $this->autofree) {
            $this->free();
        }
        return $res;
*/
    }

    // }}}
    // {{{ fetchInto()

    /**
     * Fetch a row of data into an array which is passed by reference.
     *
     * The type of array returned can be controlled either by setting this
     * method's <var>$fetchmode</var> parameter or by changing the default
     * fetch mode setFetchMode() before calling this method.
     *
     * There are two options for standardizing the information returned
     * from databases, ensuring their values are consistent when changing
     * DBMS's.  These portability options can be turned on when creating a
     * new DB object or by using setOption().
     *
     *   + <samp>DB_PORTABILITY_LOWERCASE</samp>
     *     convert names of fields to lower case
     *
     *   + <samp>DB_PORTABILITY_RTRIM</samp>
     *     right trim the data
     *
     * @param array &$arr       (reference) array where data from the row
     *                          should be placed
     * @param int   $fetchmode  how the resulting array should be indexed
     * @param int   $rownum     the row number to fetch
     *
     * @return mixed  DB_OK on success, null on no more rows or
     *                a DB_Error object on error
     *
     * @see DB_common::setOption(), DB_common::setFetchMode()
     * @access public
     */
    function fetchInto(&$arr, $fetchmode = DB_FETCHMODE_DEFAULT, $rownum=null)
    {
        if ($fetchmode === DB_FETCHMODE_DEFAULT) {
            $fetchmode = $this->fetchmode;
        }
        if ($fetchmode === DB_FETCHMODE_OBJECT) {
            $fetchmode = DB_FETCHMODE_ASSOC;
            $object_class = $this->fetchmode_object_class;
        }
        if ($this->limit_from !== null) {
            if ($this->row_counter === null) {
                $this->row_counter = $this->limit_from;
                // Skip rows
                if ($this->limit_type == false) {
                    $i = 0;
                    while ($i++ < $this->limit_from) {
                        $this->dbh->fetchInto($this->result, $arr, $fetchmode);
                    }
                }
            }
            if ($this->row_counter >= (
                    $this->limit_from + $this->limit_count))
            {
                if ($this->autofree) {
                    $this->free();
                }
                return null;
            }
            if ($this->limit_type == 'emulate') {
                $rownum = $this->row_counter;
            }

            $this->row_counter++;
        }
        $res = $this->dbh->fetchInto($this->result, $arr, $fetchmode, $rownum);
        if ($res === DB_OK) {
            if (isset($object_class)) {
                // default mode specified in DB_common::fetchmode_object_class property
                if ($object_class == 'stdClass') {
                    $arr = (object) $arr;
                } else {
                    $arr = new $object_class($arr);
                }
            }
            return DB_OK;
        }
        if ($res == null && $this->autofree) {
            $this->free();
        }
        return $res;
    }

    // }}}
    // {{{ numCols()

    /**
     * Get the the number of columns in a result set.
     *
     * @return int the number of columns, or a DB error
     *
     * @access public
     */
    function numCols()
    {
        return $this->dbh->numCols($this->result);
    }

    // }}}
    // {{{ numRows()

    /**
     * Get the number of rows in a result set.
     *
     * @return int the number of rows, or a DB error
     *
     * @access public
     */
    function numRows()
    {
        return $this->dbh->getRowsNum($this->result);
    }

    // }}}
    // {{{ nextResult()

    /**
     * Get the next result if a batch of queries was executed.
     *
     * @return bool true if a new result is available or false if not.
     *
     * @access public
     */
    function nextResult()
    {
        return $this->dbh->nextResult($this->result);
    }

    // }}}
    // {{{ free()

    /**
     * Frees the resources allocated for this result set.
     * @return  int error code
     *
     * @access public
     */
    function free()
    {
        $err = $this->dbh->freeResult($this->result);
        if (DB::isError($err)) {
            return $err;
        }
        $this->result = false;
        return true;
    }

    // }}}
    // {{{ tableInfo()

    /**
     * @deprecated
     * @internal
     * @see DB_common::tableInfo()
     */
    function tableInfo($mode = null)
    {
        if (is_string($mode)) {
            return $this->dbh->raiseError(DB_ERROR_NEED_MORE_DATA);
        }
        return $this->dbh->tableInfo($this, $mode);
    }

    // }}}
    // {{{ getRowCounter()

    /**
     * returns the actual row number
     * @return integer
     */
    function getRowCounter()
    {
        return $this->row_counter;
    }
    // }}}
}

// }}}

?>
