#
# Table Structure xeblog
#

CREATE TABLE xeblog (
  blog_id mediumint(9) NOT NULL auto_increment,
  user_id mediumint(9) NOT NULL default '0',
  cat_id int(5) unsigned NOT NULL default '0',
  created int(10) NOT NULL default '0',
  title varchar(128) NOT NULL default '',
  contents text NOT NULL,
  disallow_comment tinyint(1) NOT NULL default 0,
  disallow_trackback tinyint(1) NOT NULL default 0,	
  private tinyint(1) NOT NULL default 0,
  comments int(11) NOT NULL default '0',
  reads int(100) NOT NULL default '0',
  trackbacks int(11) NOT NULL default '0',
  description text NOT NULL,
  dohtml tinyint(1) UNSIGNED NOT NULL default '0',
  dobr tinyint(1) UNSIGNED NOT NULL default '1',
  permission_group varchar(255) NOT NULL default 'all',
  permission_onlylater tinyint(1) UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (blog_id),
  KEY user_id (user_id,created,title,private)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table Structure xeblog_category
#

CREATE TABLE xeblog_category (
  cat_id int(5) unsigned NOT NULL auto_increment,
  cat_pid int(5) unsigned NOT NULL default '0',
  cat_title varchar(50) NOT NULL default '',
  cat_description text NOT NULL,
  cat_created int(10) NOT NULL default '0',
  cat_imgurl varchar(150) NOT NULL default '',
  PRIMARY KEY  (cat_id),
  KEY cat_pid (cat_pid)
) TYPE=MyISAM;

INSERT INTO xeblog_category (
  cat_id, cat_pid, cat_title, cat_description, cat_created, cat_imgurl)
  VALUES (
    '1', '0', 'Miscellaneous', '', '1051983686', ''
);
# --------------------------------------------------------

CREATE TABLE xeblog_trackback (
  blog_id varchar(12) NOT NULL ,
  tb_url text NOT NULL,
  blog_name varchar(255) NOT NULL,
  title varchar(255) NOT NULL,
  description text NOT NULL,
  link text NOT NULL,
  direction enum('','transmit','recieved') NOT NULL default '',
  trackback_created int(10) NOT NULL default '0',
  tbkey varchar(12) NOT NULL default '',	
  PRIMARY KEY  (blog_id,tb_url(100),direction)
) TYPE=MyISAM;

# --------------------------------------------------------
#
# Table structure for table `myalbum_photos`
#

CREATE TABLE xeblog_photo (
  filename varchar(32) NOT NULL default '',
  blog_id varchar(32) NOT NULL default '0',
  cid int(5) unsigned NOT NULL default '0',
  ext varchar(10) NOT NULL default '',
  res_x int(11) NOT NULL default '',
  res_y int(11) NOT NULL default '',
  submitter int(11) unsigned NOT NULL default '0',
  status tinyint(2) NOT NULL default '0',
  has_thumb tinyint(1) UNSIGNED NOT NULL default '0',	
  date int(10) NOT NULL default '0',
  PRIMARY KEY  (filename),
  KEY blog_id (blog_id)
) TYPE=MyISAM;
