<?php
// vim: foldmethod=marker
/**
 *	Sample_Rss.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@package	Sample
 *	@version	$Id: Sample_Rss.php,v 1.1 2005/01/23 13:46:58 masaki-f Exp $
 */

// {{{ Xanhte_RssManager
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Sample
 */

class Xanhte_XeblogEntryManager extends Xanhte_AppManager
{
	function Xanhte_XeblogEntryManager(&$backend){
		$this->Xanhte_AppManager(&$backend);
	}
	
	/**
	 *	blog_idäơñΥȥ꡼֥Ȥ֤(ƻ)
	 *
	 *	@access		public
	 *  @return     Xanhte_XeblogEntry֥
	 */	
	function getEntryObject($blog_id=0, $prop=null){
		$blog_id = intval($blog_id);
		if(!empty($blog_id)){
			$filter = array();
			$filter['blog_id'] =& new Ethna_AppSearchObject($blog_id, OBJECT_CONDITION_EQ) ;
			$entry_object_list =& $this->getObjectList('XeblogEntry', $filter);
			if($entry_object_list[0]==1){
				$entry =& $entry_object_list[1][0] ;
				if($entry->get('permission_group')=='all'){
					global $member_handler;
					$entry->set('permission_group', array_keys($member_handler->getGroupList()));
				}else{
					$entry->set('permission_group', explode('|', $entry->get('permission_group')));
				}
				return $entry ;
			}
		}
		$entry =& new Xanhte_XeblogEntry(&$this->backend, null, null, $prop);
		return $entry ;
	}

	
	/**
	* Entry֥ȤѤͤΤȤpermission_groupȤĴ
	* ϡ֥Ȥʤơ֤
	*
	*  @access	   public
	*  @return     array
	**/
	function getEntryObjectProp($keys=null, $filter=null){
		global $membar_handler ;
		$entry_prop = $this->getObjectProp('XeblogEntry', $keys, $filter) ;
		// permission_group
		if($entry_prop['permission_group']=='all'){
			global $member_handler;
			$entry_prop['permission_group'] = array_keys($member_handler->getGroupList());
		}else{
			$entry_prop['permission_group'] = explode('|', $entry_prop['permission_group']);
		}

		return $entry_prop ;
	}
	
	/**
	 * IndexѤΥȥ꡼(IndexѤȤĤġ빽ȤäƤޤ :)
	 * @param int 
	 * @return array 0=>ȥ, 1=>ȥ꡼
	 **/
	 
	function getEntries4Index($num=false, $cat_id=false, $user_id=false){
		global $xoopsModuleConfig, $xoopsModule ;
		
	    $filter = $this->getXeblogFilter();

		// ƥƼ
		$add_filters = array('cat_id','user_id');
		foreach($add_filters as $add_filter){
			if($this->af->get($add_filter) || ${$add_filter}){
				$filter_var = ${$add_filter} ? ${$add_filter} : $this->af->get($add_filter);
				$filter[$add_filter] =&  new Ethna_AppSearchObject($filter_var, OBJECT_CONDITION_EQ);
			}
		}
		// եե륿
		if($this->af->get('caldate')){
			$filter['created'] =& $this->_getXeblogFilterOfCaldate($this->af->get('caldate'));
		}
		
	    $order = array('created'=> OBJECT_SORT_DESC);
	    $offset = $this->af->get('start');
		$limit = $num ? $num : $xoopsModuleConfig['numperpage'];
	    $entries =& $this->getObjectPropList('XeblogEntry', null ,  $filter, $order, $offset, $limit);
	    foreach($entries[1] as $key=>$value){
			$entries[1][$key]['editpriv'] = $this->hasEntryEditPriv($value['user_id']) & $this->xeblogC->isPostableCategory($value['cat_id']);
			// ȥꤴȤαĴ
			if( $this->isReadableEntry(&$entries[1][$key]) ){
				$this->isReadableEntryLaterHalf(&$entries[1][$key]) ;
			}
	    }
		return $entries ;
	
	}
	
	
	/**
	 *	xeblog_****Action饹ǻȤե륿
	 *  ν֤ ȥID > user_id > etc. conditions
	 *
	 *	@access	public
	 *  @param int ȥID
	 *	@return	array 
	 */
	
	function getXeblogFilter($blog_id=0, $is_read=true)
	{
	    global $xoopsModuleConfig, $xoopsUser, $xoopsModule ;
		$now = time();
		
		if ( ! is_object($xoopsUser)) {
			$xoopsUser =& new XoopsUser();
			$xoopsUser->setVar('uid', 0);
		}
		
		// created
		$filter = array();
		$filter_created =& new Ethna_AppSearchObject($now, OBJECT_CONDITION_LT) ;
		if( !$xoopsUser->isAdmin($xoopsModule->mid())){
			$private_filter =& new Ethna_AppSearchObject('N', OBJECT_CONDITION_EQ) ;
			$filter_created->addObject('private', $private_filter, OBJECT_CONDITION_AND) ;
		}
		// filter permission_group
	    $filter_CreatePermission =& $this->CreatePermissionSO() ;
		$filter_created->addObject('permission_group', $filter_CreatePermission, OBJECT_CONDITION_AND);
		
		// ʬΥ֥ϱǽ
		if($xoopsUser->uid()){
			$filter_owner =& new Ethna_AppSearchObject($xoopsUser->uid(), OBJECT_CONDITION_EQ) ;
			$filter_owner->addObject('created', $filter_created, OBJECT_CONDITION_OR);
			$filter['user_id'] =& $filter_owner;
		}else{
			$filter['created'] =& $filter_created ;
		}
		// filter category permission
		if($xoopsModuleConfig['category_permission']){		
			$filter['cat_id'] = $this->xeblogC->getAllowedCategorySO($is_read) ;
		}
		// blog_id
		if(intval($blog_id)){
			$filter['blog_id'] =& new Ethna_AppSearchObject($blog_id, OBJECT_CONDITION_EQ) ;
		}

		return $filter ;
	}
	
	
	/**
	 * դͿ줿Υե륿֥Ȥ֤
	 * @param string yyyy-mm-dd
	 **/ 
	function &_getXeblogFilterOfCaldate($yyyy_mm_dd){
		require_once XANHTE_ROOT_PATH.'/lib/Date/Calc.php';
		
		list($year,$month,$day) = sscanf($yyyy_mm_dd, '%d-%d-%d');
//		$yyyymmdd = sprintf('%04d%02d%02d', $year, $month, $day);
//		$fp = fopen('/tmp/date_calc.log','a+');
//		fputs($fp,$yyyymmdd."::".$yyyy_mm_dd."\n");
		
//		if(strlen($yyyymmdd)==4){		// year
		if(is_null($year) && is_null($month) && is_null($day)){ // no caldate
			$so =& new Ethna_AppSearchObject(0, OBJECT_CONDITION_GE);
			return $so ;		
		}elseif( is_null($month) && is_null($day) ){ // year only
			$start_day = sprintf('%04s%02s%02s',$year,1,1);
			$end_day = sprintf('%04s%02s%02s',$year+1,1,1);
//		}elseif(strlen($yyyymmdd)==6){		// month
		}elseif( is_null($day) ){ // month only
			$start_day = sprintf('%04s%02s%02s',$year,$month,1);
			$end_day = Date_Calc::beginOfNextMonth(1, $month, $year, '%Y%m%d');
		}else{		// day
			$start_day =  sprintf('%04s%02s%02s',$year,$month,$day);
			$end_day = Date_Calc::nextDay($day, $month, $year, '%Y%m%d') ;
		}
		$start = Xanhte_Util::fixTZ(Xanhte_Util::make_unixtime($start_day));
		$end = Xanhte_Util::fixTZ(Xanhte_Util::make_unixtime($end_day));
		$caldateSO =& new Ethna_AppSearchObject($start, OBJECT_CONDITION_GE);
		$caldateSO->addObject('created',new Ethna_AppSearchObject($end, OBJECT_CONDITION_LT), OBJECT_CONDITION_AND);
		return $caldateSO ;
	}
	
	
	/**
	 * PingǤ
	 * @param object Xanhte_XeblogEntry
	 **/ 
	function _doPing($entry){
		global $xoopsModule, $xoopsModuleConfig ;
		require_once 'XML/RPC.php';
		
		// ping
		$ping_server = explode("\n", $xoopsModuleConfig['ping_servers']);

		// XML֥Ȥ
		$blog_name = Xanhte_Util::con_enc($entry->getBlogName(), 'UTF-8');
        $xeblog_url = sprintf('%s/modules/%s/', XOOPS_URL, $xoopsModule->dirname() ) ;
		$xml_params = array(
			new XML_RPC_Value($blog_name, "string"),
			new XML_RPC_Value($xeblog_url, "string")
			);
		$Ping_XML = new XML_RPC_Message("weblogUpdates.ping", $xml_params);

		// send ping
		$xmlrpc_client = new XML_RPC_Client('', '', 80);
        $this->Server_Response = 
	    $result_msg = "" ;
		foreach($ping_server as $server_str){
			$server_str = trim($server_str);
			if(strncmp($server_str, '#', 1) === 0) continue ; // ȥȥ
			if(preg_match('|^https?://[\w\-]+\.[\w\-]+|', $server_str)){
				// Ping
				$server_info = parse_url($server_str);
				$xmlrpc_client->path = $server_info['path'];
				$xmlrpc_client->server = $server_info['host'];
				$response = $xmlrpc_client->send($Ping_XML);
				if ( strtolower(get_class($response))=="xml_rpc_response" &&  $response->faultCode()==false) {
					$result_msg .= $server_str . "=&gt;" . "success<br>\n" ;
				}else{
					$result_msg .= $server_str . "=&gt;" . "failed<br>\n" ;
				}
			}else{
				$result_msg .= $server_str . "=&gt;" . "is not valid URL<br>\n" ;
			}
		}
		if($result_msg){
			$result_msg =  "<br />\n---- &nbsp; Update &nbsp; Ping &nbsp; ----\n<br />\n" . $result_msg . "<br />" ;
		}
		return $result_msg ;
	}
	 
	/**
	*  ȥα򥢥åפ
	*  @access public
	*  @return null
	**/
	function increaseEntryRead($entry){
		global $xoopsUser, $xoopsModuleConfig, $xoopsDB, $xoopsModule ;
		$now = time();
		
		$blog_id = $entry['blog_id'];
		// Read in cookie
		$weblog_read = isset($_COOKIE['WEBLOG_COOKIE_READ']) ? unserialize($_COOKIE['WEBLOG_COOKIE_READ']) : array();
		// if cookie is not set for this blog, update view count and set cookie (and auther or Admin does not count)
		if ( empty($weblog_read[$blog_id]) || $weblog_read[$blog_id] + $xoopsModuleConfig['expiration'] < $now ) {
			if( ! (is_object($xoopsUser) &&  $xoopsUser->getVar('uid')==$entry['user_id']) ){
				$sql = sprintf('update %s set reads=reads+1 where blog_id=%d', $xoopsDB->prefix('xeblog'),  $blog_id) ;// ȳݤʤΤľSQLȯ
				$xoopsDB->queryF($sql);
			}
		}
		// Update cookie
		if(isset($_COOKIE['WEBLOG_COOKIE_READ']) && strlen($_COOKIE['WEBLOG_COOKIE_READ'])>=4096){
			// 20byteʤΤǡŤΤ50ĺ
			arsort($weblog_read);
			for($i=1; $i<=50; $i++){ array_pop($weblog_read); }
		}
		$weblog_read[$blog_id] = $now;
		$weblogCookie = array(
			'domain' => "",
			'path' => str_replace(basename($_SERVER['PHP_SELF']),"",$_SERVER['PHP_SELF']) ,
			'secure' => false
			);
		setcookie('WEBLOG_COOKIE_READ', serialize($weblog_read), $now+$xoopsModuleConfig['expiration'], $weblogCookie['path'], $weblogCookie['domain'], $weblogCookie['secure']);
		
		return null ;
	}
	
	
	
	/**
	*  ȥ꤬ǽɤå
	*  @access public
	*  @param array / object(Xanhte_XeblogEntry) 
	*  @return boolean
	**/

	function isReadableEntry(&$entry){
		global $xoopsUser, $xoopsModuleConfig ;
		
		$ret = false ;
		if(is_array($entry)){
			$permission_onlylater = $entry['permission_onlylater'] ;
		}elseif(strtolower(get_class($entry))=='xanhte_xeblogentry'){
			$permission_onlylater = $entry->get('permission_onlylater') ;
		}
		if($permission_onlylater){
			$ret = true ;
		}
		// ȤϡƱ
		if(!$ret){
			$ret = $this->isReadableEntryLaterHalf(&$entry);
			if(!$ret){
				$entry['contents'] = -1 ;
				$entry['description'] = '';
			}
		}
		return $ret ;
	}


	/**
	*  ȥ꤬Ⱦǽɤå
	*  @access public
	*  @param array / object(Xanhte_XeblogEntry) 
	*  @return boolean
	**/
	
	function isReadableEntryLaterHalf(&$entry){
		global $xoopsUser, $xoopsModuleConfig, $xoopsModule ;
		
		$ret = false ;
		if(!$xoopsModuleConfig['use_permissionsystem'] || 
		   (is_object($xoopsUser) && $xoopsUser->isAdmin($xoopsModule->mid()) )){
			$ret = true ;
			return $ret ;
		}
		
		$ret = false ;
		if(is_array($entry)){
			$permission_group = $entry['permission_group'] ;
		}elseif(strtolower(get_class($entry))=='xanhte_xeblogentry'){
			$permitted_group = $entry->get('permission_group');
		}
		if($permission_group=='all'){
			$ret = true ;
			return $ret ;
		}

		$user_group = is_object($xoopsUser) ? $xoopsUser->getGroups() : array();
		$permitted_group = explode('|',$permission_group);
		$intersect = array_intersect($permitted_group, $user_group);
		if(!empty($intersect)){
			$ret = true ;
			return $ret ;
		}
		if(!$ret){
			$entry['description'] = -1;	// disallow description
		}
		return $ret  ;
	}

	
	/**
	 *	Ƥ줿ΤФԽ¤뤫ɤ
	 *	@access	public
	 *  @param int blog_user_id
	 *	@return	string	̾
	 */
	function hasEntryEditPriv($user_id){
	     global $xoopsUser, $xoopsModule ;
	     if(!is_object($xoopsUser)){
			 return false ; // ȤԽǤʤ
	     }
	     if($xoopsUser->isAdmin()){
			 return true ; // ѡ桼ϲǤOKʸ¼ΤѤ뤫
	     }
	     if($xoopsUser->isAdmin($xoopsModule->mid())){
			 return true ;
	     }
	     if($user_id == $xoopsUser->uid()){
			 return true ;
	     }
	     return false ;
	 }

	
	/**
	*  permission_groupwhereΤɬפfunction
	*  @access private
	*  @return Object ŬڤʾäEthna_AppSearchObject
	**/
	
	function &CreatePermissionSO($mydirname=''){
	    global $xoopsUser , $xoopsModule , $xoopsModuleConfig , $module_handler , $config_handler ;

		empty($mydirname) && is_object($xoopsModule) and $mydirname = $xoopsModule->dirname();
		
		// Config
		if( ! is_object($xoopsModule) || $xoopsModule->dirname() != $mydirname ){
			if(! is_object($module_handler)) $module_handler =& xoops_gethandler('module');
			$module =& $module_handler->getByDirname( $mydirname );
			$config =& $config_handler->getConfigsByCat(0, $module->mid());
		}else{
			$module =& $xoopsModule ;
			$config =& $xoopsModuleConfig ;
		}
	    // check user's group privilege 
	    if( !(isset($xoopsUser) && get_class($xoopsUser) == "xoopsuser" )){
			$user =& new XoopsUser ;
		}else{
			$user =& $xoopsUser ;
		}
		// Ѥʤ䡢Ը¤ξϥ롼
		if(!$config['use_permissionsystem'] || $user->isAdmin($module->mid()) ){
			$ret =& new Ethna_AppSearchObject('', OBJECT_CONDITION_LIKE) ;
			return $ret ;
		}
		
		// RETURN
		$so =& new Ethna_AppSearchObject('all', OBJECT_CONDITION_EQ) ;
		$so->addObject('permission_onlylater', new Ethna_AppSearchObject('1',OBJECT_CONDITION_EQ), OBJECT_CONDITION_OR); 

		// 롼IDEthna_AppSearchObjectȤΩ
		$user_group = $user->getGroups();
		foreach($user_group as $gid){
			$so->addObject('permission_group',
						   new Ethna_AppSearchObject(sprintf('|%s|',$gid), OBJECT_CONDITION_LIKE),
						   OBJECT_CONDITION_OR) ;
		}
		return $so ;
	}
	
	/**
	 * ǥȥμΥȥ
	 * @access public
	 * @param array ȥ꡼
	 * @param array AppSearchObjectfilter
	 * @param boolean nextprev
	 * @return array Υȥ꡼
	 **/
	 
	function getNextPrevEntry($entry, $filter, $is_next=true){
		
		if(isset($filter['blog_id'])){
			unset($filter['blog_id']) ;
		}
		$filter['created'] = new Ethna_AppSearchObject($entry['created'], $is_next?OBJECT_CONDITION_GT:OBJECT_CONDITION_LT ) ;
		$order = $is_next ? array('created'=> OBJECT_SORT_ASC) : array('created'=>OBJECT_SORT_DESC) ;
		$limit = 1 ;
		$offset = 0 ;
		$e_entry = $this->getObjectPropList('XeblogEntry', null, $filter, $order , $offset, $limit);

		return isset($e_entry[1][0]) ? $e_entry[1][0] : array();
	}

	/**
	 * ȥ꡼RDFˤ
	 * @param array ȥ꡼
	 * @return string RDF
	 **/
	 
	function createRDF($entry){
		global $xoopsModule, $xoopsUser, $xoopsConfig ;
		require_once 'XML/Serializer.php' ;
		
		$myts = new MyTextSanitizer ;
		
		$options = array(
			"mode" => "simplexml" ,
			"indent"    => "    ",
			"linebreak" => "\n",
			"typeHints" => false,
			"addDecl"   => false,
			"encoding"  => _CHARSET,
			"rootName"  => "rdf:RDF",
			"rootAttributes" => array(
				"xmlns" => "http://purl.org/rss/1.0/",
				"xmlns:rdf" => "http://www.w3.org/1999/02/22-rdf-syntax-ns#",
				"xmlns:dc" => "http://purl.org/dc/elements/1.1/",
				"xmlns:sy" => "http://purl.org/rss/1.0/modules/syndication/",
				"xmlns:admin" => "http://webns.net/mvcb/",
				"xmlns:content" => "http://purl.org/rss/1.0/modules/content/"
				),
			"defaultTagName" => "item",
			"attributesArray" => "_attributes",
			'cdata' => false,
			);
		$data = array(
			'rdf:Description'=> array(
				'_attributes' => array(
					'rdf:about' => sprintf('%s/modules/%s/?action_xeblog_details=1&amp;blog_id=%d', XOOPS_URL, $xoopsModule->dirname(), $entry['blog_id']),
					'trackback:ping' => sprintf('%s/modules/%s/?action_xeblog_tb=do&amp;blog_id=%d', XOOPS_URL, $xoopsModule->dirname(), $entry['blog_id']),
					'dc:title'=> $entry['title'],
					'dc:identifier'=> sprintf('%s/modules/%s/?action_xeblog_details=1&amp;blog_id=%d', XOOPS_URL, $xoopsModule->dirname(), $entry['blog_id']),
					'dc:description' => xoops_substr(strip_tags($myts->displayTarea($entry['contents'], $entry['dohtml'], $smiley = 1, $xcode = 1, $image = 1, 0)) ,0 , 100),
					'dc:creator' => $entry['uname'],
					'dc:date' => sprintf('%sT%s%s', date('Y-m-d', $entry['created']), date('H:i:s', $entry['created']), Xanhte_Util::convTZ($xoopsConfig['server_TZ']) ) ,
					)
				)
			);
		$Serializer = &new XML_Serializer($options);
		$status = $Serializer->serialize($data);
		if (PEAR::isError($status)){
			die($status->getMessage());
		}
		
		$ret = $Serializer->getSerializedData();

		return $ret ;
	}
	
	/**
	 * 桼Ȥƿɽ
	 * @param int 
	 * @return array entries
	 **/
	function countEntriesByUser($num=10){
		global $xoopsDB , $xoopsModule ;
		
		// SQLľȯԤ򤷤ޤ
		$options = $this->af->get('options');
		$field = ($options[3] == '1') ? 'count(*)': 'sum(`reads`)';
		$sql = sprintf('select user_id,uname,user_avatar,%s as post_num from %s,%s where user_id=uid group by user_id order by post_num DESC limit %d',
					   $field, $xoopsDB->prefix($xoopsModule->dirname()), $xoopsDB->prefix('users'), $num);
		$db =& $this->backend->getDB();
		$r =& $db->query($sql);
		$user_postnums = array();
		while($res = $r->fetchRow()){
			$user_postnums[] = $res ;
		}
		return $user_postnums ;
	}
	
	/**
	 * 桼Ȥκǽ
	 * @param int 
	 * @return array users
	 **/
	function getLastUpdateUsers($num=10){
		global $xoopsDB , $xoopsModule ;
		
		// SQLľȯԤ򤷤ޤ
		$whereSO =& $this->getXeblogFilter();
		$where_field = isset($whereSO['user_id']) ? 'user_id' : 'created' ;
		$options = $this->af->get('options');
		$field = ($options[5] != '1') ? 'max(`created`)': 'sum(`reads`)';
		$sql = sprintf('select uname,user_avatar,user_id,%s as sort_value from %s,%s where user_id=uid and %s group by user_id order by sort_value DESC limit %d',
					   $field, $xoopsDB->prefix($xoopsModule->dirname()), $xoopsDB->prefix('users'), $whereSO[$where_field]->toString($where_field), $num);
		$db =& $this->backend->getDB();
		$r =& $db->query($sql);
		$users = array();
		while($res = $r->fetchRow()){
			$users[] = $res ;
		}
		return $users ;
	
	}


	
	/**
	 * Ϳ줿(YYYYMM)ȤΥȥ꤬뤫ɤ֤
	 * @param YYYYMM
	 * @return array 
	 **/
	function getListOfEntryMonth($yyyymm){
		global $xoopsDB , $xoopsModule ;
		
		// ȷunixtimeǵޤ
		if(!preg_match('/^\d{6}$/', $yyyymm)){
			 return array();
		}
		$year = substr($yyyymm, 0, 4);
		$month = substr($yyyymm, 4, 2);
		require_once XANHTE_ROOT_PATH.'/lib/Date/Calc.php';
		$month_start = Xanhte_Util::fixTZ(Xanhte_Util::make_unixtime(sprintf('%04s%02s%02s', $year, $month, 1)));
		$month_end = Xanhte_Util::fixTZ(Xanhte_Util::make_unixtime(sprintf('%04s%02s%02s', $year, $month, Date_Calc::daysInMonth($month,$year))));
		
		// SQLľȯԤ򤷤ޤ
		$whereSO =& $this->getXeblogFilter();
		$where_field = isset($whereSO['user_id']) ? 'user_id' : 'created' ;
		$sql = sprintf('select substring(from_unixtime(`created`+%d),1,10) as post_day from %s where created>%d and created<=%d and %s group by post_day',
					   Xanhte_Util::fixTZ(),$xoopsDB->prefix($xoopsModule->dirname()),$month_start, $month_end , $whereSO[$where_field]->toString($where_field));
		$db =& $this->backend->getDB();
		$r =& $db->query($sql);
		$result = array();
		while($res = $r->fetchRow()){
			$day = str_replace('-','',$res['post_day']) ;
			$result[$day] = true ;
		}
		return $result ;
	
	}
	
	
	
	/**
	 * ȥ꡼򸡺
	 * @param string 
	 * @param int եå
	 * @param int 
	 * @param string AND/OR
	 * @return array entries
	 **/
	function searchEntries($query, $start=0, $limit=20, $andor='AND', $uid=0){
		global $xoopsModule ;
		
		$filter = $this->getXeblogFilter();
		$condition = strtoupper($andor)=='AND' ? OBJECT_CONDITION_AND : OBJECT_CONDITION_OR ;
		$so =&  new Ethna_AppSearchObject(0, OBJECT_CONDITION_GT); // dummy
		if( is_array($query) && count($query) > 0){
			// TITLE
			$so_title =& new Ethna_AppSearchObject($query[0], OBJECT_CONDITION_LIKE);
			for($i=1; $i<count($query); $i++){
				$so_title->addObject('title', new Ethna_AppSearchObject($query[$i], OBJECT_CONDITION_LIKE), $condition);
			}
			$so->addObject('title', $so_title, OBJECT_CONDITION_AND);
			// CONTENTS
			$so_contents =& new Ethna_AppSearchObject($query[0], OBJECT_CONDITION_LIKE);
			for($i=1; $i<count($query); $i++){
				$so_contents->addObject('title', new Ethna_AppSearchObject($query[$i], OBJECT_CONDITION_LIKE), $condition);
			}
			$so->addObject('contents', $so_contents, OBJECT_CONDITION_OR);
			// DESCRIPTION
			$so_description =& new Ethna_AppSearchObject($query[0], OBJECT_CONDITION_LIKE);
			for($i=1; $i<count($query); $i++){
				$so_description->addObject('description', new Ethna_AppSearchObject($query[$i], OBJECT_CONDITION_LIKE), $condition);
			}
			$so->addObject('description', $so_description, OBJECT_CONDITION_OR);
			$filter['blog_id'] = $so ;
		}
		if(intval($uid)){
			$filter['user_id'] = new Ethna_AppSearchObject($uid, OBJECT_CONDITION_EQ);
		}
		$entriesProp =& $this->getObjectPropList('XeblogEntry', array('title','created','blog_id','user_id'), $filter, array('created'=>OBJECT_SORT_DESC), $start, $limit);
		foreach($entriesProp[1] as $key=>$entry){
			$entriesProp[1][$key]['uid'] = $entry['user_id'];
			$entriesProp[1][$key]['time'] = $entry['created'];
			$entriesProp[1][$key]['link'] = sprintf('?action_xeblog_details=1&amp;blog_id=%d', $entry['blog_id']);
		}
		return $entriesProp[1] ;
	}
	
}
// }}}

// {{{ Xanhte_Rss
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Sample
 */
class Xanhte_XeblogEntry extends Xanhte_AppObject
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	array	ơ֥
	 */
        var $table_def = array(
			'xeblog' => array(
				'primary' => true 
				)
			);
	
        var $prop_def = array(
	    'blog_id'=> array(
			'primary' => true,
			'key' => true,
			'seq' => true,
			'type' => VAR_TYPE_INT,
			'form_name' => 'blog_id',
			'prop_name' => '֥ID' ,
			),
		'user_id'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_INT,
			'form_name' => 'user_id',
			'prop_name' => '桼ID' ,
			),
		'cat_id'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_INT,
			'form_name' => 'cat_id',
			'prop_name' => 'ID' ,
		),
	    'created'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_INT,
			'form_name' => 'created',
			'prop_name' => '' ,
		),
	    'title'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_STRING,
			'form_name' => 'title',
			'prop_name' => '' ,
		),
	    'contents'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_STRING,
			'form_name' => 'contents',
			'prop_name' => 'ʸȾ' ,
		),
	    'description'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_STRING,
			'form_name' => 'description',
			'prop_name' => 'ʸʸȾ' ,
		),
	    'private'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_BOOLEAN,
			'form_name' => 'private',
			'prop_name' => '' ,
		),
	    'disallow_comment'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_BOOLEAN,
			'form_name' => 'disallow_comment',
			'prop_name' => '' ,
		),
		'disallow_trackback'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_BOOLEAN,
			'form_name' => 'disallow_trackback',
			'prop_name' => '' ,
		),
	    'comments'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_INT,
			'form_name' => 'comments',
			'prop_name' => '' ,
		),
	    'reads'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_INT,
			'form_name' => 'reads',
			'prop_name' => '' ,
		),
	    'trackbacks'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_INT,
			'form_name' => 'trackbacks',
			'prop_name' => '' ,
		),
	    'dohtml'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_BOOLEAN,
			'form_name' => 'dohtml',
			'prop_name' => '' ,
		),
	    'dobr'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_BOOLEAN,
			'form_name' => 'dobr',
			'prop_name' => '' ,
		),
	    'permission_group'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_STRING,
			'form_name' => 'permission_group',
			'prop_name' => '' ,
		),
		'permission_onlylater'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_BOOLEAN,
			'form_name' => 'permission_onlylater',
			'prop_name' => '' ,
		),
	    // ʲjoin¦prop
	    'cat_title'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_STRING,
			'form_name' => '',
			'prop_name' => '' ,
			'table' => 'xeblog_category',
			),
	    'uname'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_STRING,
			'form_name' => '',
			'prop_name' => '' ,
			'table' => 'users',
			),
		'user_avatar'=> array(
			'primary' => false,
			'key' => false,
			'type' => VAR_TYPE_STRING,
			'form_name' => '',
			'prop_name' => '' ,
			'table' => 'users',
			),
	    );

	/**
	 *	@var	array	JOINơ֥
	 *      'mainjointable' => array(
	 *           'JOIN'=> 'JOIN'
	 *       )
	 */

        var $table_join = array(
			'users' => array(
				'xeblog.user_id' => 'users.uid',
				),
			'xeblog_category' => array(
				'xeblog.cat_id'=> 'xeblog_category.cat_id',
				),
			);
	/**#@-*/	    
	
	/**#@-*/

	/**
	 *	Xeblog_Entry饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	&$backend	Ethna_Backend֥
	 *	@param	mixed	$key_type					
	 *	@param	mixed	$key						
	 *	@param	array	$prop						ץѥƥ
	 */
	function Xanhte_XeblogEntry(&$backend, $key_type = null, $key = null, $prop = null)
	{
	    $r = $this->Xanhte_AppObject(&$backend, $key_type, $key, $prop);
	    if (Ethna::isError($r)) {
			return $r;
	    }
	    // ֥ȼԤϤ˵Ҥޤ
	}

	/**
	 *	ơ֥른祤
	 *
	 *	@access	public
	 *	@param	string	$table_name	ꤹơ֥
	 *	@param	array	$table_prop	ơ֥ץѥƥ
	 *	@return	null
	 */
	function _SQLPlugin_SearchTable()
	{
	    $join_query = '';
		if( is_array($this->table_join) ){
			foreach($this->table_join as $right_table => $join_def){
				$join_query .= " left join $right_table ON " ;
				list($l, $r) = each($join_def) ;
				$join_query .= sprintf(' %s=%s ', $l, $r);
			}
		}
	    return $join_query;
	}

/*        // Dummy
        function _isAdditionalField($v){
	    return true ;
	} */
	/**
	 *	ơ֥ؤΥ(W)
	 *
	 *	@access	public
	 *	@param	string	$table_name	ꤹơ֥
	 *	@param	array	$table_prop	ơ֥ץѥƥ
	 *	@return	null
	 */
	function setTable($table_name, $table_prop)
	{
		if( is_string($table_name) && is_array($table_prop)){
			$this->table_def[$table_name] = $table_prop ;
		}
	}
	
	/**
	 *	եؤΥ(W)
	 *
	 *	@access	public
	 *	@param	string	$prop_field	ꤹץѥƥ̾
	 *	@param	array	$prop_prop	ץѥƥ
	 *	@return	null
	 */
	function setProp($prop_field, $properties)
	{
		if( is_string($prop_field) && is_array($properties)){
			$this->prop_def[$prop_field] = array(
				'primary' => $properties['primary'],
				'key' => $properties['key'], 
				'type' => $properties['type'], 
				'form_name' => $properties['form_name'],
				'prop_name' => $properties['prop_name'] ,
			) ;
		}
	}
	
	/**
	 *	桼ץѥƥɽؤΥ
	 *
	 *	@access	public
	 *	@param	string	$key	桼ץѥƥ̾
	 *	@return	mixed	$keyǻꤷ桼ץѥƥ
	 */
	function getName($key)
	{
		return $this->get($key);
	}

	/**
	 *	桼ץѥƥɽ̾ǼϢ
	 *
	 *	@access	public
	 *	@return	array	桼ץѥƥɽ̾ǼϢ
	 */
	function getNameObject()
	{
		$object = parent::getNameObject();

		return $object;
	}
	
	/**
	 *	ץѥƥܺ̾Ǽ°ϢǼ
	 *
	 *	@access	public
	 *	@return	array	ץѥƥܺ̾ǼϢ
	 */
	function getNameProp()
	{
		$object = array();

		foreach ($this->prop_def as $key => $elt) {
			$object[$key] = isset($elt['prop_name']) ? $elt['prop_name'] : '' ;
		}

		return $object;
	}

	
	/**
	 *  update()ȡprimaryơ֥ʳΥץѥƥ⴬Τǡк
	 *  @access public
	 *  @return mixed	0:ｪλ Ethna_Error:顼
	 */
	function update(){
		$original_prop_def = array();
		// ץѥƥ
		foreach($this->prop_def as $key=>$def){
			if(isset($def['table']) && $def['table']!= $this->_getPrimaryTable()){
				$original_prop_def[$key] = $def ;  // 
				unset($this->prop_def[$key]);
			}
		}
		// åץǡ
		$ret = parent::update();
		// ᤹
		foreach($original_prop_def as $key=>$def){
			$this->prop_def[$key] = $def ;
		}
		return $ret ;
	}
	
	
	
	/**
	 *	xeblog_****饹ǻȤ
	 *  ȥåХå˻Ȥ֥̾
	 *	@access	public
	 *  @return	string	̾
	 **/
	function getBlogName(){
		global $xoopsUser, $xoopsConfig, $xoopsModule, $xoopsModuleConfig ;
		if(!is_object($xoopsUser)){
			return false ; // Ȥ̵
		}
		$before_bn = array('{MODULE_NAME}','{USER_NAME}','{SITE_NAME}') ;
        $after_bn = array($xoopsModule->name(), $xoopsUser->getVar('uname','E'), $xoopsConfig['sitename']) ;
        $blog_name = str_replace($before_bn, $after_bn, $xoopsModuleConfig['transmit_blogname']) ;

		return $blog_name;
	 }

}
// }}}

?>
