#include "htlib2.h"
#include "log.h"

static void
logfunc(const char* file,
		int line,
		HTLIB_LOGLEVEL level,
		const char* msg)
{
	fprintf(stderr, "%s:%d: [lv=%d] %s", file, line, level, msg);
}

static HTLIB_LOG_HANDLER s_LogFunc = logfunc;

static int s_loglevelAndHigher = 3;

void
G(LOG)(const char* file, int line, HTLIB_LOGLEVEL level,
	   const char* format, ...)
{
	va_list ap;
	char buf[256];

	if (s_loglevelAndHigher < level || s_LogFunc == NULL) {
		return;
	}
	va_start(ap, format);

	vsnprintf(buf, sizeof(buf), format, ap);
	s_LogFunc(file, line, level, buf);

	va_end(ap);
}

void
G(SetLogHandler)(HTLIB_LOG_HANDLER handler)
{
	s_LogFunc = handler;
}
void
G(SetLogLevel)(HTLIB_LOGLEVEL levelOrHigher)
{
	s_loglevelAndHigher = levelOrHigher;
}

const char*
G(GetErrorMessage)(HTLIB_ERROR err)
{
	const struct ErrMsg {
		int err;
		const char* msg;
	} c_msg[] = {
#define ERRMSG(e) { e, #e }
		ERRMSG(HTLIB_E_NO_ERROR),

		ERRMSG(HTLIB_E_INVALID_ARG),
		ERRMSG(HTLIB_E_INVALID_STATE),
		ERRMSG(HTLIB_E_OUT_OF_MEMORY),
		ERRMSG(HTLIB_E_TIMEOUT),
		ERRMSG(HTLIB_E_INVALID_SYNTAX),
		ERRMSG(HTLIB_E_CANCELED),

		ERRMSG(HTLIB_E_1XX_RECEIVED),
		ERRMSG(HTLIB_E_DISCONNECTED),
		
		ERRMSG(HTLIB_E_FATAL),
		ERRMSG(HTLIB_E_NOT_IMPLEMENTED),
	
		ERRMSG(HTLIB_E_SYSTEM),
	};
	int i;
	for (i=0; i<sizeof(c_msg)/sizeof(c_msg[0]); i++) {
		if (c_msg[i].err == err) {
			return c_msg[i].msg;
		}
	}
	return "<undefined>";
}
