#ifndef _htlib2_h
#define _htlib2_h

#include <stdio.h>
#include <string.h>
#include <pthread.h>
#include <sys/socket.h>
#include <errno.h>
#include <netdb.h>
#include <stdarg.h>
#include <ctype.h>
#include <unistd.h>

#include "../htlib.h"
#include "cmn.h"
#include "log.h"

typedef unsigned long long ULONGLONG;
typedef unsigned long ULONG;
typedef unsigned short USHORT;
typedef unsigned char UCHAR;
typedef int BOOL;

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif


void G(LOG)(const char* file, int line, HTLIB_LOGLEVEL level, const char* format, ...);
		
#define LOGFATAL(format, arg...) \
	G(LOG)(__FILE__, __LINE__, HTLIB_LV_FATAL, format, ##arg)
#define LOGERR(format, arg...) \
	G(LOG)(__FILE__, __LINE__, HTLIB_LV_WARN, format, ##arg)
#define LOGWARN(format, arg...) \
	_htlib_LOG(__FILE__, __LINE__, HTLIB_LV_WARN, format, ##arg)
#define LOGINFO(format, arg...) \
	_htlib_LOG(__FILE__, __LINE__, HTLIB_LV_INFO, format, ##arg)
#define LOGDBG(format, arg...) \
	_htlib_LOG(__FILE__, __LINE__, HTLIB_LV_DEBUG, format, ##arg)


#define FLAG_KEEP_ALIVE   0x00000001
#define FLAG_HEAD_REQUEST 0x00000002

#define FLAG_REPORTED_NO_SELECT 0x00000100

#define FLAG_SEND_CHUNKED 0x00001000
#define FLAG_RECV_CHUNKED 0x00002000

#define FLAG_SET(f, flag) flag |= f
#define FLAG_CLR(f, flag) flag &= ~f
#define FLAG_ISSET(f, flag) ((flag & f)!=0)

#endif
