#include "htlib2.h"
#include "log.h"

static void
logfunc(const char* file,
		int line,
		HTLIB_LOGLEVEL level,
		const char* msg)
{
	fprintf(stderr, "%s:%d: [lv=%d] %s", file, line, level, msg);
}

static HTLIB_LOG_HANDLER s_LogFunc = logfunc;

static int s_loglevelAndHigher = 3;

void
G(LOG)(const char* file, int line, HTLIB_LOGLEVEL level,
	   const char* format, ...)
{
	va_list ap;
	char buf[256];

	if (s_loglevelAndHigher < level || s_LogFunc == NULL) {
		return;
	}
	va_start(ap, format);

	vsnprintf(buf, sizeof(buf), format, ap);
	s_LogFunc(file, line, level, buf);

	va_end(ap);
}

void
G(SetLogHandler)(HTLIB_LOG_HANDLER handler)
{
	s_LogFunc = handler;
}
void
G(SetLogLevel)(HTLIB_LOGLEVEL levelOrHigher)
{
	s_loglevelAndHigher = levelOrHigher;
}

