#include "server.h"
#include "Response.h"

/*
 * test responses
 */
typedef struct {
	const char* path;
	Response res;
} PathResponse;

static const HTLIB_Header s_head1 = {
	"Content-Type", "text/plain", 0, NULL,
};

static const HTLIB_Header s_param2 = {
	"refresher", "client", 0, NULL,
};
static const HTLIB_Header s_head2[] = {
	{ "X-Session", "3600", 1, &s_param2, },
	{ "X-Data1", "data1; parm1=10; param2", 0, NULL, },
};

static const PathResponse s_res[] = {
	{
		"/",
		{
			200, "OK",
			&s_head1, 1,
			"This is a test.", /* body */
		}
	},
	{
		"/test1/200",
		{
			200, "OK",
			NULL, 0,
			NULL,
		}
	},
	{
		"/test2/100",
		{
			200, "OK",
			NULL, 0,
			"This is a test.\n",
		}
	},
	{
		"/test3/200",
		{
			200, "OK",
			s_head2, 2,
			NULL,
		}
	},
};

const Response*
findResponse(const char* path)
{
	int i;
	for (i=0; i<sizeof(s_res)/sizeof(s_res[0]); i++) {
		if (strcmp(path, s_res[i].path)==0) {
			return &s_res[i].res;
		}
	}
	return NULL;
}

typedef struct {
	int status;
	Response res;
} StatusResponse;

static const Response s_eres[] = {
	{
		400, "Bad request",
		NULL, 0,
		NULL,
	},
	{
		404, "Not Found",
		NULL, 0,
		NULL,
	},
};

const Response*
findErrorResponse(int status)
{
	int i;
	for (i=0; i<sizeof(s_eres)/sizeof(s_eres[0]); i++) {
		if (s_eres[i].status == status) {
			return &s_eres[i];
		}
	}
	return NULL;
}


