#ifndef _test_h
#define _test_h

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/times.h>

#include <stdlib.h>
#include <netinet/in.h>
#include <errno.h>
#include <pthread.h>

#include "../htlib.h"

typedef HTLIB_BOOL BOOL;
#define FALSE 0
#define TRUE 1

#define URLBASE "http://localhost:8000"

void fail(const char* id, const char* file, int line, HTLIB_ERROR err, int system_error, const char* format, ...);

#define FAIL(id, format, arg...) { HTLIB_Close(h); fail(id, __FILE__, __LINE__, err, h->system_errno, format, ##arg); }

void
succeed(const char* id, const char* file, int line);

#define SUCCEED(id) succeed(id, __FILE__, __LINE__);

BOOL
checkNoHeader(HTLIB_HANDLE h, HTLIB_Header* hh, int hlen,
			  const char* id, const char* name);
BOOL
checkHeader(HTLIB_HANDLE h, HTLIB_Header* hh, int hlen,
			const char* id, const char* name, const char* value);
BOOL
checkNotHeader(HTLIB_HANDLE h, HTLIB_Header* hh, int hlen,
			   const char* id, const char* name, const char* value);

int
receiveBody(HTLIB_HANDLE h, char* body, int bsize, const char* id);

BOOL
sendBodyChunk(HTLIB_HANDLE h, int timeout_millis, const void* body, int len,
			  HTLIB_ERROR* err);

#endif
