#include "test.h"
#include "cget.h"

#define HHMAX 30

static HTLIB_ERROR err;
static HTLIB_Header hh[HHMAX];
static HTLIB_USHORT hhlen;
static int status;

static const char* id = NULL;

static BOOL
chkNoHeader(HTLIB_HANDLE h, const char* name)
{
	return checkNoHeader(h, hh, hhlen, id, name);
}
static BOOL
chkHeader(HTLIB_HANDLE h, const char* name, const char* value)
{
	return checkHeader(h, hh, hhlen, id, name, value);
}
static BOOL
chkNotHeader(HTLIB_HANDLE h, const char* name, const char* value)
{
	return checkNotHeader(h, hh, hhlen, id, name, value);
}
static char body[10000];

static int
recvBody(HTLIB_HANDLE h)
{
	return receiveBody(h, body, sizeof(body), id);
}

static void
test1(HTLIB_HANDLE h, const char* path)
{
	if (HTLIB_SendRequest(h, -1, "GET", URLBASE "/", NULL, 0,
						  NULL, 0, &err)==FALSE) {
		FAIL("GET-1", "");
		return;
	}
	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Length", "5")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
		return;
	}
	int len;
	if ((len=recvBody(h))!=5) {
		FAIL(id, "%d must be 5", len);
		return;
	}
	if (memcmp(body, "index", len)!=0) {
		FAIL(id, "index != %.*s", len, body);
		return;
	}
	SUCCEED(id);
}	

static void
test2(HTLIB_HANDLE h, const char* path)
{
	if (HTLIB_SendRequest(h, 2000, "GET", URLBASE "/get/200", NULL, 0,
						  NULL, 0, &err)==FALSE) {
		FAIL(id, "");
		return;
	}
	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Length", "5")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "application/octet-stream")==FALSE) {
		return;
	}
	int len;
	if ((len=recvBody(h))!=5) {
		FAIL(id, "%d must be 5", len);
		return;
	}
	if (memcmp(body, "123\0005", 5)!=0) {
		FAIL(id, "123\\0005 != %.*s", 5, body);
		return;
	}
	SUCCEED(id);
}
static void
test3(HTLIB_HANDLE h, const char* path)
{
	if (HTLIB_SendRequest(h, -1, "GET", URLBASE "/get/404", NULL, 0,
						  NULL, 0, &err)==FALSE) {
		FAIL(id, "");
		return;
	}
	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Length", "6")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
		return;
	}
	int len;
	if ((len=recvBody(h))!=6) {
		FAIL(id, "%d must be 6", len);
		return;
	}
	if (memcmp(body, "err404", 6)!=0) {
		FAIL(id, "%.*s must be err404", 6, body);
		return;
	}
	SUCCEED(id);
}
static void
test4(HTLIB_HANDLE h, const char* path)
{
	if (HTLIB_SendRequest(h, -1, "GET", URLBASE "/get/chunk", NULL, 0,
						  NULL, 0, &err)==FALSE) {
		FAIL(id, "");
		return;
	}
	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkHeader(h, "Transfer-Encoding", "chunked")==FALSE) {
		return;
	}
	if (chkNoHeader(h, "Content-Length")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
		return;
	}
	int len;
	if ((len=recvBody(h))!=10) {
		FAIL(id, "%d must be 10", len);
		return;
	}
	if (memcmp(body, "1234567890", 10)!=0) {
		FAIL(id, "%.*s must be 1234567890", 10, body);
		return;
	}
	SUCCEED(id);
}
static void
test5(HTLIB_HANDLE h, const char* path)
{
	if (HTLIB_SendRequest(h, -1, "GET", URLBASE "/get/endbyclose1", NULL, 0,
						  NULL, 0, &err)==FALSE) {
		FAIL(id, "");
		return;
	}
	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkNoHeader(h, "Transfer-Encoding")==FALSE) {
		return;
	}
	if (chkNoHeader(h, "Content-Length")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "application/octet-stream")==FALSE) {
		return;
	}
	int len;
	if ((len=recvBody(h))!=5) {
		FAIL(id, "%d must be 5", len);
		return;
	}
	if (memcmp(body, "123\0005", 5)!=0) {
		FAIL(id, "%.*s must be 123\0005", 5, body);
		return;
	}
	SUCCEED(id);
}
static void
test6(HTLIB_HANDLE h, const char* path)
{
	const HTLIB_Header reqh[] = {
		{ "Connection", "close", 0, NULL },
		{ "Ignore", "XXX ignore", 0, NULL },
	};
	if (HTLIB_SendRequest(h, -1, "GET", URLBASE "/get/endbyclose2",
						  reqh, sizeof(reqh)/sizeof(reqh[0]),
						  NULL, 0, &err)==FALSE) {
		FAIL(id, "");
		return;
	}
	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkNoHeader(h, "Transfer-Encoding")==FALSE) {
		return;
	}
	if (chkNoHeader(h, "Content-Length")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
		return;
	}
	int len;
	if ((len=recvBody(h))!=10) {
		FAIL(id, "%d must be 10", len);
		return;
	}
	if (memcmp(body, "1234567890", 10)!=0) {
		FAIL(id, "%.*s must be 1234567890", 10, body);
		return;
	}
	SUCCEED(id);
}
static BOOL
test7sub(HTLIB_HANDLE h, const char* path)
{
	if (HTLIB_SendRequest(h, 2000, "GET", path, NULL, 0,
						  NULL, 0, &err)==FALSE) {
		FAIL(id, "");
		return FALSE;
	}
	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return FALSE;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return FALSE;
	}
	if (chkHeader(h, "Connection", "close")==FALSE) {
		return FALSE;
	}
	if (chkHeader(h, "Content-Length", "5")==FALSE) {
		return FALSE;
	}
	if (chkHeader(h, "Content-Type", "application/octet-stream")==FALSE) {
		return FALSE;
	}
	int len;
	if ((len=recvBody(h))!=5) {
		FAIL(id, "%d must be 5", len);
		return FALSE;
	}
	if (memcmp(body, "123\0005", 5)!=0) {
		FAIL(id, "123\\0005 != %.*s", 5, body);
		return FALSE;
	}
	return TRUE;
}
static void
test7(HTLIB_HANDLE h, const char* path)
{
	if (test7sub(h, URLBASE "/get/close1")==FALSE) {
		return;
	}
	if (test7sub(h, URLBASE "/get/close2")==FALSE) {
		return;
	}
	if (chkHeader(h, "X-Seq", "1")==FALSE) {
		return;
	}
	SUCCEED(id);
}
static BOOL
test8_1(HTLIB_HANDLE h, const char* path, const char* b)
{
	if (HTLIB_SendRequest(h, 2000, "GET", path, NULL, 0,
						  "12345", 5, &err)==FALSE) {
		FAIL(id, "");
		return FALSE;
	}
	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return FALSE;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return FALSE;
	}
	if (chkHeader(h, "Content-Length", "5")==FALSE) {
		return FALSE;
	}
	if (chkHeader(h, "Content-Type", "application/octet-stream")==FALSE) {
		return FALSE;
	}
	int len;
	if ((len=recvBody(h))!=5) {
		FAIL(id, "%d must be 5", len);
		return FALSE;
	}
	if (memcmp(body, b, 5)!=0) {
		FAIL(id, "%.*s must be %s", 5, body, b);
		return FALSE;
	}
	return TRUE;
}

static void
test8(HTLIB_HANDLE h, const char* path)
{
	if (test8_1(h, URLBASE "/get/body1", "body1")==FALSE) {
		return;
	}
	if (test8_1(h, URLBASE "/get/body2", "body2")==FALSE) {
		return;
	}
	if (chkNotHeader(h, "X-Seq", "1")==FALSE) {
		return;
	}
	SUCCEED(id);
}

void
testGet(HTLIB_HANDLE h)
{
	static struct {
		const char* id;
		const char* path;
		void(*func)(HTLIB_HANDLE, const char* path);
	} ff[] = {
		{ "GET-1(C)", "/", test1 },
		{ "GET-2(C)", "/get/200", test2 },
		{ "GET-3(C)", "/get/404", test3 },
		{ "GET-4(C)", "/get/chunk", test4 },
		{ "GET-5(C)", "/get/endbyclose1", test5 },
		{ "GET-6(C)", "/get/endbyclose2", test6 },
		{ "GET-7(C)", "/get/close1", test7 },
		{ "GET-8(C)", "/get/body1", test8 },
	};
	int i;
	for (i=0; i<sizeof(ff)/sizeof(ff[0]); i++) {
		id = ff[i].id;
		printf("Test %s...\n", id);
		ff[i].func(h, ff[i].path);
	}
}

